/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Util.AttributeOperatorValueGui;
import PatientSearchLibrary.Gui.SearchOperatorUi;
import PatientSearchLibrary.Search.SearchField;
import PatientSearchLibrary.Search.SearchTerm;
import javax.swing.JComponent;

public class SearchFieldUi {
    public static final String SERVLET_FIELD_PARAMETER_NAME_PREFIX = "sf";
    public static final String SERVLET_COMPARATOR_PARAMETER_NAME_PREFIX = "comparator";
    public static final int PATIENT_ID_INDEX = 0;
    public static final int PATIENT_NAME_INDEX = 1;
    public static final int ACCESSION_NUMBER_INDEX = 2;
    public static final int REFERRING_PHYSICIAN_INDEX = 3;
    public static final int STUDY_DESCRIPTION_INDEX = 4;
    public static final int SERIES_DESCRIPTION_INDEX = 5;
    static final String PATIENT_ID_KEY = SearchFieldUi.getUserPreferenceKeyFromIndex(0);
    static final String PATIENT_NAME_KEY = SearchFieldUi.getUserPreferenceKeyFromIndex(1);
    static final String ACCESSION_NUMBER_KEY = SearchFieldUi.getUserPreferenceKeyFromIndex(2);
    static final String REFERRING_PHYSICIAN_KEY = SearchFieldUi.getUserPreferenceKeyFromIndex(3);
    static final String STUDY_DESCRIPTION_KEY = SearchFieldUi.getUserPreferenceKeyFromIndex(4);
    static final String SERIES_DESCRIPTION_KEY = SearchFieldUi.getUserPreferenceKeyFromIndex(5);
    private static final String SEARCH_FIELD_USER_PREFERENCE_PREFIX = "SearchField";
    private String mUserPreferenceKey;
    private String mServletFieldParameterName;
    private String mServletComparatorParameterName;
    private SearchField mSearchField;
    private AttributeOperatorValueGui mAttributeOperatorValueGui;
    private JComponent mLabelUi;
    private JComponent mTextFieldUi;
    private JComponent mComparatorUi;
    private boolean mUseComparator;

    public static String getUserPreferenceKeyFromIndex(int n2) {
        return SEARCH_FIELD_USER_PREFERENCE_PREFIX + String.valueOf(n2 + 1);
    }

    SearchFieldUi(SearchField searchField, int n2, boolean bl2) {
        this.mSearchField = searchField;
        this.mUserPreferenceKey = SearchFieldUi.getUserPreferenceKeyFromIndex(n2);
        this.mServletFieldParameterName = SERVLET_FIELD_PARAMETER_NAME_PREFIX + n2;
        this.mServletComparatorParameterName = SERVLET_COMPARATOR_PARAMETER_NAME_PREFIX + n2;
        this.mAttributeOperatorValueGui = AttributeOperatorValueGui.createInstance(this.mSearchField.getLabel(), (Object[])SearchOperatorUi.COMPARATOR_OPTIONS, 10);
        this.mLabelUi = this.mAttributeOperatorValueGui.getAttributeComponent();
        this.mTextFieldUi = this.mAttributeOperatorValueGui.getValueComponent();
        this.mComparatorUi = this.mAttributeOperatorValueGui.getOperatorComponent();
        this.mAttributeOperatorValueGui.updateGui(this.mSearchField.getLabel(), SearchOperatorUi.getSearchOperatorUi(this.mSearchField.getOperator()), "");
        this.mUseComparator = bl2;
    }

    public String getUserPreferenceKey() {
        return this.mUserPreferenceKey;
    }

    public JComponent getLabelUi() {
        return this.mLabelUi;
    }

    public JComponent getTextFieldUi() {
        return this.mTextFieldUi;
    }

    public JComponent getComparatorUi() {
        return this.mComparatorUi;
    }

    private String getSearchOperator() {
        if (this.mUseComparator) {
            return ((SearchOperatorUi)this.mAttributeOperatorValueGui.getOperatorValue()).getKey();
        }
        return this.mSearchField.getOperator();
    }

    public SearchTerm getSearchTerm() {
        return new SearchTerm(this.mAttributeOperatorValueGui.getValue(), this.getSearchOperator(), this.mServletFieldParameterName, this.mServletComparatorParameterName);
    }
}

