/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import PatientSearchLibrary.Gui.SearchFieldUi;
import PatientSearchLibrary.Preferences.PatientSearchPreferenceProvider;
import PatientSearchLibrary.Preferences.SiteConfiguration;
import PatientSearchLibrary.Search.SearchClient;
import PatientSearchLibrary.Search.SeriesMoverClient;
import RuntimeTool.ControlFile;
import java.util.ArrayList;
import java.util.List;

public abstract class SearchSession {
    protected String mUsername;
    private SiteConfiguration mSiteConfiguration;
    private PatientSearchPreferenceProvider mPreferenceProvider;
    private List mSiteCodes;
    private String mPreferredSearchFieldKey1;
    private String mPreferredSearchFieldKey2;
    private boolean mSearchByPatientNameAllowed;

    public abstract SearchClient createSearchClient();

    public abstract SeriesMoverClient createSeriesMoverClient();

    protected SearchSession(String string) {
        this.mUsername = string;
    }

    protected SearchSession() {
    }

    public void loadSiteConfiguration(ControlFile controlFile) {
        this.mSiteConfiguration = new SiteConfiguration(controlFile);
    }

    public String getUsername() {
        return this.mUsername;
    }

    public SiteConfiguration getSiteConfiguration() {
        return this.mSiteConfiguration;
    }

    public PatientSearchPreferenceProvider getPreferenceProvider() {
        return this.mPreferenceProvider;
    }

    public boolean useSiteCodes() {
        return this.mSiteCodes != null && this.mSiteCodes.size() > 0;
    }

    public List getSiteCodes() {
        return this.mSiteCodes;
    }

    public void setSiteCodes(List list) {
        this.mSiteCodes = new ArrayList();
        if (list != null) {
            this.mSiteCodes.addAll(list);
        }
    }

    public String getPreferredSearchFieldKey1() {
        return this.mPreferredSearchFieldKey1;
    }

    public void setPreferredSearchFieldKey1(String string) {
        this.mPreferredSearchFieldKey1 = string;
    }

    public void setPreferredSearchFieldKey1(int n2) {
        this.mPreferredSearchFieldKey1 = SearchFieldUi.getUserPreferenceKeyFromIndex(n2);
    }

    public String getPreferredSearchFieldKey2() {
        return this.mPreferredSearchFieldKey2;
    }

    public void setPreferredSearchFieldKey2(String string) {
        this.mPreferredSearchFieldKey2 = string;
    }

    public void setPreferredSearchFieldKey2(int n2) {
        this.mPreferredSearchFieldKey2 = SearchFieldUi.getUserPreferenceKeyFromIndex(n2);
    }

    public boolean isSearchByPatientNameAllowed() {
        return this.mSearchByPatientNameAllowed;
    }

    public void setSearchByPatientNameAllowed(boolean bl2) {
        this.mSearchByPatientNameAllowed = bl2;
    }

    public ControlFile getControlFile() {
        return this.mSiteConfiguration.getControlFile();
    }

    public void setPreferenceProvider(PatientSearchPreferenceProvider patientSearchPreferenceProvider) {
        this.mPreferenceProvider = patientSearchPreferenceProvider;
    }
}

