/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Dialog.MultiMonitorOptionDialog;
import GuiUtilities.Util.GuiUtilities;
import GuiUtilities.Util.SwingWorker;
import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.RetrievalHandler;
import PatientSearchLibrary.Gui.RetrievalStatusListener;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Gui.StudyRetrieveStatus;
import PatientSearchLibrary.Retrieve.OfflineManager;
import PatientSearchLibrary.Retrieve.Retriever;
import PatientSearchLibrary.Search.LocationFinder;
import PatientSearchLibrary.View.LoadRequestType;
import PatientSearchLibrary.View.SeriesViewer;
import PatientSearchLibrary.View.ViewSet;
import PatientSearchLibrary.View.ViewSetLoader;
import StringUtilities.StringCheck;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.Iterator;
import java.util.List;

public class ViewWorker
extends SwingWorker {
    private SearchSession mSession;
    private Window mParentWindow;
    private ViewSet mViewSet;
    private SeriesViewer mSeriesViewer;
    private Retriever mRetriever;
    private LoadRequestType mLoadRequestType;
    private RetrievalStatusListener mRetrievalStatusListener;
    private List mSeriesToView;
    private boolean mFinished = false;
    private boolean mDataLoaded = false;
    private boolean mLoadWhenDataComesOnline = false;
    private boolean mAlwaysLoadAvailable = false;
    private String mErrorMessage = null;
    private final Runnable mInvokeWhenFinished;

    public ViewWorker(SearchSession searchSession, Window window, ViewSet viewSet, SeriesViewer seriesViewer, LoadRequestType loadRequestType, Retriever retriever, RetrievalStatusListener retrievalStatusListener, boolean bl2, boolean bl3, Runnable runnable) {
        this.mSession = searchSession;
        this.mParentWindow = window;
        this.mViewSet = viewSet;
        this.mSeriesViewer = seriesViewer;
        this.mLoadRequestType = loadRequestType;
        this.mRetriever = retriever;
        this.mRetrievalStatusListener = retrievalStatusListener;
        this.mLoadWhenDataComesOnline = bl2;
        this.mAlwaysLoadAvailable = bl3;
        this.mInvokeWhenFinished = runnable;
    }

    public ViewWorker(SearchSession searchSession, Window window, ViewSet viewSet, SeriesViewer seriesViewer, LoadRequestType loadRequestType, Retriever retriever, RetrievalStatusListener retrievalStatusListener) {
        this(searchSession, window, viewSet, seriesViewer, loadRequestType, retriever, retrievalStatusListener, false, false, null);
    }

    public Object construct() {
        try {
            this.mParentWindow.setCursor(new Cursor(3));
            boolean bl2 = LocationFinder.updateSeriesWithLocationInfo(this.mSession, this.mViewSet.getSelectedSeries(), this.mRetrievalStatusListener);
            if (bl2) {
                this.mSeriesToView = this.mViewSet.getSelectedSeries();
            } else {
                this.handleOfflineCase();
            }
            return null;
        }
        catch (LocationFinder.SeriesMoverClientException seriesMoverClientException) {
            this.mSeriesToView = null;
            this.mErrorMessage = "Error getting series locations: " + seriesMoverClientException.getMessage();
            GlobalState.error(this.mErrorMessage, seriesMoverClientException);
            return null;
        }
        catch (RuntimeException runtimeException) {
            this.workerFinished();
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finished() {
        try {
            if (this.mSeriesToView != null) {
                this.mSeriesViewer.loadSeries(this.mSeriesToView, this.mLoadRequestType);
            } else if (!StringCheck.isStringBlank(this.mErrorMessage)) {
                this.mSeriesViewer.showError(this.mErrorMessage);
            }
            Object var2_1 = null;
            this.workerFinished();
            this.mParentWindow.setCursor(new Cursor(0));
            if (this.mInvokeWhenFinished == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.workerFinished();
            this.mParentWindow.setCursor(new Cursor(0));
            if (this.mInvokeWhenFinished == null) throw throwable;
            EventQueue.invokeLater(this.mInvokeWhenFinished);
            throw throwable;
        }
        EventQueue.invokeLater(this.mInvokeWhenFinished);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerFinished() {
        ViewWorker viewWorker = this;
        synchronized (viewWorker) {
            this.mDataLoaded = this.mSeriesToView != null;
            this.mFinished = true;
            this.notifyAll();
        }
    }

    private void handleOfflineCase() {
        if (this.alreadyRetrievingStudies() || this.retrievalAcknowledged()) {
            this.handleOnlineSubset();
            OfflineManager.retrieveOfflineSubset(this.mViewSet.getOfflineStudies(), this.mRetriever, this.createRetrievalHandler());
        } else {
            this.handleOnlineSubset();
        }
    }

    private boolean retrievalAcknowledged() {
        return 0 == MultiMonitorOptionDialog.showConfirmDialog(this.mParentWindow, "Not all images are online.\nWould you like to retrieve images from archive?\n(Retrieval may take a few minutes)", "Retrieve offline images?", 0, 2);
    }

    private RetrievalHandler createRetrievalHandler() {
        if (this.mLoadWhenDataComesOnline) {
            ViewSetLoader viewSetLoader = new ViewSetLoader(this.mViewSet, this.mRetriever, this.mSeriesViewer, this.mLoadRequestType);
            return viewSetLoader;
        }
        StudyRetrieveStatus studyRetrieveStatus = new StudyRetrieveStatus("Retrieving offline data", this.mSession, this.mViewSet, this.mRetriever, this.mSeriesViewer);
        GuiUtilities.centerWindowOnParent(this.mParentWindow, studyRetrieveStatus);
        studyRetrieveStatus.setVisible(true);
        return studyRetrieveStatus;
    }

    private void handleOnlineSubset() {
        List list = this.mViewSet.getOnlineSeries();
        if (!list.isEmpty()) {
            if (this.mAlwaysLoadAvailable) {
                this.mSeriesToView = list;
            } else {
                int n2 = MultiMonitorOptionDialog.showConfirmDialog(this.mParentWindow, "View available images?", "View available images?", 0, 3);
                if (n2 == 0) {
                    this.mSeriesToView = list;
                }
            }
        }
    }

    private boolean alreadyRetrievingStudies() {
        Iterator iterator = this.mViewSet.getOfflineStudies().iterator();
        while (iterator.hasNext()) {
            if (this.mRetriever.isStudyBeingRetrieved((Study)iterator.next())) continue;
            return false;
        }
        return true;
    }

    protected boolean isDataLoaded() {
        return this.mDataLoaded;
    }

    protected synchronized void waitUntilFinished() throws InterruptedException {
        while (!this.mFinished) {
            this.wait();
        }
    }
}

