/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import DateUtilities.DateUtilities;
import PatientSearchLibrary.Data.DicomDirSeriesLocation;
import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Status;
import PatientSearchLibrary.Data.Study;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import com.archimed.dicom.DDate;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Person;
import com.archimed.dicom.tools.Sequences;
import com.intelerad.lib.dicomtools.DicomDir;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DicomDirSearchConverter {
    private static final String DEFAULT_STRING_VALUE = "";
    private static final SimpleDateFormat mDateTimeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");

    public static List convertStudies(DicomDir dicomDir) throws IOException, DicomException {
        ArrayList<Study> arrayList = new ArrayList<Study>();
        Iterator iterator = dicomDir.getPatientRecords().iterator();
        while (iterator.hasNext()) {
            DicomDir.PatientRecord patientRecord = (DicomDir.PatientRecord)iterator.next();
            Iterator iterator2 = patientRecord.getChildren().iterator();
            while (iterator2.hasNext()) {
                DicomDir.StudyRecord studyRecord = (DicomDir.StudyRecord)iterator2.next();
                Study study = DicomDirSearchConverter.convertStudy(dicomDir, patientRecord, studyRecord);
                arrayList.add(study);
            }
        }
        return arrayList;
    }

    public static Object getRequiredValue(DicomObject dicomObject, int n2) throws DicomDirException {
        Object object = dicomObject.get(n2);
        if (object != null) {
            return object;
        }
        throw new DicomDirException("Missing required Dicom value: DDict enum - " + DDict.getDescription((int)n2), n2);
    }

    public static String getOptionalStringValue(DicomObject dicomObject, int n2) throws DicomException {
        String string = dicomObject.getS(n2);
        if (string == null) {
            return DEFAULT_STRING_VALUE;
        }
        return string;
    }

    public static Study convertStudy(DicomDir dicomDir, DicomDir.PatientRecord patientRecord, DicomDir.StudyRecord studyRecord) throws DicomException {
        Object object;
        DDate dDate = (DDate)studyRecord.getDicomObject().get(64);
        String string = DicomDirSearchConverter.getOptionalStringValue(studyRecord.getDicomObject(), 70);
        String string2 = (String)DicomDirSearchConverter.getRequiredValue(studyRecord.getDicomObject(), 425);
        String string3 = DicomDirSearchConverter.getOptionalStringValue(studyRecord.getDicomObject(), 95);
        String string4 = DicomDirSearchConverter.getOptionalStringValue(studyRecord.getDicomObject(), 77);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n2 = studyRecord.getNumberOfChildren();
        hashMap.put("PatID", patientRecord.getPatientId());
        hashMap.put("StuInsUID", string2);
        hashMap.put("Ser%", String.valueOf(n2));
        hashMap.put("PName", DicomDirSearchConverter.convertPatientName(patientRecord.getPatientName()));
        hashMap.put("AccNum", string4);
        String string5 = DicomDirSearchConverter.formatDateAndTime(dDate, string);
        if (string5 == null) {
            DebugManager.getDefault().printWarning("Unable to parse study date and time in DICOMDIR. Date: [" + dDate + "], Time: [" + string + "].  Using placeholder [" + DEFAULT_STRING_VALUE + "].");
            string5 = DEFAULT_STRING_VALUE;
        }
        hashMap.put("StuDate", string5);
        if (n2 > 0) {
            object = studyRecord.getChild(0).getDicomObject().getS(81);
            hashMap.put("Mod", object);
        }
        hashMap.put("StuDes", string3);
        hashMap.put("Status", Status.ONLINE);
        object = new Study(hashMap);
        Iterator iterator = studyRecord.getChildren().iterator();
        while (iterator.hasNext()) {
            DicomDir.SeriesRecord seriesRecord = (DicomDir.SeriesRecord)iterator.next();
            Map map = DicomDirSearchConverter.convertSeriesParameters(dicomDir, seriesRecord);
            map.put("PatID", patientRecord.getPatientId());
            map.put("PName", DicomDirSearchConverter.convertPatientName(patientRecord.getPatientName()));
            ((Study)object).addSeries(new Series(map, (Study)object));
        }
        return object;
    }

    private static Map convertSeriesParameters(DicomDir dicomDir, DicomDir.SeriesRecord seriesRecord) throws DicomDirException {
        String string = (String)DicomDirSearchConverter.getRequiredValue(seriesRecord.getDicomObject(), 426);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Mod", DicomDirSearchConverter.getRequiredValue(seriesRecord.getDicomObject(), 81));
        hashMap.put("SerInsUID", string);
        hashMap.put("Image%", String.valueOf(DicomDirSearchConverter.getNumberOfImages(seriesRecord)));
        hashMap.put("Status", Status.ONLINE);
        Integer n2 = (Integer)seriesRecord.getDicomObject().get(428);
        String string2 = (String)seriesRecord.getDicomObject().get(97);
        String string3 = DicomDirSearchConverter.getDateTimeFromRecord(seriesRecord.getDicomObject());
        if (string2 == null || string3 == null || n2 == null) {
            try {
                DicomObject dicomObject = DicomDirSearchConverter.getReferencedFileDicomObject(dicomDir, seriesRecord.getChild(0));
                if (string2 == null) {
                    string2 = (String)dicomObject.get(97);
                }
                if (string3 == null) {
                    string3 = DicomDirSearchConverter.getDateTimeFromRecord(dicomObject);
                }
                if (n2 == null) {
                    n2 = (Integer)dicomObject.get(428);
                }
            }
            catch (DicomException dicomException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                DebugManager.getDefault().printException("Error getting series description, date/time, or number", exception);
            }
            if (string2 == null) {
                string2 = DEFAULT_STRING_VALUE;
            }
            if (string3 == null) {
                string3 = DEFAULT_STRING_VALUE;
            }
            if (n2 == null) {
                n2 = new Integer(1);
            }
        }
        hashMap.put("SerNum", n2.toString());
        hashMap.put("SerDate", string3);
        hashMap.put("SerDes", string2);
        DicomDirSearchConverter.addSeriesLocation(hashMap, dicomDir, seriesRecord, string);
        return hashMap;
    }

    private static int getNumberOfImages(DicomDir.SeriesRecord seriesRecord) {
        int n2 = 0;
        for (int i2 = 0; i2 < seriesRecord.getNumberOfChildren(); ++i2) {
            DicomObject dicomObject = seriesRecord.getChild(i2).getDicomObject();
            Object object = dicomObject.get(48);
            if (object.equals("IMAGE")) {
                ++n2;
                continue;
            }
            if (!object.equals("PRESENTATION")) continue;
            n2 += DicomDirSearchConverter.getNumberReferencedImages(dicomObject);
        }
        return n2;
    }

    private static int getNumberReferencedImages(DicomObject dicomObject) {
        int n2 = 0;
        Sequences sequences = new Sequences(dicomObject);
        for (int i2 = 0; i2 < dicomObject.getSize(109); ++i2) {
            try {
                n2 += sequences.getSize(109, i2, 113);
                continue;
            }
            catch (DicomException dicomException) {
                DebugManager.getDefault().printException("Could not obtain size of Referenced Image Sequence for series index " + i2, dicomException);
            }
        }
        return n2;
    }

    private static void addSeriesLocation(Map map, DicomDir dicomDir, DicomDir.SeriesRecord seriesRecord, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i2 = 0; i2 < seriesRecord.getNumberOfChildren(); ++i2) {
            DicomDir.DirectoryRecord directoryRecord = seriesRecord.getChild(i2);
            try {
                File file = directoryRecord.getReferencedFile();
                if (file == null) continue;
                arrayList.add(new File(dicomDir.getFilesetRoot(), file.getPath()));
                continue;
            }
            catch (DicomException dicomException) {
                DebugManager.getDefault().printException("Invalid path name; skipping image file", dicomException);
            }
        }
        map.put("SeriesLocation", new DicomDirSeriesLocation(string, arrayList));
    }

    static String formatDateAndTime(DDate dDate, String string) {
        if (dDate == null || string == null) {
            return null;
        }
        Date date = DateUtilities.getDate(dDate.toDICOMString(), string);
        if (date == null) {
            return null;
        }
        return mDateTimeFormat.format(date);
    }

    private static String getDateTimeFromRecord(DicomObject dicomObject) {
        return DicomDirSearchConverter.formatDateAndTime((DDate)dicomObject.get(65), (String)dicomObject.get(71));
    }

    public static String convertPatientName(Person person) {
        String string = person.familyName + (StringCheck.isStringBlank(person.givenName) ? DEFAULT_STRING_VALUE : ", " + person.givenName) + " " + person.middleName + " " + person.prefix + " " + person.suffix;
        return string.trim();
    }

    public static DicomObject getReferencedFileDicomObject(DicomDir dicomDir, DicomDir.DirectoryRecord directoryRecord) throws IOException, DicomException {
        File file = new File(dicomDir.getFilesetRoot(), directoryRecord.getReferencedFile().getPath());
        FileInputStream fileInputStream = new FileInputStream(file);
        DicomObject dicomObject = new DicomObject();
        dicomObject.read((InputStream)fileInputStream, false);
        fileInputStream.close();
        return dicomObject;
    }

    public static class DicomDirException
    extends DicomException {
        private final int mKey;

        public DicomDirException(String string, int n2) {
            super(string);
            this.mKey = n2;
        }

        public int getKey() {
            return this.mKey;
        }
    }
}

