/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.View;

import PatientSearchLibrary.Data.DataComparator;
import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Status;
import PatientSearchLibrary.Data.Study;
import RuntimeTool.DebugManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ViewSet {
    List mSelectedStudiesOrSeries;
    List mSelectedSeries;
    boolean mSeriesSelected;

    public ViewSet(List list) {
        if (list != null && list.size() > 0) {
            this.mSeriesSelected = list.get(0) instanceof Series;
        }
        this.mSelectedStudiesOrSeries = this.sort(list);
    }

    private List sort(List list) {
        Object object;
        if (list == null) {
            return null;
        }
        DataComparator dataComparator = new DataComparator("PName", true, "SerDate", true, "SerNum", true);
        if (this.mSeriesSelected) {
            Object[] objectArray = list.toArray();
            Arrays.sort(objectArray, dataComparator);
            return Arrays.asList(objectArray);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Study)iterator.next();
            ((Study)object).sortSeries(dataComparator);
        }
        object = list.toArray();
        DataComparator dataComparator2 = new DataComparator("PName", true, "StuDate", true, null, true);
        Arrays.sort(object, dataComparator2);
        return Arrays.asList(object);
    }

    public List getSelectedStudiesOrSeries() {
        return this.mSelectedStudiesOrSeries;
    }

    public boolean isSeriesSelected() {
        return this.mSeriesSelected;
    }

    public List getSelectedSeries() {
        if (this.mSelectedSeries == null) {
            if (this.mSeriesSelected) {
                this.mSelectedSeries = this.mSelectedStudiesOrSeries;
            } else {
                ArrayList arrayList = new ArrayList();
                int n2 = this.mSelectedStudiesOrSeries.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Study study = (Study)this.mSelectedStudiesOrSeries.get(i2);
                    arrayList.addAll(study.getSeriesMap().values());
                }
                this.mSelectedSeries = arrayList;
            }
        }
        return this.mSelectedSeries;
    }

    public boolean containsSeries(Series series) {
        String string = (String)series.getValue(series.getUidKey());
        if (this.mSeriesSelected) {
            Iterator iterator = this.mSelectedStudiesOrSeries.iterator();
            while (iterator.hasNext()) {
                Series series2 = (Series)iterator.next();
                if (!string.equals(series2.getValue(series.getUidKey()))) continue;
                return true;
            }
        } else {
            Iterator iterator = this.mSelectedStudiesOrSeries.iterator();
            while (iterator.hasNext()) {
                Study study = (Study)iterator.next();
                if (!study.getSeriesMap().containsKey(string)) continue;
                return true;
            }
        }
        return false;
    }

    public List getOnlineSeries() {
        ArrayList<Series> arrayList = new ArrayList<Series>();
        if (this.mSeriesSelected) {
            int n2 = this.mSelectedStudiesOrSeries.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Series series = (Series)this.mSelectedStudiesOrSeries.get(i2);
                Status status = (Status)series.getValue("Status");
                if (status != Status.ONLINE) continue;
                arrayList.add(series);
            }
        } else {
            int n3 = this.mSelectedStudiesOrSeries.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                Study study = (Study)this.mSelectedStudiesOrSeries.get(i3);
                Status status = (Status)study.getValue("Status");
                if (status == Status.ONLINE) {
                    arrayList.addAll(study.getSeriesMap().values());
                    continue;
                }
                Iterator iterator = study.getSeriesMap().values().iterator();
                while (iterator.hasNext()) {
                    Series series = (Series)iterator.next();
                    Status status2 = (Status)series.getValue("Status");
                    if (status2 != Status.ONLINE) continue;
                    arrayList.add(series);
                }
            }
        }
        return arrayList;
    }

    public Set getOfflineStudies() {
        LinkedHashSet<Study> linkedHashSet = new LinkedHashSet<Study>();
        if (this.mSeriesSelected) {
            int n2 = this.mSelectedStudiesOrSeries.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Series series = (Series)this.mSelectedStudiesOrSeries.get(i2);
                Status status = (Status)series.getValue("Status");
                if (status != Status.OFFLINE && status != Status.UNAVAILABLE) continue;
                linkedHashSet.add(series.getStudy());
            }
        } else {
            int n3 = this.mSelectedStudiesOrSeries.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                Study study = (Study)this.mSelectedStudiesOrSeries.get(i3);
                Status status = (Status)study.getValue("Status");
                if (status != Status.OFFLINE && status != Status.UNAVAILABLE) continue;
                linkedHashSet.add(study);
            }
        }
        return linkedHashSet;
    }

    public int getOfflineElementsCount() {
        int n2 = 0;
        int n3 = this.mSelectedStudiesOrSeries.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Object e2 = this.mSelectedStudiesOrSeries.get(i2);
            Status status = e2 instanceof Series ? (Status)((Series)e2).getValue("Status") : (Status)((Study)e2).getValue("Status");
            if (status != Status.OFFLINE && status != Status.UNAVAILABLE) continue;
            ++n2;
        }
        return n2;
    }

    public int getOfflineSeriesCount() {
        int n2 = 0;
        List list = this.getSelectedSeries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Series series = (Series)iterator.next();
            Status status = (Status)series.getValue("Status");
            if (status != Status.OFFLINE) continue;
            ++n2;
        }
        return n2;
    }

    public boolean hasUnavailableSeries() {
        List list = this.getSelectedSeries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Series series = (Series)iterator.next();
            Status status = (Status)series.getValue("Status");
            if (status != Status.UNAVAILABLE) continue;
            DebugManager.getDefault().printTrace("Series [" + series + "] has status " + status);
            return true;
        }
        return false;
    }

    public boolean hasSeriesWithUnknownStatus() {
        List list = this.getSelectedSeries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Series series = (Series)iterator.next();
            Status status = (Status)series.getValue("Status");
            if (status != Status.UNKNOWN) continue;
            DebugManager.getDefault().printTrace("Series [" + series + "] has status " + status);
            return true;
        }
        return false;
    }

    public String getTitle() {
        if (this.mSeriesSelected) {
            return "Selected series";
        }
        return "Selected studies";
    }
}

