/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Export;

import ReportViewerLibrary.Export.ExportConfiguration;
import ReportViewerLibrary.Gui.ReportViewer;
import ReportViewerLibrary.Util.ReportViewerUtil;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.Patient;
import java.util.HashMap;
import java.util.Map;

public abstract class HeaderField {
    private final ExportConfiguration.HeaderFieldType mType;
    private String mLabel;

    public HeaderField(ExportConfiguration.HeaderFieldType headerFieldType, String string) {
        this.mType = headerFieldType;
        this.mLabel = string;
    }

    public ExportConfiguration.HeaderFieldType getType() {
        return this.mType;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setLabel(String string) {
        this.mLabel = string;
    }

    public abstract String getValue(OrderHeader var1, Patient var2);

    public static Map getAllHeaderFields() {
        HashMap hashMap = new HashMap();
        HeaderField.addDefaultHeaderField(new PatientNameField(), hashMap);
        HeaderField.addDefaultHeaderField(new PatientDateOfBirthField(), hashMap);
        HeaderField.addDefaultHeaderField(new PatientIdField(), hashMap);
        HeaderField.addDefaultHeaderField(new ReferringPhysicianField(), hashMap);
        HeaderField.addDefaultHeaderField(new OrganizationField(), hashMap);
        HeaderField.addDefaultHeaderField(new StudyDateField(), hashMap);
        HeaderField.addDefaultHeaderField(new AccessionNumberField(), hashMap);
        HeaderField.addDefaultHeaderField(new RequestedProcedureIdField(), hashMap);
        HeaderField.addDefaultHeaderField(new StudyDescriptionField(), hashMap);
        HeaderField.addDefaultHeaderField(new ModalityField(), hashMap);
        HeaderField.addDefaultHeaderField(new ReportingMDField(), hashMap);
        HeaderField.addDefaultHeaderField(new DictatedStudyDateField(), hashMap);
        return hashMap;
    }

    private static void addDefaultHeaderField(HeaderField headerField, Map map) {
        map.put(headerField.getType(), headerField);
    }

    public static class DictatedStudyDateField
    extends HeaderField {
        public DictatedStudyDateField() {
            this("Dictated Study Date");
        }

        public DictatedStudyDateField(String string) {
            super(ExportConfiguration.HeaderFieldType.DICTATED_STUDY_DATE, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            if (orderHeader.getDictatedStudyDate() == null) {
                return "Not available";
            }
            return ReportViewerUtil.DEFAULT_DATETIME_FORMAT.format(orderHeader.getDictatedStudyDate().getTime());
        }
    }

    public static class ReportingMDField
    extends HeaderField {
        public ReportingMDField() {
            this("Reporting MD");
        }

        public ReportingMDField(String string) {
            super(ExportConfiguration.HeaderFieldType.REPORTING_MD, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getReportingMd();
        }
    }

    public static class ModalityField
    extends HeaderField {
        public ModalityField() {
            this("Modality");
        }

        public ModalityField(String string) {
            super(ExportConfiguration.HeaderFieldType.MODALITY, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getModality();
        }
    }

    public static class StudyDescriptionField
    extends HeaderField {
        public StudyDescriptionField() {
            this("Study Description");
        }

        public StudyDescriptionField(String string) {
            super(ExportConfiguration.HeaderFieldType.STUDY_DESCRIPTION, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getDescription();
        }
    }

    public static class RequestedProcedureIdField
    extends HeaderField {
        public RequestedProcedureIdField() {
            this("Requested Proc. ID");
        }

        public RequestedProcedureIdField(String string) {
            super(ExportConfiguration.HeaderFieldType.REQUESTED_PROCEDURE_ID, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getRequestedProcedureId();
        }
    }

    public static class AccessionNumberField
    extends HeaderField {
        public AccessionNumberField() {
            this("Accession Number");
        }

        public AccessionNumberField(String string) {
            super(ExportConfiguration.HeaderFieldType.ACCESSION, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getAccession();
        }
    }

    public static class StudyDateField
    extends HeaderField {
        public StudyDateField() {
            this("Date of Study");
        }

        public StudyDateField(String string) {
            super(ExportConfiguration.HeaderFieldType.STUDY_DATE, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return ReportViewer.formatOrderHeaderStudyDateTime(orderHeader, "UNKNOWN");
        }
    }

    public static class OrganizationField
    extends HeaderField {
        public OrganizationField() {
            this("Organization");
        }

        public OrganizationField(String string) {
            super(ExportConfiguration.HeaderFieldType.ORGANIZATION, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getOrganization() != null ? orderHeader.getOrganization() : "Not available";
        }
    }

    public static class ReferringPhysicianField
    extends HeaderField {
        public ReferringPhysicianField() {
            this("Referring Physician");
        }

        public ReferringPhysicianField(String string) {
            super(ExportConfiguration.HeaderFieldType.REFERING_PHYSICIAN, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getReferringPhysician();
        }
    }

    public static class PatientIdField
    extends HeaderField {
        public PatientIdField() {
            this("Patient ID");
        }

        public PatientIdField(String string) {
            super(ExportConfiguration.HeaderFieldType.PATIENT_ID, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return patient.getId();
        }
    }

    public static class PatientDateOfBirthField
    extends HeaderField {
        public PatientDateOfBirthField() {
            this("Patient DOB");
        }

        public PatientDateOfBirthField(String string) {
            super(ExportConfiguration.HeaderFieldType.PATIENT_DATE_OF_BIRTH, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return ReportViewer.formatPatientBirthDate(patient);
        }
    }

    public static class PatientNameField
    extends HeaderField {
        public PatientNameField() {
            this("Patient");
        }

        public PatientNameField(String string) {
            super(ExportConfiguration.HeaderFieldType.PATIENT_NAME, string);
        }

        public String getValue(OrderHeader orderHeader, Patient patient) {
            return patient.getName();
        }
    }
}

