/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Gui;

import GuiUtilities.Dialog.MultiMonitorOptionDialog;
import GuiUtilities.Util.AlwaysOnTop;
import GuiUtilities.Util.GuiUtilities;
import HtmlUtilities.ImpressionsFormatter;
import ReportViewerLibrary.Gui.ReportViewer;
import ReportViewerLibrary.Gui.ReportsPane;
import ReportViewerLibrary.Preferences.ReportViewerPreferenceProvider;
import ReportViewerXml.Order;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.Patient;
import RuntimeTool.Debug;
import StringUtilities.StringCheck;
import StringUtilities.StringEncoder;
import UserXml.XmlUser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ImpressionsTool
extends JFrame
implements ActionListener {
    private ReportsPane mReportsPane;
    private ReportViewerPreferenceProvider mUserPreferences;
    private Patient mPatient;
    private OrderHeader mOrderHeader;
    private Order mOrder;
    private String mExamId;
    private XmlUser mXmlUser;
    private String mUrlString;
    private String mHostname;
    private Debug mDebug;
    private JPanel mStudyPane;
    private JPanel mImpressionsPane;
    private JPanel mControlPane;
    private JEditorPane mPreviousImpressionsTextPane;
    private JEditorPane mNewImpressionTextPane;
    private JTextField mTelephoneField;
    private JTextField mPagerField;
    private JButton mSubmitButton;
    private JButton mCancelButton;
    private JPanel mClinicianPane;
    private SimpleDateFormat mImpressionDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.0");
    private static final String EIT_SERVLET_PATH = "/Eit/Eit.Execute";

    public ImpressionsTool(Frame frame, ReportsPane reportsPane, ReportViewerPreferenceProvider reportViewerPreferenceProvider, Patient patient, XmlUser xmlUser, String string, Debug debug) {
        super("New Impression");
        this.setDefaultCloseOperation(2);
        this.mReportsPane = reportsPane;
        this.mUserPreferences = reportViewerPreferenceProvider;
        this.mPatient = patient;
        this.mOrderHeader = this.mReportsPane.getCurrentOrderHeader();
        this.mOrder = this.mReportsPane.getCurrentOrder();
        this.mExamId = this.mReportsPane.getCurrentExamId();
        this.mXmlUser = xmlUser;
        this.mUrlString = string;
        this.mDebug = debug;
        this.guiInit();
        this.setSize(frame.getWidth(), (int)((double)frame.getHeight() * 0.8));
        GuiUtilities.centerWindowOnParent(frame, this);
    }

    private void guiInit() {
        String string = "/ReportViewerLibrary/Gui/Icons/impressions.png";
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(string));
        this.setIconImage(imageIcon.getImage());
        this.createStudyPane();
        this.createImpressionsPane();
        this.createClinicianPane();
        this.createControlPane();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        jPanel.setLayout(new BorderLayout());
        jPanel.add("North", this.mStudyPane);
        jPanel.add("Center", this.mImpressionsPane);
        jPanel.add("South", this.mClinicianPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", jPanel);
        this.getContentPane().add("South", this.mControlPane);
    }

    private void createControlPane() {
        this.mControlPane = new JPanel();
        this.mSubmitButton = new JButton("Submit");
        this.mSubmitButton.addActionListener(this);
        this.mCancelButton = new JButton("Cancel");
        this.mCancelButton.addActionListener(this);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.mSubmitButton);
        box.add(Box.createHorizontalStrut(24));
        box.add(this.mCancelButton);
        box.add(Box.createHorizontalGlue());
        this.mControlPane.add(box);
    }

    private void createStudyPane() {
        this.mStudyPane = new JPanel();
        this.mStudyPane.setBorder(new TitledBorder(new EtchedBorder(), " Study Information "));
        this.mStudyPane.setLayout(new BoxLayout(this.mStudyPane, 0));
        JLabel jLabel = new JLabel("Patient");
        JTextField jTextField = new JTextField(this.mPatient.getName());
        jTextField.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 0, 6));
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        JLabel jLabel2 = new JLabel("ID");
        JTextField jTextField2 = new JTextField(this.mPatient.getId());
        jTextField2.setEditable(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1, 0, 6));
        jPanel2.add(jLabel2);
        jPanel2.add(jTextField2);
        JLabel jLabel3 = new JLabel("DOB");
        JTextField jTextField3 = new JTextField(ReportViewer.formatPatientBirthDate(this.mPatient));
        jTextField3.setEditable(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1, 0, 6));
        jPanel3.add(jLabel3);
        jPanel3.add(jTextField3);
        JLabel jLabel4 = new JLabel("Sex");
        JTextField jTextField4 = new JTextField(this.mPatient.getSex());
        jTextField4.setEditable(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.setMaximumSize(new Dimension(40, 200));
        jPanel4.setLayout(new GridLayout(2, 1, 0, 6));
        jPanel4.add(jLabel4);
        jPanel4.add(jTextField4);
        JLabel jLabel5 = new JLabel("Accession");
        JTextField jTextField5 = new JTextField(this.mOrderHeader.getAccession());
        jTextField5.setEditable(false);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(2, 1, 0, 6));
        jPanel5.add(jLabel5);
        jPanel5.add(jTextField5);
        JLabel jLabel6 = new JLabel("Modality");
        JTextField jTextField6 = new JTextField(this.mOrderHeader.getModality());
        jTextField6.setEditable(false);
        JPanel jPanel6 = new JPanel();
        jPanel6.setMaximumSize(new Dimension(70, 200));
        jPanel6.setLayout(new GridLayout(2, 1, 0, 6));
        jPanel6.add(jLabel6);
        jPanel6.add(jTextField6);
        this.mStudyPane.add(jPanel);
        this.mStudyPane.add(Box.createHorizontalStrut(6));
        this.mStudyPane.add(jPanel2);
        this.mStudyPane.add(Box.createHorizontalStrut(6));
        this.mStudyPane.add(jPanel3);
        this.mStudyPane.add(Box.createHorizontalStrut(6));
        this.mStudyPane.add(jPanel4);
        this.mStudyPane.add(Box.createHorizontalStrut(6));
        this.mStudyPane.add(jPanel5);
        this.mStudyPane.add(Box.createHorizontalStrut(6));
        this.mStudyPane.add(jPanel6);
    }

    private void createImpressionsPane() {
        this.mImpressionsPane = new JPanel();
        this.mImpressionsPane.setBorder(new TitledBorder(new EtchedBorder(), " Impressions "));
        this.mImpressionsPane.setLayout(new GridLayout(2, 1));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Previous Impressions");
        this.mPreviousImpressionsTextPane = new JEditorPane();
        this.mPreviousImpressionsTextPane.setBackground(Color.LIGHT_GRAY);
        this.mPreviousImpressionsTextPane.setContentType("text/html");
        this.mPreviousImpressionsTextPane.setEditable(false);
        if (StringCheck.isStringBlank(this.mOrder.getImpression())) {
            this.mPreviousImpressionsTextPane.setText("No Impressions have been submitted.");
        } else {
            this.mPreviousImpressionsTextPane.setText(this.mOrder.getImpression());
        }
        JScrollPane jScrollPane = new JScrollPane(this.mPreviousImpressionsTextPane);
        jPanel.add("North", jLabel);
        jPanel.add("Center", jScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(6, 6, 6, 6));
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel2 = new JLabel("New Impression");
        this.mNewImpressionTextPane = new ImpressionEditor();
        this.mNewImpressionTextPane.setBackground(Color.LIGHT_GRAY);
        this.mNewImpressionTextPane.setPreferredSize(new Dimension(0, 0));
        JScrollPane jScrollPane2 = new JScrollPane(this.mNewImpressionTextPane);
        jPanel2.add("North", jLabel2);
        jPanel2.add("Center", jScrollPane2);
        this.mImpressionsPane.add(jPanel);
        this.mImpressionsPane.add(jPanel2);
    }

    private void createClinicianPane() {
        this.mClinicianPane = new JPanel();
        this.mClinicianPane.setBorder(new TitledBorder(new EtchedBorder(), " Clinician Information "));
        this.mClinicianPane.setLayout(new GridLayout(2, 4, 6, 6));
        JLabel jLabel = new JLabel("Name");
        JTextField jTextField = new JTextField(this.mXmlUser.getFirstName() + " " + this.mXmlUser.getLastName());
        jTextField.setEditable(false);
        JLabel jLabel2 = new JLabel("Username");
        JTextField jTextField2 = new JTextField(this.mXmlUser.getUsername());
        jTextField2.setEditable(false);
        JLabel jLabel3 = new JLabel("Telephone");
        this.mTelephoneField = new JTextField(this.mXmlUser.getTelephone1());
        this.mTelephoneField.setBackground(Color.GRAY);
        this.mTelephoneField.setForeground(Color.WHITE);
        JLabel jLabel4 = new JLabel("Pager");
        this.mPagerField = new JTextField(this.mXmlUser.getTelephone2());
        this.mPagerField.setBackground(Color.GRAY);
        this.mPagerField.setForeground(Color.WHITE);
        this.mClinicianPane.add(jLabel);
        this.mClinicianPane.add(jLabel2);
        this.mClinicianPane.add(jLabel3);
        this.mClinicianPane.add(jLabel4);
        this.mClinicianPane.add(jTextField);
        this.mClinicianPane.add(jTextField2);
        this.mClinicianPane.add(this.mTelephoneField);
        this.mClinicianPane.add(this.mPagerField);
    }

    private void postDataToServlet(PrintWriter printWriter) {
        printWriter.print("action=set");
        printWriter.print("&accession=" + StringEncoder.urlEncodeISO_8859_1(this.mOrder.getAccession().trim(), this.mDebug));
        printWriter.print("&username=" + StringEncoder.urlEncodeISO_8859_1(this.mXmlUser.getUsername().trim(), this.mDebug));
        printWriter.print("&hostname=" + StringEncoder.urlEncodeISO_8859_1(this.mHostname, this.mDebug));
        printWriter.print("&phone1=" + StringEncoder.urlEncodeISO_8859_1(this.mTelephoneField.getText().trim(), this.mDebug));
        printWriter.print("&phone2=" + StringEncoder.urlEncodeISO_8859_1(this.mPagerField.getText().trim(), this.mDebug));
        printWriter.print("&text=" + StringEncoder.urlEncodeISO_8859_1(this.mNewImpressionTextPane.getText(), this.mDebug));
    }

    private boolean submitNewImpression() {
        String string = null;
        try {
            if (StringCheck.isStringBlank(this.mNewImpressionTextPane.getText().trim())) {
                string = "Cannot submit empty impression text.";
            } else {
                this.mHostname = InetAddress.getLocalHost().getHostName();
                URL uRL = new URL(this.mUrlString);
                URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), EIT_SERVLET_PATH);
                this.mDebug.printTrace("Submitting impression to server. URL is [" + uRL2.toString() + "]");
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestMethod("POST");
                PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
                this.postDataToServlet(printWriter);
                printWriter.flush();
                printWriter.close();
                InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                this.mDebug.printTrace("Parsing data returned from server");
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    string = "Server did not acknowledge.";
                } else if (!string2.startsWith("OK")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string2);
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuffer.append("\n");
                        stringBuffer.append(string2);
                    }
                    string = "Error received from server when submitting impression: \n" + stringBuffer.toString();
                } else {
                    this.mDebug.printTrace("Eit Servlet returned 'OK'.");
                }
            }
        }
        catch (Exception exception) {
            string = "Error submitting impression to server: " + exception.getMessage();
            this.mDebug.printException("", exception);
        }
        if (string != null) {
            this.mDebug.printError(string);
            MultiMonitorOptionDialog.showMessageDialog(this, string, "Error submitting impression", 0);
            return false;
        }
        return true;
    }

    void updateImpression(String string) {
        String string2 = this.mOrder.getImpression();
        if (StringCheck.isStringBlank(string2)) {
            this.mOrder.setImpression(ImpressionsFormatter.addHtmlStyleAndBodyTags(string));
        } else {
            int n2 = string2.indexOf("<body>\n");
            if (n2 < 0) {
                n2 = string2.indexOf("<BODY>\n");
            }
            if (n2 >= 0) {
                this.mOrder.setImpression(string2.substring(0, n2 + 7) + string + "<p>\n" + string2.substring(n2 + 7));
            } else {
                this.mOrder.setImpression(string + "<p>\n" + string2);
            }
        }
        if (this.mReportsPane.getCurrentOrder() == this.mOrder) {
            this.mReportsPane.update(this.mExamId);
        }
    }

    public void submit() {
        if (this.submitNewImpression()) {
            this.updateImpression(ImpressionsFormatter.impressionToHtml(this.mNewImpressionTextPane.getText(), this.mXmlUser.getLastName(), this.mXmlUser.getFirstName(), this.mXmlUser.getUsername(), this.mImpressionDateFormat.format(new Date()), this.mHostname, this.mTelephoneField.getText().trim(), this.mPagerField.getText().trim()));
            this.dispose();
        } else {
            this.mNewImpressionTextPane.requestFocusInWindow();
        }
    }

    public void cancel() {
        this.dispose();
    }

    private void resetAlwaysOnTop() {
        AlwaysOnTop.setAlwaysOnTop(this, this.mUserPreferences.isAlwaysOnTop());
    }

    public void show() {
        super.show();
        this.resetAlwaysOnTop();
        this.mNewImpressionTextPane.requestFocusInWindow();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mSubmitButton) {
            this.submit();
        } else if (actionEvent.getSource() == this.mCancelButton) {
            this.cancel();
        }
    }

    class ImpressionEditor
    extends JEditorPane {
        ImpressionEditor() {
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ImpressionEditor this$1;
                {
                    this.this$1 = impressionEditor;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getModifiers() == 2 && keyEvent.getKeyCode() == 10) {
                        ImpressionEditor.access$000(this.this$1).submit();
                    }
                }
            });
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        static /* synthetic */ ImpressionsTool access$000(ImpressionEditor impressionEditor) {
            return impressionEditor.ImpressionsTool.this;
        }
    }
}

