/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Gui;

import ReportViewerLibrary.Gui.InformationArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SplitInformationArea
extends JPanel
implements InformationArea {
    private JSplitPane mOuterSplitPane;
    private JSplitPane mInnerSplitPane;
    private int mPaneCount = 0;

    public SplitInformationArea() {
        this.guiInit();
    }

    private void guiInit() {
        this.setLayout(new BorderLayout());
        this.mOuterSplitPane = new JSplitPane(0);
        this.mOuterSplitPane.setOneTouchExpandable(true);
        this.mOuterSplitPane.setResizeWeight(0.33);
        this.mInnerSplitPane = new JSplitPane(0);
        this.mInnerSplitPane.setOneTouchExpandable(true);
        this.mInnerSplitPane.setResizeWeight(0.5);
        this.mOuterSplitPane.setBottomComponent(this.mInnerSplitPane);
        this.mOuterSplitPane.setDividerLocation(0.33);
        this.mInnerSplitPane.setDividerLocation(0.5);
        this.add("Center", this.mOuterSplitPane);
    }

    public void addPane(String string, Icon icon, Component component) {
        TitledBorder titledBorder = new TitledBorder(new EmptyBorder(0, 0, 0, 0), string);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.BLUE);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(titledBorder);
        jPanel.add("Center", component);
        this.addPane(jPanel);
    }

    private void addPane(JPanel jPanel) {
        switch (this.mPaneCount) {
            case 0: {
                this.mOuterSplitPane.setTopComponent(jPanel);
                break;
            }
            case 1: {
                this.mInnerSplitPane.setTopComponent(jPanel);
                break;
            }
            case 2: {
                this.mInnerSplitPane.setBottomComponent(jPanel);
                break;
            }
            default: {
                throw new IllegalStateException("Allowed pane count values when adding are 0, 1, and 2. Illegal value: " + this.mPaneCount);
            }
        }
        ++this.mPaneCount;
    }

    public void enableInformationPane(int n2, boolean bl2) {
        if (n2 < 0 || n2 >= this.mPaneCount) {
            return;
        }
        Component component = this.getPane(n2);
        if (component == null) {
            return;
        }
        component.setEnabled(bl2);
    }

    private Component getPane(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Pane index " + n2 + " is negative");
        }
        switch (n2) {
            case 0: {
                return this.mOuterSplitPane.getTopComponent();
            }
            case 1: {
                return this.mInnerSplitPane.getTopComponent();
            }
            case 2: {
                return this.mInnerSplitPane.getBottomComponent();
            }
        }
        throw new IndexOutOfBoundsException("Index " + n2 + " is greater than or equal to the pane count of " + this.mPaneCount);
    }

    public void setSelectedPane(int n2) {
    }

    public void setPaneIcon(int n2, Icon icon) {
    }

    public void setPaneToolTip(int n2, String string) {
    }
}

