/*
 * Decompiled with CFR 0.152.
 */
package RuntimeTool;

import RuntimeTool.ControlFileDataException;
import RuntimeTool.ControlFileException;
import RuntimeTool.ControlFileIOException;
import RuntimeTool.SectionData;
import StringUtilities.StringCheck;
import StringUtilities.StringJoin;
import StringUtilities.StringSplit;
import StringUtilities.StringStrip;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ControlFile
implements Map {
    private static final String KEY_DELIMITER = "=";
    private static final List BOOLEAN_TRUE = Arrays.asList("true", "yes", "on");
    private static final List BOOLEAN_FALSE = Arrays.asList("false", "no", "off");
    private static final Object VALIDATION_FAILED = new Object();
    private static Map VALID_TYPES = new HashMap();
    protected String mFilename;
    private BufferedReader mReader;
    private String mActiveSection = "";
    private LinkedHashMap mSectionMap;
    private String mDefaultSection = "UNNAMED";
    private long mLastModified;
    private int mLineNumber = -1;
    private Map mValidValues = new HashMap();
    protected String mFileName = null;
    private static final Pattern NORMAL_SECTION_RE;

    public ControlFile(String string) throws ControlFileException {
        this.mFilename = string;
        this.mSectionMap = new LinkedHashMap();
        this.OpenFile();
        this.mLastModified = this.GetLastModified();
    }

    public ControlFile(InputStream inputStream, String string) {
        this(new InputStreamReader(inputStream), string);
    }

    public ControlFile(Reader reader, String string) {
        this.mFilename = string;
        this.mLastModified = -1L;
        this.mSectionMap = new LinkedHashMap();
        this.mReader = new BufferedReader(reader);
    }

    public ControlFile() {
    }

    public String getFileName() {
        return this.getFilename();
    }

    public String getFilename() {
        return this.mFilename;
    }

    protected void validateControlData() throws ControlFileException {
    }

    protected void populate() throws ControlFileException {
    }

    public boolean FileModified() {
        return this.mLastModified != this.GetLastModified();
    }

    public String GetValue(String string, String string2) {
        SectionData sectionData = (SectionData)this.mSectionMap.get(string);
        if (sectionData == null) {
            return null;
        }
        Map map = sectionData.getSectionMap();
        if (map == null) {
            return null;
        }
        return (String)map.get(string2);
    }

    public List GetValueArray(String string, String string2, String string3) {
        String string4 = this.GetValue(string, string2);
        if (string4 == null) {
            return null;
        }
        return StringSplit.split(string4, string3, true, true);
    }

    public String getSybaseServerForHost(String string) throws ParseException {
        String string2 = this.GetStringValue("SYBASE_SERVER_NAMES", string);
        if (StringCheck.isStringEmpty(string2)) {
            throw new ParseException("Unable to find [SYBASE_SERVER_NAMES:" + string + "] in file " + this.mFilename, 0);
        }
        return string2;
    }

    public int GetIntValue(String string, String string2) {
        String string3 = this.GetValue(string, string2);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createFormatException(string, string2, "integer", string3);
        }
    }

    public long GetLongValue(String string, String string2) {
        String string3 = this.GetValue(string, string2);
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createFormatException(string, string2, "long integer", string3);
        }
    }

    public int getInt(String string, String string2) {
        return (Integer)this.getValidValue(string, string2, Integer.class);
    }

    public boolean getBoolean(String string, String string2) {
        return (Boolean)this.getValidValue(string, string2, Boolean.class);
    }

    public double getDouble(String string, String string2) {
        return (Double)this.getValidValue(string, string2, Double.class);
    }

    public int getInt(String string, String string2, int n2) {
        try {
            return Integer.parseInt(this.GetValue(string, string2));
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public String getAndTestStringValue(String string, String string2) throws ControlFileException {
        this.requireKeysSet(string, new String[]{string2});
        return this.GetStringValue(string, string2);
    }

    public String GetStringValue(String string, String string2) {
        return this.GetValue(string, string2);
    }

    public boolean GetBooleanValue(String string, String string2) {
        String string3 = this.GetValue(string, string2);
        if (string3 == null) {
            throw this.createFormatException(string, string2, "boolean", string3);
        }
        if (BOOLEAN_TRUE.contains(string3 = string3.toLowerCase())) {
            return true;
        }
        if (BOOLEAN_FALSE.contains(string3)) {
            return false;
        }
        throw this.createFormatException(string, string2, "boolean", string3);
    }

    public double GetDoubleValue(String string, String string2) {
        String string3 = "floating-point";
        String string4 = this.GetValue(string, string2);
        try {
            if (string4 == null) {
                throw this.createFormatException(string, string2, string3, string4);
            }
            return Double.parseDouble(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createFormatException(string, string2, string3, string4);
        }
    }

    public Hashtable GetSections() {
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.GetSectionsOrdered();
        if (linkedHashMap == null) {
            return null;
        }
        return new Hashtable(this.GetSectionsOrdered());
    }

    public Map GetSectionsOrdered() {
        LinkedHashMap<String, LinkedHashMap> linkedHashMap = new LinkedHashMap<String, LinkedHashMap>();
        LinkedHashMap linkedHashMap2 = null;
        Iterator iterator = this.mSectionMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            linkedHashMap2 = (LinkedHashMap)this.GetSectionOrdered(string);
            if (linkedHashMap2 == null) continue;
            linkedHashMap.put(string, linkedHashMap2);
        }
        return linkedHashMap;
    }

    public Hashtable GetSection(String string) {
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.GetSectionOrdered(string);
        if (linkedHashMap == null) {
            return null;
        }
        return new Hashtable(this.GetSectionOrdered(string));
    }

    public Map GetSectionOrdered(String string) {
        SectionData sectionData = (SectionData)this.mSectionMap.get(string);
        if (sectionData == null) {
            return null;
        }
        return sectionData.getSectionMap();
    }

    public String getDatabaseTypeForHost(String string, String string2) throws ControlFileException {
        if (StringCheck.isStringEmpty(string2)) {
            throw new ControlFileException("Host is null or empty. Can't find DB type for an empty host for section " + string);
        }
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.GetSectionOrdered(string);
        if (linkedHashMap == null) {
            throw new ControlFileException("in file (" + this.mFilename + ")  section [" + string + "] does not exist.");
        }
        List list = this.GetValueArray(string, "SYBASE_SERVER_HOSTS", ",");
        if (list.contains(string2)) {
            return "sybase";
        }
        list = this.GetValueArray(string, "MSQL_SERVER_HOSTS", ",");
        if (list.contains(string2)) {
            return "msql";
        }
        throw new ControlFileException("Unable to find DB type for host (" + string2 + ") since file (" + this.mFilename + ") does not have this host listed under " + string + ":SYBASE_SERVER_HOSTS or " + string + ":MSQL_SERVER_HOSTS.");
    }

    public SectionData getSectionData(String string) {
        SectionData sectionData = (SectionData)this.mSectionMap.get(string);
        if (sectionData == null) {
            return null;
        }
        return new SectionData(sectionData);
    }

    public String GetValueForException(String string, String string2) {
        try {
            return this.getAndTestValueForException(string, string2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public String getAndTestValueForException(String string, String string2) throws NoSuchFieldException {
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.GetSectionOrdered(string);
        if (linkedHashMap == null) {
            throw new NoSuchFieldException("in file (" + this.mFilename + ") section [" + string + "] does not exist.");
        }
        Iterator iterator = linkedHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Set set = this.getAllValuesAvailable((String)linkedHashMap.get(string3));
            if (!set.contains(string2)) continue;
            return string3;
        }
        throw new NoSuchFieldException("in file (" + this.mFilename + "), the value (" + string2 + ") is missing from the section [" + string + "]");
    }

    public Vector GetKeysStartingWith(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        Hashtable hashtable = this.GetSection(string);
        if (hashtable == null) {
            return null;
        }
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.startsWith(string2)) continue;
            vector.add(string3);
        }
        return vector;
    }

    public Vector GetSectionsStartingWith(String string) {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.mSectionMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string) || this.GetSection(string2) == null) continue;
            vector.add(string2);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Read() throws ControlFileException {
        try {
            this.parseFile();
        }
        finally {
            try {
                this.mReader.close();
            }
            catch (IOException iOException) {}
        }
        this.populate();
        this.validateControlData();
    }

    private Set getAllValuesAvailable(String string) {
        return StringSplit.setSplit(string, ",", true, false);
    }

    public String[] PrintMissingKeys(String string, String[] stringArray) {
        String[] stringArray2 = this.GetMissingKeys(string, stringArray);
        if (stringArray2 == null) {
            return null;
        }
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            System.out.println("Missing key: [" + string + ":" + stringArray2[i2] + "]");
        }
        return stringArray2;
    }

    public String[] keysMissingOrEmpty(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = this.GetStringValue(string, stringArray[i2]);
            if (!StringCheck.isStringBlank(string2)) continue;
            vector.addElement(stringArray[i2]);
        }
        return vector.toArray(new String[0]);
    }

    public String keysMissing(String string, String[] stringArray) {
        Object[] objectArray = this.GetMissingKeys(string, stringArray);
        if (objectArray == null) {
            return "";
        }
        return StringJoin.arrayJoin(objectArray, ", ");
    }

    public String[] GetMissingKeys(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (this.GetValue(string, stringArray[i2]) != null) continue;
            arrayList.add(stringArray[i2]);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void requireSection(String string) throws ControlFileException {
        if (!this.mSectionMap.containsKey(string)) {
            throw this.dataError(null, null, "missing required section '" + string + "'");
        }
    }

    public void requireKeys(String string, String[] stringArray) throws ControlFileException {
        Object[] objectArray = this.GetMissingKeys(string, stringArray);
        if (objectArray != null) {
            throw this.dataError(string, null, "missing keys: " + StringJoin.arrayJoin(objectArray, ", "));
        }
    }

    public void requireKeysSet(String string, String[] stringArray) throws ControlFileException {
        this.requireSection(string);
        SectionData sectionData = (SectionData)this.mSectionMap.get(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!StringCheck.isStringBlank((String)sectionData.get(stringArray[i2]))) continue;
            arrayList.add(stringArray[i2]);
        }
        if (!arrayList.isEmpty()) {
            throw this.dataError(string, null, "missing or unset keys: " + StringJoin.listJoin(arrayList, ", "));
        }
    }

    public int requireInt(String string, String string2) throws ControlFileException {
        this.requireSection(string);
        SectionData sectionData = (SectionData)this.mSectionMap.get(string);
        String string3 = (String)sectionData.get(string2);
        try {
            Integer n2 = new Integer(string3);
            this.putValidValue(string, string2, n2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            this.putValidValue(string, string2, VALIDATION_FAILED);
            throw this.valueError(string, string2, "integer", string3);
        }
    }

    public boolean requireBoolean(String string, String string2) throws ControlFileException {
        this.requireSection(string);
        String string3 = this.GetValue(string, string2);
        ControlFileException controlFileException = null;
        Boolean bl2 = null;
        if (string3 == null) {
            controlFileException = this.valueError(string, string2, "boolean", null);
        } else if (BOOLEAN_TRUE.contains(string3 = string3.toLowerCase())) {
            bl2 = Boolean.TRUE;
        } else if (BOOLEAN_FALSE.contains(string3)) {
            bl2 = Boolean.FALSE;
        } else {
            controlFileException = this.valueError(string, string2, "boolean", string3);
        }
        if (controlFileException != null) {
            this.putValidValue(string, string2, VALIDATION_FAILED);
            throw controlFileException;
        }
        this.putValidValue(string, string2, bl2);
        return bl2;
    }

    public double requireDouble(String string, String string2) throws ControlFileException {
        this.requireSection(string);
        String string3 = this.GetValue(string, string2);
        Double d2 = null;
        ControlFileException controlFileException = null;
        if (string3 == null) {
            controlFileException = this.valueError(string, string2, "floating-point", string3);
        } else {
            try {
                d2 = new Double(string3);
            }
            catch (NumberFormatException numberFormatException) {
                controlFileException = this.valueError(string, string2, "floating-point", string3);
            }
        }
        if (controlFileException != null) {
            this.putValidValue(string, string2, VALIDATION_FAILED);
            throw controlFileException;
        }
        this.putValidValue(string, string2, d2);
        return d2;
    }

    private Object getValidValue(String string, String string2, Class clazz) {
        if (!VALID_TYPES.containsKey(clazz)) {
            throw new IllegalArgumentException("cannot fetch values of type " + clazz + " from valid values map");
        }
        String string3 = "key '" + string2 + "' (section '" + string + "')";
        Map map = (Map)this.mValidValues.get(string);
        if (map == null) {
            throw new IllegalStateException(string3 + " not validated yet");
        }
        Object v2 = map.get(string2);
        if (v2 == null) {
            throw new IllegalStateException(string3 + " not validated yet");
        }
        if (v2 == VALIDATION_FAILED) {
            throw new IllegalStateException(string3 + " failed validation");
        }
        if (v2.getClass() != clazz) {
            Class clazz2 = (Class)VALID_TYPES.get(v2.getClass());
            Class clazz3 = (Class)VALID_TYPES.get(clazz);
            throw new IllegalStateException(string3 + " validated as " + clazz2 + ", not " + clazz3);
        }
        return v2;
    }

    private void putValidValue(String string, String string2, Object object) {
        Object v2;
        if (!VALID_TYPES.containsKey(object.getClass()) && object != VALIDATION_FAILED) {
            throw new IllegalArgumentException("cannot put object of type " + object.getClass() + " in valid values map");
        }
        HashMap<String, Object> hashMap = (HashMap<String, Object>)this.mValidValues.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            this.mValidValues.put(string, hashMap);
        }
        if ((v2 = hashMap.get(string2)) != null && v2.getClass() != object.getClass()) {
            throw new IllegalStateException(this.mFilename + ", section '" + string + "': " + "key '" + string2 + "' has already been validated " + "as " + VALID_TYPES.get(v2.getClass()));
        }
        hashMap.put(string2, object);
    }

    public void addSection(String string, SectionData sectionData) {
        if (this.mSectionMap.containsKey(string)) {
            throw new IllegalArgumentException("already have section [" + string + "]");
        }
        this.mSectionMap.put(string, sectionData);
    }

    ControlFileException syntaxError(String string) {
        return new ControlFileException(this.mFilename, this.mLineNumber, string);
    }

    ControlFileException redirectError(String string) {
        return new ControlFileException(this.mFilename, string);
    }

    public ControlFileException dataError(String string, String string2, String string3) {
        return new ControlFileDataException(this.mFilename, string, string2, string3);
    }

    private NumberFormatException createFormatException(String string, String string2, String string3, String string4) {
        String string5 = string4 == null ? ": no such key '" + string2 + "'" : ", key '" + string2 + "': invalid " + string3 + " value '" + string4 + "'";
        return new NumberFormatException(this.mFilename + ", section '" + string + "'" + string5);
    }

    private ControlFileException valueError(String string, String string2, String string3, String string4) {
        if (string4 == null) {
            return new ControlFileDataException(this.mFilename, string, null, "missing required key '" + string2 + "'");
        }
        return new ControlFileDataException(this.mFilename, string, string2, "invalid " + string3 + " value '" + string4 + "'");
    }

    private void parseFile() throws ControlFileException {
        String string;
        this.mLineNumber = 0;
        while ((string = this.readLine()) != null) {
            ++this.mLineNumber;
            if ((string = string.trim()).length() <= 0 || string.startsWith("#") || this.sectionStarts(string = StringStrip.getRidOfComments(string))) continue;
            int n2 = string.indexOf(KEY_DELIMITER);
            if (n2 == -1) {
                throw this.syntaxError("syntax error: delimiter not found");
            }
            String string2 = string.substring(0, n2).trim();
            String string3 = string.substring(n2 + 1, string.length()).trim();
            this.StoreKeyValue(string2, string3);
        }
    }

    private String readLine() throws ControlFileIOException {
        try {
            return this.mReader.readLine();
        }
        catch (IOException iOException) {
            throw new ControlFileIOException(this.mFilename, "error reading from file", iOException);
        }
    }

    private long GetLastModified() {
        File file = new File(this.mFilename);
        return file.lastModified();
    }

    private void OpenFile() throws ControlFileIOException {
        try {
            this.mReader = new BufferedReader(new FileReader(this.mFilename));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ControlFileIOException(this.mFilename, "file not found", fileNotFoundException);
        }
    }

    private void StoreKeyValue(String string, String string2) throws ControlFileException {
        SectionData sectionData;
        if (this.mActiveSection.equals("")) {
            this.mSectionMap.put(this.mDefaultSection, new SectionData(this));
            this.mActiveSection = this.mDefaultSection;
        }
        if ((sectionData = (SectionData)this.mSectionMap.get(this.mActiveSection)) == null) {
            return;
        }
        sectionData.store(string, string2);
    }

    private void storeActiveSection(String string, SectionData sectionData) {
        this.mActiveSection = string;
        if (this.mSectionMap.containsKey(this.mActiveSection)) {
            System.err.println("Duplicated section found while parsing control file: " + this.mFilename + ", section is: " + this.mActiveSection);
            System.exit(1);
        }
        this.mSectionMap.put(this.mActiveSection, sectionData);
    }

    private boolean sectionStarts(String string) {
        Pattern pattern = NORMAL_SECTION_RE;
        Matcher matcher = pattern.matcher(string = StringStrip.getRidOfComments(string));
        if (matcher.find()) {
            this.storeActiveSection(matcher.group(1), new SectionData(this));
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.GetSections().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("[" + string + "]\n");
            Iterator iterator2 = this.GetSectionOrdered(string).keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                stringBuffer.append(string2 + " = " + this.GetStringValue(string, string2) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    private UnsupportedOperationException immutable() {
        return new UnsupportedOperationException("ControlFile is an immutable map");
    }

    public int size() {
        return this.mSectionMap.size();
    }

    public void clear() {
        throw this.immutable();
    }

    public boolean isEmpty() {
        return this.mSectionMap.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.mSectionMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.mSectionMap.containsValue(object);
    }

    public Collection values() {
        return this.mSectionMap.values();
    }

    public void putAll(Map map) {
        throw this.immutable();
    }

    public Set entrySet() {
        return this.mSectionMap.entrySet();
    }

    public Set keySet() {
        return this.mSectionMap.keySet();
    }

    public Object get(Object object) {
        return this.mSectionMap.get(object);
    }

    public Object remove(Object object) {
        throw this.immutable();
    }

    public Object put(Object object, Object object2) {
        throw this.immutable();
    }

    static {
        VALID_TYPES.put(Integer.class, Integer.TYPE);
        VALID_TYPES.put(Boolean.class, Boolean.TYPE);
        VALID_TYPES.put(Double.class, Double.TYPE);
        NORMAL_SECTION_RE = Pattern.compile("^\\s*\\[(.+?)\\]\\s*$");
    }
}

