/*
 * Decompiled with CFR 0.152.
 */
package StringUtilities;

import StringUtilities.StringCheck;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringEscape {
    private static final Pattern REGEXP_BR = Pattern.compile("<br/?>", 2);

    public static String escapeCharacters(String string, String string2, String string3) {
        int n2;
        if (string == null) {
            return string;
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 = string.charAt(i2);
            if (string2.indexOf(n2) == -1) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (string2.indexOf(c2) != -1) {
                stringBuffer.append(string3);
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String EscapeCharacter(String string, String string2, String string3) {
        return StringEscape.escapeCharacters(string, string2, string3);
    }

    public static String escapeSql(String string) {
        return StringEscape.escapeCharacters(string, "'", "'");
    }

    public static String quoteSql(String string) {
        if (string == null) {
            return "NULL";
        }
        return '\'' + StringEscape.escapeSql(string) + '\'';
    }

    public static String searchAndReplaceString(String string, String string2, String string3) {
        if (string == null) {
            return string;
        }
        if (string3.indexOf(92) >= 0 || string3.indexOf(36) >= 0) {
            string3 = string3.replaceAll("([\\\\\\$])", "\\\\$1");
        }
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.replaceAll(string3);
    }

    public static String escapeHtml(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        boolean bl2 = false;
        int n3 = 0;
        block13: for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 = string.charAt(i2);
            switch (n2) {
                case 60: 
                case 62: {
                    n3 += 4;
                    bl2 = true;
                    continue block13;
                }
                case 38: {
                    n3 += 5;
                    bl2 = true;
                    continue block13;
                }
                case 34: {
                    n3 += 6;
                    bl2 = true;
                    continue block13;
                }
                case 39: {
                    n3 += 5;
                    bl2 = true;
                    continue block13;
                }
                default: {
                    ++n3;
                }
            }
        }
        if (!bl2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        block14: for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block14;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block14;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block14;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block14;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block14;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    static boolean containsBrTag(String string) {
        return REGEXP_BR.matcher(string).find();
    }

    public static String escapeHtmlExceptBrTags(String string) {
        if (StringCheck.isStringBlank(string) || !StringEscape.containsBrTag(string)) {
            return StringEscape.escapeHtml(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = REGEXP_BR.matcher(string);
        int n2 = 0;
        while (matcher.find()) {
            int n3 = matcher.start();
            stringBuffer.append(StringEscape.escapeHtml(string.substring(n2, n3)));
            stringBuffer.append(matcher.group());
            n2 = matcher.end();
        }
        if (n2 < string.length()) {
            stringBuffer.append(StringEscape.escapeHtml(string.substring(n2)));
        }
        return stringBuffer.toString();
    }

    public static String getSafeXml(String string) {
        String string2 = StringEscape.searchAndReplaceString(string, "&", "&amp;");
        string2 = StringEscape.searchAndReplaceString(string2, ">", "&gt;");
        string2 = StringEscape.searchAndReplaceString(string2, "[\\000-\\010\\013\\014\\016-\\037]", "");
        return StringEscape.searchAndReplaceString(string2, "<", "&lt;");
    }

    public static Hashtable checkCharsForDatabaseInsert(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = ((String)hashtable.get(string)).replace('\'', '_').replace(',', '^').replace('%', ' ');
            string2 = string2.toUpperCase();
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    public static String getSectionNameForDatabase(String string) {
        String string2 = string.toUpperCase();
        return "DATABASE_" + StringEscape.searchAndReplaceString(string2, "_", "");
    }

    private StringEscape() {
    }

    public static String escapeCharacters(String string, String string2, char c2) {
        if (string2.indexOf(c2) == -1) {
            throw new IllegalArgumentException("charsToEscape must include escape character.");
        }
        return StringEscape.escapeCharacters(string, string2, "" + c2);
    }

    public static String unescapeCharacters(String string, String string2, char c2) {
        if (string2.indexOf(c2) == -1) {
            throw new IllegalArgumentException("charsToUnescape must include escape character.");
        }
        String string3 = StringEscape.escapeRegex(string2);
        String string4 = StringEscape.escapeRegex("" + c2);
        if (string.matches("[^" + string4 + "][" + string3 + "]")) {
            throw new IllegalArgumentException("One of: " + string2 + " exists in " + string + " unescaped.");
        }
        return string.replaceAll(string4 + "([" + string3 + "])", "$1");
    }

    public static String escapeRegex(String string) {
        return string.replaceAll("(\\W)", "\\\\$1");
    }

    public static String createEscapedSeparatedString(String[] stringArray, char c2, char c3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = StringEscape.escapeCharacters(stringArray[i2], "" + c3 + c2, c3);
            stringBuffer.append(string);
            if (i2 == stringArray.length - 1) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String[] splitAndUnescapeString(String string, char c2, char c3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = string.toCharArray();
        char c4 = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c5 = cArray[i2];
            char c6 = c4 = i2 + 1 < cArray.length ? cArray[i2 + 1] : (char)'\u0000';
            if (c5 == c3) {
                if (c4 == c2) {
                    stringBuffer.append(c2);
                    ++i2;
                    continue;
                }
                if (c4 != c3) continue;
                stringBuffer.append(c3);
                ++i2;
                continue;
            }
            if (c5 == c2) {
                arrayList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(c5);
        }
        arrayList.add(stringBuffer.toString());
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

