/*
 * Decompiled with CFR 0.152.
 */
package WaveletClientLibrary;

import J2cProtocol.J2cProtocolConnectException;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.J2cProtocolTimeoutException;
import J2cProtocol.ProxyReplyMessage;
import J2cProtocol.ProxyRequestMessage;
import NetLibrary.WaveletSocket;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import WaveletClientLibrary.WaveletConnectionParameters;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class ProxyClient {
    private static final boolean THROW_EXCEPTION = true;
    private WaveletConnectionParameters mConnectionParameters;
    private int mReadTimeout = 0;
    private Socket mSocket = null;
    private InputStream mInputStream;
    private OutputStream mOutputStream;

    public ProxyClient(WaveletConnectionParameters waveletConnectionParameters) {
        this.mConnectionParameters = new WaveletConnectionParameters(waveletConnectionParameters);
        if (StringCheck.isStringBlank(waveletConnectionParameters.getDestinationHost())) {
            throw new IllegalArgumentException("WaveletConnectionParameters must specify destination host.");
        }
    }

    public void setReadTimeout(int n2) {
        this.mReadTimeout = n2;
    }

    public int getReadTimeout() {
        return this.mReadTimeout;
    }

    public void connect() throws J2cProtocolException {
        if (this.mConnectionParameters.useProxy()) {
            this.connectToDestination(true, this.connectToProxy());
        } else {
            boolean bl2 = StringCheck.isStringEmpty(this.mConnectionParameters.getProxyHost());
            if (!this.connectToDestination(bl2, null)) {
                DebugManager.getDefault().printTrace("Failed connection " + this.mConnectionParameters);
                this.mConnectionParameters.setUseProxy(true);
                DebugManager.getDefault().printTrace("Re-trying with " + this.mConnectionParameters);
                this.connectToDestination(true, this.connectToProxy());
            }
        }
        try {
            this.mInputStream = this.mSocket.getInputStream();
            this.mOutputStream = this.mSocket.getOutputStream();
        }
        catch (IOException iOException) {
            throw new J2cProtocolConnectException("Socket error connecting to wavelet server", this.mConnectionParameters.getDestinationHost(), this.mConnectionParameters.getDestinationPort(), iOException);
        }
    }

    private boolean connectToDestination(boolean bl2, Socket socket) throws J2cProtocolConnectException {
        String string = this.mConnectionParameters.getDestinationHost();
        int n2 = this.mConnectionParameters.getDestinationPort();
        try {
            this.mSocket = WaveletSocket.getSocket(socket, this.mConnectionParameters.useSsl(), string, n2, this.mConnectionParameters.getTimeout(), this.mReadTimeout);
            return true;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.closeSocketNoThrow(socket);
            if (bl2) {
                throw new J2cProtocolTimeoutException(string, n2, socketTimeoutException);
            }
            return false;
        }
        catch (IOException iOException) {
            this.closeSocketNoThrow(socket);
            if (bl2) {
                String string2 = this.mConnectionParameters.useProxy() ? "Error connecting to wavelet server via proxy" : "Error connecting directly to wavelet server";
                throw new J2cProtocolConnectException(string2, string, n2, iOException);
            }
            return false;
        }
    }

    private void closeSocketNoThrow(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            DebugManager.getDefault().printException("Ignoring socket close failure", iOException);
        }
    }

    private Socket connectToProxy() throws J2cProtocolException {
        String string = this.mConnectionParameters.getProxyHost();
        int n2 = this.mConnectionParameters.getProxyPort();
        Socket socket = null;
        try {
            socket = WaveletSocket.getSocket(null, false, string, n2, this.mConnectionParameters.getTimeout(), this.mReadTimeout);
            this.setupProxy(socket);
            return socket;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.closeSocketNoThrow(socket);
            throw new J2cProtocolTimeoutException(string, n2, socketTimeoutException);
        }
        catch (IOException iOException) {
            this.closeSocketNoThrow(socket);
            throw new J2cProtocolConnectException("Error connecting to proxy", string, n2, iOException);
        }
        catch (J2cProtocolException j2cProtocolException) {
            this.closeSocketNoThrow(socket);
            throw j2cProtocolException;
        }
    }

    public void close() {
        this.closeSocketNoThrow(this.mSocket);
    }

    public String getLocalAddress() {
        InetAddress inetAddress = this.mSocket.getLocalAddress();
        if (inetAddress.isLoopbackAddress()) {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return inetAddress.getHostAddress();
    }

    private void setupProxy(Socket socket) throws IOException, J2cProtocolException {
        this.makeProxyRequest(socket);
        ProxyReplyMessage proxyReplyMessage = this.receiveProxyReply(socket);
        if (proxyReplyMessage.getStatus() != 1) {
            throw new J2cProtocolConnectException("Proxy request rejected: " + proxyReplyMessage.getDescription(), this.mConnectionParameters.getDestinationHost(), this.mConnectionParameters.getDestinationPort(), null);
        }
    }

    private void makeProxyRequest(Socket socket) throws IOException, J2cProtocolException {
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        String string = this.mConnectionParameters.getClientId();
        string = string == null ? "Unknown" : string;
        ProxyRequestMessage proxyRequestMessage = new ProxyRequestMessage(string, this.mConnectionParameters.getDestinationHost(), this.mConnectionParameters.getDestinationPort());
        try {
            dataOutputStream.writeShort(proxyRequestMessage.getCode());
            proxyRequestMessage.write(dataOutputStream);
        }
        catch (IOException iOException) {
            throw new J2cProtocolConnectException("Protocol error with proxy server", this.mConnectionParameters.getProxyHost(), this.mConnectionParameters.getProxyPort(), iOException);
        }
    }

    private ProxyReplyMessage receiveProxyReply(Socket socket) throws IOException, J2cProtocolException {
        int n2;
        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        ProxyReplyMessage proxyReplyMessage = new ProxyReplyMessage();
        try {
            n2 = dataInputStream.readUnsignedShort();
        }
        catch (IOException iOException) {
            throw new J2cProtocolConnectException("Protocol error setting up proxy connection", this.mConnectionParameters.getProxyHost(), this.mConnectionParameters.getProxyPort(), iOException);
        }
        if (n2 != proxyReplyMessage.getCode()) {
            throw new J2cProtocolConnectException("Protocol error setting up proxy connection: expected proxy reply message (code " + proxyReplyMessage.getCode() + "), " + "got " + n2, this.mConnectionParameters.getProxyHost(), this.mConnectionParameters.getProxyPort(), null);
        }
        proxyReplyMessage.read(dataInputStream);
        return proxyReplyMessage;
    }

    public InputStream getInputStream() {
        return this.mInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mOutputStream;
    }

    public WaveletConnectionParameters getConnectionParameters() {
        return this.mConnectionParameters;
    }
}

