/*
 * Decompiled with CFR 0.152.
 */
package WaveletClientLibrary;

import J2cProtocol.DisconnectMessage;
import J2cProtocol.J2cProtocolException;
import RuntimeTool.Debug;
import WaveletClientLibrary.ProxyClient;
import WaveletClientLibrary.WaveletConnectionParameters;
import WaveletClientLibrary.WaveletDicomClient;

public class WaveletPingTool {
    private final int mTimeout;
    private final Debug mDebug;

    public WaveletPingTool(int n2, Debug debug) {
        this.mTimeout = n2;
        this.mDebug = debug;
    }

    public void ping(WaveletConnectionParameters waveletConnectionParameters) throws WaveletPingException, J2cProtocolException {
        String string;
        this.mDebug.printTrace("WaveletPingTool.ping(): pinging " + waveletConnectionParameters);
        ProxyClient proxyClient = new ProxyClient(waveletConnectionParameters);
        proxyClient.setReadTimeout(this.mTimeout);
        proxyClient.connect();
        String string2 = "bogus.series.uid";
        String string3 = "bogus.sop.instance.uid";
        WaveletDicomClient waveletDicomClient = new WaveletDicomClient(proxyClient, string2, string3);
        waveletDicomClient.setTestClient(true);
        waveletDicomClient.setDebug(this.mDebug);
        waveletDicomClient.serviceAssociation();
        DisconnectMessage disconnectMessage = waveletDicomClient.getDisconnectMessage();
        if (disconnectMessage == null) {
            throw new WaveletPingException("WaveletServer returned a null message for " + string2);
        }
        int n2 = disconnectMessage.getStatus();
        if (n2 != 1) {
            throw new WaveletPingException("WaveletServer returned a message status of " + n2 + " but we expected a status of " + 1 + " for seriesUid " + string2);
        }
        String string4 = disconnectMessage.getDescription();
        if (!string4.equals(string = "Unable to open series: " + string2)) {
            throw new WaveletPingException("WaveletServer returned a message descrption of \"" + string4 + "\"" + " but we expected the message: \"" + string + "\"");
        }
    }

    public static class WaveletPingException
    extends Exception {
        WaveletPingException(String string) {
            super(string);
        }
    }
}

