/*
 * Decompiled with CFR 0.152.
 */
package XmlSchema.Util;

import RuntimeTool.Debug;
import RuntimeTool.DebugManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.util.ValidationEventCollector;

public class DocumentLogger {
    public static void dumpXmlDocument(Marshaller marshaller, Object object) {
        DocumentLogger.dumpXmlDocument(marshaller, object, DebugManager.getDefault().getFile());
    }

    public static String xmlToString(Marshaller marshaller, Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(5120);
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        DocumentLogger.dumpXmlDocument(marshaller, object, printWriter);
        return byteArrayOutputStream.toString();
    }

    public static void dumpXmlDocument(Marshaller marshaller, Object object, PrintWriter printWriter) {
        Debug debug = DebugManager.getDefault();
        try {
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            ValidationEventCollector validationEventCollector = new ValidationEventCollector();
            marshaller.setEventHandler((ValidationEventHandler)validationEventCollector);
            if (printWriter == null) {
                return;
            }
            marshaller.marshal(object, (Writer)printWriter);
            if (validationEventCollector.hasEvents()) {
                debug.printDebug("*** XML Document has errors ***");
                ValidationEvent[] validationEventArray = validationEventCollector.getEvents();
                for (int i2 = 0; i2 < validationEventArray.length; ++i2) {
                    ValidationEvent validationEvent = validationEventArray[i2];
                    debug.printDebug("Error " + (i2 + 1));
                    debug.printDebug("  Severity: " + validationEvent.getSeverity());
                    debug.printDebug("  Message: " + validationEvent.getMessage());
                    ValidationEventLocator validationEventLocator = validationEvent.getLocator();
                    if (validationEventLocator == null) continue;
                    debug.printDebug("  object: " + validationEventLocator.getObject());
                }
            }
        }
        catch (JAXBException jAXBException) {
            debug.printException("cannot write XML document", jAXBException);
        }
    }
}

