/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import com.intelerad.datamodels.dicom.DimseStatus;
import java.util.ArrayList;
import java.util.List;

public class DicomPrintDimseStatusList {
    private final List mStatusList = new ArrayList();
    private static final String BASIC_FILM_SESSION_SOP_CLASS = "1.2.840.10008.5.1.1.1";
    private static final String BASIC_FILM_BOX_SOP_CLASS = "1.2.840.10008.5.1.1.2";
    private static final String BASIC_GRAYSCALE_IMAGE_BOX_SOP_CLASS = "1.2.840.10008.5.1.1.4";
    private static final String BASIC_COLOR_IMAGE_BOX_SOP_CLASS = "1.2.840.10008.5.1.1.4.1";
    private static final String PRESENTATION_LUT_SOP_CLASS = "1.2.840.10008.5.1.1.23";
    private static final String PULL_PRINT_REQUEST_SOP_CLASS = "1.2.840.10008.5.1.1.31";
    private static final String BASIC_PRINT_IMAGE_OVERLAY_BOX_SOP_CLASS = "1.2.840.10008.5.1.1.24.1";

    public DicomPrintDimseStatusList() {
        this.addEntries();
    }

    public List getStatusList() {
        return this.mStatusList;
    }

    private void addStatus(String string, int n2, DimseStatus.StatusType statusType, String string2) {
        DimseStatus dimseStatus = new DimseStatus(string, n2, statusType, string2);
        this.mStatusList.add(dimseStatus);
    }

    private void addEntries() {
        this.addStatus(BASIC_FILM_SESSION_SOP_CLASS, 46592, DimseStatus.WARNING, "Memory allocation not supported");
        this.addStatus(BASIC_FILM_SESSION_SOP_CLASS, 46593, DimseStatus.WARNING, "Film session printing (collation) is not supported");
        this.addStatus(BASIC_FILM_SESSION_SOP_CLASS, 46594, DimseStatus.WARNING, "Film Session SOP Instance hierarchy does not contain Image Box SOP Instances (empty page)");
        this.addStatus(BASIC_FILM_SESSION_SOP_CLASS, 46596, DimseStatus.WARNING, "Image size is larger than image box size, the image has been demagnified.");
        this.addStatus(BASIC_FILM_SESSION_SOP_CLASS, 46601, DimseStatus.WARNING, "Image size is larger than the Image Box size. The Image has been cropped to fit.");
        this.addStatus(BASIC_FILM_SESSION_SOP_CLASS, 46602, DimseStatus.WARNING, "Image size or Combined Print Image size is larger than the Image Box size. Image or Combined Print Image has been decimated to fit.");
        this.addStatus(BASIC_FILM_SESSION_SOP_CLASS, 50688, DimseStatus.FAILURE, "Film Session SOP Instance hierarchy does not contain Film Box SOP Instances");
        this.addStatus(BASIC_FILM_SESSION_SOP_CLASS, 50689, DimseStatus.FAILURE, "Unable to create Print Job SOP Instance; print queue is full");
        this.addStatus(BASIC_FILM_SESSION_SOP_CLASS, 50691, DimseStatus.FAILURE, "Image size is larger than image box size");
        this.addStatus(BASIC_FILM_SESSION_SOP_CLASS, 50707, DimseStatus.FAILURE, "Combined Print Image size is larger than the Image Box size");
        this.addStatus(BASIC_FILM_BOX_SOP_CLASS, 46597, DimseStatus.WARNING, "Requested Min Density or Max Density outside of printer's operating range. The printer will use its respective minimum or maximum density value instead.");
        this.addStatus(BASIC_FILM_BOX_SOP_CLASS, 50710, DimseStatus.FAILURE, "There is an existing Film Box that has not been printed and N-ACTION at the Film Session level is not supported. A new Film Box will not be created when a previous Film Box has not been printed.");
        this.addStatus(BASIC_FILM_BOX_SOP_CLASS, 46595, DimseStatus.WARNING, "Film Box SOP Instance hierarchy does not contain Image Box SOP Instances (empty page)");
        this.addStatus(BASIC_FILM_BOX_SOP_CLASS, 46596, DimseStatus.WARNING, "Image size is larger than image box size, the image has been demagnified.");
        this.addStatus(BASIC_FILM_BOX_SOP_CLASS, 46601, DimseStatus.WARNING, "Image size is larger than the Image Box size. The Image has been cropped to fit.");
        this.addStatus(BASIC_FILM_BOX_SOP_CLASS, 46602, DimseStatus.WARNING, "Image size or Combined Print Image size is larger than the Image Box size. Image or Combined Print Image has been decimated to fit.");
        this.addStatus(BASIC_FILM_BOX_SOP_CLASS, 50690, DimseStatus.FAILURE, "Unable to create Print Job SOP Instance; print queue is full");
        this.addStatus(BASIC_FILM_BOX_SOP_CLASS, 50691, DimseStatus.FAILURE, "Image size is larger than image box size");
        this.addStatus(BASIC_FILM_BOX_SOP_CLASS, 50707, DimseStatus.FAILURE, "Combined Print Image size is larger than the Image Box size");
        this.addStatus(BASIC_GRAYSCALE_IMAGE_BOX_SOP_CLASS, 46596, DimseStatus.WARNING, "Image size larger than image box size, the image has been demagnified.");
        this.addStatus(BASIC_GRAYSCALE_IMAGE_BOX_SOP_CLASS, 46597, DimseStatus.WARNING, "Requested Min Density or Max Density outside of printer's operating range. The printer will use its respective minimum or maximum density value instead.");
        this.addStatus(BASIC_GRAYSCALE_IMAGE_BOX_SOP_CLASS, 46601, DimseStatus.WARNING, "Image size is larger than the Image Box size. The Image has been cropped to fit.");
        this.addStatus(BASIC_GRAYSCALE_IMAGE_BOX_SOP_CLASS, 46602, DimseStatus.WARNING, "Image size or Combined Print Image size is larger than the Image Box size. The Image or Combined Print Image has been decimated to fit.");
        this.addStatus(BASIC_GRAYSCALE_IMAGE_BOX_SOP_CLASS, 50691, DimseStatus.FAILURE, "Image size is larger than image box size");
        this.addStatus(BASIC_GRAYSCALE_IMAGE_BOX_SOP_CLASS, 50693, DimseStatus.FAILURE, "Insufficient memory in printer to store the image");
        this.addStatus(BASIC_GRAYSCALE_IMAGE_BOX_SOP_CLASS, 50707, DimseStatus.FAILURE, "Combined Print Image size is larger than the Image Box size");
        this.addStatus(BASIC_COLOR_IMAGE_BOX_SOP_CLASS, 46596, DimseStatus.WARNING, "Image size larger than image box size, the image has been demagnified.");
        this.addStatus(BASIC_COLOR_IMAGE_BOX_SOP_CLASS, 46601, DimseStatus.WARNING, "Image size is larger than the Image Box size. The Image has been cropped to fit.");
        this.addStatus(BASIC_COLOR_IMAGE_BOX_SOP_CLASS, 46602, DimseStatus.WARNING, "Image size or Combined Print Image size is larger than the Image Box size. The Image or Combined Print Image has been decimated to fit.");
        this.addStatus(BASIC_COLOR_IMAGE_BOX_SOP_CLASS, 50691, DimseStatus.FAILURE, "Image size is larger than image box size");
        this.addStatus(BASIC_COLOR_IMAGE_BOX_SOP_CLASS, 50693, DimseStatus.FAILURE, "Insufficient memory in printer to store the image");
        this.addStatus(BASIC_COLOR_IMAGE_BOX_SOP_CLASS, 50707, DimseStatus.FAILURE, "Combined Print Image size is larger than the Image Box size");
        this.addStatus(PRESENTATION_LUT_SOP_CLASS, 46597, DimseStatus.WARNING, "Requested Min Density or Max Density outside of printer's operating range. The printer will use its respective minimum or maximum density value instead.");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46592, DimseStatus.WARNING, "Memory allocation not supported");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46592, DimseStatus.WARNING, "Memory allocation not supported (see H.4.1.2.1.2)");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46593, DimseStatus.WARNING, "Film session printing (collation) is not supported");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46594, DimseStatus.WARNING, "Film Session does not contain Image Boxes (empty Page)");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46595, DimseStatus.WARNING, "Film Box does not contain Image Boxes");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46596, DimseStatus.WARNING, "Annotation Box not supported, image printed without annotation.");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46597, DimseStatus.WARNING, "Image Overlay Box not supported, image printed without overlay.");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46598, DimseStatus.WARNING, "Presentation LUT not supported, image printed without applying any Presentation LUT.");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46600, DimseStatus.WARNING, "Presentation LUT not supported at Image Box level, image printed with Film Box Presentation LUT");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46601, DimseStatus.WARNING, "Image size is larger than the Image Box size. The Image has been cropped to fit.");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 46602, DimseStatus.WARNING, "Image size or Combined Print Image size is larger than the Image Box size. Image or Combined Print Image has been decimated to fit.");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50688, DimseStatus.FAILURE, "Stored Print Storage SOP Instance does not contain Film Boxes");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50689, DimseStatus.FAILURE, "Unable to create Print Job SOP Instance; print queue is full");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50690, DimseStatus.FAILURE, "Print queue is full");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50691, DimseStatus.FAILURE, "Image Size is larger than image box size (by using the specified magnification value)");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50693, DimseStatus.FAILURE, "Insufficient Memory to store image");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50695, DimseStatus.FAILURE, "Stored Print Storage SOP Instance not available from Retrieve AE");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50696, DimseStatus.FAILURE, "Image SOP Instance not available from Retrieve AE");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50697, DimseStatus.FAILURE, "in retrieving Stored Print Storage SOP Instance");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50698, DimseStatus.FAILURE, "in retrieving Image SOP Instance");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50699, DimseStatus.FAILURE, "Unknown Retrieve AE title");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50700, DimseStatus.FAILURE, "Print request rejected because printer cannot handle color images");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50701, DimseStatus.FAILURE, "Stored Print Storage SOP Instance does not contain Image Boxes (empty page)");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50702, DimseStatus.FAILURE, "Annotation Box not supported");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50703, DimseStatus.FAILURE, "Image Overlay Box not supported");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50704, DimseStatus.FAILURE, "Presentation LUT not supported");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50707, DimseStatus.FAILURE, "Combined Print Image size is larger than the Image Box size");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50708, DimseStatus.FAILURE, "Presentation LUT not supported at Image Box level");
        this.addStatus(PULL_PRINT_REQUEST_SOP_CLASS, 50709, DimseStatus.FAILURE, "Unable to establish an Association with the Retrieve AE");
        this.addStatus(BASIC_PRINT_IMAGE_OVERLAY_BOX_SOP_CLASS, 50710, DimseStatus.FAILURE, "Combined Print Image requires cropping to fit Image Box. This is not supported in this SOP Class.");
    }
}

