/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.DicomPrintConstants;
import com.intelerad.datamodels.dicom.print.PrinterConfiguration;

public class EtiamDicomPri3 {
    public static PrinterConfiguration getPrinterConfiguration() {
        PrinterConfiguration printerConfiguration = new PrinterConfiguration();
        printerConfiguration.setDefaultProtocolName("ETIAM DICOM PRI v.3 Defaults");
        printerConfiguration.setValidRange(DicomAttribute.NumberOfCopies, 1, 99, 1);
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.PrintPriority, new String[]{"LOW", "MED", "HIGH"}, (Object)"MED");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.MediumType, new String[]{"PAPER", "CLEAR FILM", "BLUE FILM"}, (Object)"PAPER");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmDestination, new String[]{"MAGAZINE", "PROCESSOR"}, (Object)"PROCESSOR");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.ImageDisplayFormat, DicomPrintConstants.createEntries("STANDARD\\", PrinterConfiguration.createMasterImageDisplayFormat()), (Object)"STANDARD\\1,1");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmOrientation, new String[]{"PORTRAIT", "LANDSCAPE"}, (Object)"PORTRAIT");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmSizeID, new String[]{"8INX10IN", "10INX12IN", "10INX14IN", "11INX14IN", "14INX14IN", "14INX17IN", "24CMX24CM", "24CMX30CM", "A4", "A3"}, (Object)"8INX10IN");
        printerConfiguration.acceptAnyValue(DicomAttribute.MagnificationType);
        printerConfiguration.acceptAnyValue(DicomAttribute.SmoothingType);
        printerConfiguration.acceptAnyValue(DicomAttribute.RequestedResolutionID);
        printerConfiguration.setValidValue(DicomAttribute.BorderDensity, "WHITE");
        printerConfiguration.setValidValuesAndRange(DicomAttribute.EmptyImageDensity, new String[]{"BLACK", "WHITE"}, 0, 350, "WHITE");
        printerConfiguration.setValidRange(DicomAttribute.MinDensity, 0, 300, 20);
        printerConfiguration.setValidRange(DicomAttribute.MaxDensity, 0, 300, 300);
        printerConfiguration.setValidValue(DicomAttribute.Trim, "NO");
        printerConfiguration.acceptAnyValue(DicomAttribute.ConfigurationInformation);
        printerConfiguration.verifyConfiguration();
        return printerConfiguration;
    }
}

