/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.MapDataModel;
import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.print.PrintProtocol;
import com.intelerad.datamodels.dicom.print.PrinterConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Printer
extends MapDataModel {
    public static final ModelProperty Name = new ModelProperty(String.class, "Name", "Printer Name");
    public static final ModelProperty AeTitle = new ModelProperty(String.class, "AeTitle", "AE Title");
    public static final ModelProperty Host = new ModelProperty(String.class, "Host", "Host");
    public static final ModelProperty Port = new ModelProperty(Integer.class, "Port", "Port");
    public static final ModelProperty Configuration = new ModelProperty(PrinterConfiguration.class, "Configuration", "Printer Configuration");
    private static final List PROPERTIES = Collections.unmodifiableList(Arrays.asList(Name, AeTitle, Host, Port, Configuration));

    public Printer() {
        this.setProperty(Name, "");
        this.setProperty(AeTitle, "");
        this.setProperty(Host, "");
        this.setProperty(Port, 0);
    }

    public Collection getProperties() {
        return PROPERTIES;
    }

    public void setName(String string) {
        this.setProperty(Name, string);
    }

    public void setAeTitle(String string) {
        this.setProperty(AeTitle, string);
    }

    public void setHost(String string) {
        this.setProperty(Host, string);
    }

    public void setPort(int n2) {
        this.setProperty(Port, new Integer(n2));
    }

    public void setConfiguration(PrinterConfiguration printerConfiguration) {
        this.setProperty(Configuration, printerConfiguration);
    }

    public String getName() {
        return (String)this.getProperty(Name);
    }

    public String getAeTitle() {
        return (String)this.getProperty(AeTitle);
    }

    public String getHost() {
        return (String)this.getProperty(Host);
    }

    public int getPort() {
        return (Integer)this.getProperty(Port);
    }

    public PrinterConfiguration getConfiguration() {
        return (PrinterConfiguration)this.getProperty(Configuration);
    }

    public PrintProtocol getDefaultProtocol() {
        return this.getConfiguration().getDefaultProtocol();
    }

    public String toString() {
        return this.getName() + " (" + this.getAeTitle() + " " + this.getHost() + ":" + this.getPort() + ")";
    }
}

