/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.teachingfile;

import DataStructures.CollectionUtilities;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.enums.Enum;
import org.apache.commons.lang.enums.EnumUtils;

public class AccessLevel
extends Enum {
    public static final AccessLevel PRIVATE = new AccessLevel("private", 0, "Private");
    public static final AccessLevel READONLY = new AccessLevel("read-only", 1, "Readable by all");
    public static final AccessLevel PUBLIC = new AccessLevel("public", 2, "Public");
    private static final Transformer NAME_TRANSFORMER = new Transformer(){

        public Object transform(Object object) {
            return ((AccessLevel)((Object)object)).getName();
        }
    };
    private static final Transformer LABEL_TRANSFORMER = new Transformer(){

        public Object transform(Object object) {
            return ((AccessLevel)((Object)object)).getLabel();
        }
    };
    private int mLevel;
    private String mLabel;

    private AccessLevel(String string, int n2, String string2) {
        super(string);
        this.mLevel = n2;
        this.mLabel = string2;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public boolean isStricterThan(AccessLevel accessLevel) {
        return this.mLevel < accessLevel.mLevel;
    }

    public boolean isLooserThan(AccessLevel accessLevel) {
        return this.mLevel > accessLevel.mLevel;
    }

    public static AccessLevel fromName(String string) {
        return (AccessLevel)EnumUtils.getEnum((Class)AccessLevel.class, (String)string);
    }

    public static Set getAllAccessLevels() {
        return new LinkedHashSet(EnumUtils.getEnumList((Class)AccessLevel.class));
    }

    public static List getNames(Collection collection) {
        return CollectionUtilities.collect(collection, NAME_TRANSFORMER);
    }

    public static List getLabels(Collection collection) {
        return CollectionUtilities.collect(collection, LABEL_TRANSFORMER);
    }
}

