/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.teachingfile;

import DataModels.AbstractDataModel;
import DataModels.ModelProperty;
import StringUtilities.StringCheck;
import StringUtilities.StringStrip;
import com.intelerad.datamodels.teachingfile.AccessLevel;
import com.intelerad.datamodels.teachingfile.Accessible;
import com.intelerad.datamodels.teachingfile.TeachingCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class TeachingCollection
extends AbstractDataModel
implements Accessible {
    private static final String TEMPORARY_ID_PREFIX = "COLL-temp_";
    private String mCollectionId = "";
    private String mDescription = "";
    private AccessLevel mAccessLevel = AccessLevel.PRIVATE;
    private String mLastModifiedBy = "";
    private Date mLastModifiedOn = new Date();
    private String mCreatedBy = "";
    private Date mCreatedOn = new Date();
    private List mCases = Collections.synchronizedList(new ArrayList());
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$intelerad$datamodels$teachingfile$AccessLevel;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Date;

    public TeachingCollection() {
    }

    public TeachingCollection(TeachingCollection teachingCollection) {
        this.mCollectionId = teachingCollection.mCollectionId;
        this.mDescription = teachingCollection.mDescription;
        this.mLastModifiedBy = teachingCollection.mLastModifiedBy;
        this.mLastModifiedOn = teachingCollection.mLastModifiedOn;
        this.mCreatedBy = teachingCollection.mCreatedBy;
        this.mCreatedOn = teachingCollection.mCreatedOn;
        this.setCases(teachingCollection.getCases());
    }

    public String getCollectionId() {
        return this.mCollectionId;
    }

    public void setCollectionId(String string) {
        this.mCollectionId = StringStrip.trim(string);
    }

    public List getCaseIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.mCases.size());
        Iterator iterator = this.mCases.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((TeachingCase)iterator.next()).getCaseId());
        }
        return arrayList;
    }

    public List getCases() {
        return Collections.unmodifiableList(this.mCases);
    }

    public void setCases(List list) {
        this.mCases = Collections.synchronizedList(new ArrayList(list));
    }

    public void addCase(TeachingCase teachingCase) {
        if (teachingCase == null) {
            throw new IllegalArgumentException("Cannot add null case to TeachingCollection");
        }
        if (StringCheck.isStringBlank(teachingCase.getCaseId())) {
            throw new IllegalArgumentException("Cannot add case with blank CaseId to TeachingCollection");
        }
        if (this.mCases.contains(teachingCase)) {
            this.mCases.remove(teachingCase);
        }
        this.mCases.add(teachingCase);
    }

    public void removeCase(TeachingCase teachingCase) {
        if (teachingCase != null) {
            this.mCases.remove(teachingCase);
        }
    }

    public boolean removeCases(Collection collection) {
        return this.mCases.removeAll(collection);
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String string) {
        this.mDescription = StringStrip.trim(string);
    }

    public AccessLevel getAccessLevel() {
        return this.mAccessLevel;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.mAccessLevel = accessLevel;
    }

    public String getLastModifiedBy() {
        return this.mLastModifiedBy;
    }

    public void setLastModifiedBy(String string) {
        this.mLastModifiedBy = StringStrip.trim(string);
    }

    public Date getLastModifiedOn() {
        return new Date(this.mLastModifiedOn.getTime());
    }

    public void setLastModifiedOn(Date date) {
        if (date == null) {
            throw new NullPointerException("lastModifiedOn date cannot be null");
        }
        this.mLastModifiedOn = (Date)date.clone();
    }

    public String getCreatedBy() {
        return this.mCreatedBy;
    }

    public void setCreatedBy(String string) {
        this.mCreatedBy = StringStrip.trim(string);
    }

    public Date getCreatedOn() {
        return new Date(this.mCreatedOn.getTime());
    }

    public void setCreatedOn(Date date) {
        if (date == null) {
            throw new NullPointerException("createdOn date cannot be null");
        }
        this.mCreatedOn = new Date(date.getTime());
    }

    public Collection getProperties() {
        return Property.getAllProperties();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TeachingCollection)) {
            return false;
        }
        if (object == null) {
            return false;
        }
        TeachingCollection teachingCollection = (TeachingCollection)object;
        return this.mCollectionId.equals(teachingCollection.mCollectionId);
    }

    public int hashCode() {
        return this.mCollectionId.hashCode();
    }

    public static String generateTemporaryId(int n2) {
        return TEMPORARY_ID_PREFIX + n2;
    }

    public boolean hasTemporaryId() {
        return this.mCollectionId.startsWith(TEMPORARY_ID_PREFIX);
    }

    public void setTemporaryId(int n2) {
        this.setCollectionId(TeachingCollection.generateTemporaryId(n2));
    }

    public static List getAllCases(Collection collection) {
        LinkedHashSet<TeachingCase> linkedHashSet = new LinkedHashSet<TeachingCase>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TeachingCollection teachingCollection = (TeachingCollection)iterator.next();
            Iterator iterator2 = teachingCollection.getCases().iterator();
            while (iterator2.hasNext()) {
                TeachingCase teachingCase = (TeachingCase)iterator2.next();
                linkedHashSet.add(teachingCase);
            }
        }
        return new ArrayList(linkedHashSet);
    }

    public boolean isModifiableBy(String string) {
        return this.mAccessLevel == AccessLevel.PUBLIC || this.getCreatedBy().equals(string);
    }

    public String getId() {
        return this.mCollectionId;
    }

    public static class Property
    extends ModelProperty {
        private static Map mNameMap = new HashMap();
        public static final Property CollectionId = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCollection.class$("java.lang.String")) : class$java$lang$String, "CollectionId", "Collection ID");
        public static final Property Description = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCollection.class$("java.lang.String")) : class$java$lang$String, "Description", "Description");
        public static final Property AccessLevel = new Property(class$com$intelerad$datamodels$teachingfile$AccessLevel == null ? (class$com$intelerad$datamodels$teachingfile$AccessLevel = TeachingCollection.class$("com.intelerad.datamodels.teachingfile.AccessLevel")) : class$com$intelerad$datamodels$teachingfile$AccessLevel, "AccessLevel", "Access Rights");
        public static final Property Cases = new Property(class$java$util$List == null ? (class$java$util$List = TeachingCollection.class$("java.util.List")) : class$java$util$List, "Cases", "Cases");
        public static final Property LastModifiedBy = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCollection.class$("java.lang.String")) : class$java$lang$String, "LastModifiedBy", "Last Modified By");
        public static final Property LastModifiedOn = new Property(class$java$util$Date == null ? (class$java$util$Date = TeachingCollection.class$("java.util.Date")) : class$java$util$Date, "LastModifiedOn", "Last Modified On");
        public static final Property CreatedBy = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCollection.class$("java.lang.String")) : class$java$lang$String, "CreatedBy", "Created By");
        public static final Property CreatedOn = new Property(class$java$util$Date == null ? (class$java$util$Date = TeachingCollection.class$("java.util.Date")) : class$java$util$Date, "CreatedOn", "Created On");

        protected Property(Class clazz, String string, String string2) {
            super(clazz, string, string2);
            mNameMap.put(string, this);
        }

        public static Property getInstance(String string) {
            return (Property)mNameMap.get(string);
        }

        public static Collection getAllProperties() {
            return Collections.unmodifiableCollection(mNameMap.values());
        }

        public static Property[] getAllPropertiesAsArray() {
            return mNameMap.values().toArray(new Property[mNameMap.size()]);
        }
    }
}

