/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.userprofile;

import com.intelerad.datamodels.userprofile.Category;
import com.intelerad.datamodels.userprofile.ProfileIdentifier;
import com.intelerad.datamodels.userprofile.RoamingTemplateIdentifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ProfileIdentifierCollection {
    private Map mProfileTemplateIdentifierMap = new HashMap();

    public void put(ProfileIdentifier profileIdentifier, RoamingTemplateIdentifier roamingTemplateIdentifier) {
        this.validateIdentifiers(profileIdentifier, roamingTemplateIdentifier);
        this.mProfileTemplateIdentifierMap.put(profileIdentifier, roamingTemplateIdentifier);
    }

    public boolean containsTemplateIdentifier(RoamingTemplateIdentifier roamingTemplateIdentifier) {
        return this.mProfileTemplateIdentifierMap.containsValue(roamingTemplateIdentifier);
    }

    public boolean containsProfileIdentifier(ProfileIdentifier profileIdentifier) {
        return this.mProfileTemplateIdentifierMap.containsKey(profileIdentifier);
    }

    public Set getProfileIdentifiers() {
        return new HashSet(this.mProfileTemplateIdentifierMap.keySet());
    }

    public RoamingTemplateIdentifier getBackingTemplateIdentifier(ProfileIdentifier profileIdentifier) {
        return (RoamingTemplateIdentifier)this.mProfileTemplateIdentifierMap.get(profileIdentifier);
    }

    public ProfileIdentifierCollection filterByCategory(Category category) {
        ProfileIdentifierCollection profileIdentifierCollection = new ProfileIdentifierCollection();
        Iterator iterator = this.getProfileIdentifiers().iterator();
        while (iterator.hasNext()) {
            ProfileIdentifier profileIdentifier = (ProfileIdentifier)iterator.next();
            if (!profileIdentifier.getCategory().equals((Object)category)) continue;
            profileIdentifierCollection.put(profileIdentifier, this.getBackingTemplateIdentifier(profileIdentifier));
        }
        return profileIdentifierCollection;
    }

    private void validateIdentifiers(ProfileIdentifier profileIdentifier, RoamingTemplateIdentifier roamingTemplateIdentifier) {
        if (profileIdentifier == null) {
            throw new IllegalArgumentException("Invalid pair: profileIdentifier cannot be null");
        }
        if (roamingTemplateIdentifier == null) {
            return;
        }
        if (!profileIdentifier.getApplicationContext().equals((Object)roamingTemplateIdentifier.getApplicationContext())) {
            throw new IllegalArgumentException("Invalid pair: applicationContexts don't match (" + (Object)((Object)profileIdentifier.getApplicationContext()) + ", " + (Object)((Object)roamingTemplateIdentifier.getApplicationContext()) + ")");
        }
        if (!profileIdentifier.getCategory().equals((Object)roamingTemplateIdentifier.getCategory())) {
            throw new IllegalArgumentException("Invalid pair: categories don't match (" + (Object)((Object)profileIdentifier.getCategory()) + ", " + (Object)((Object)roamingTemplateIdentifier.getCategory()) + ")");
        }
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.mProfileTemplateIdentifierMap == null ? 0 : ((Object)this.mProfileTemplateIdentifierMap).hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ProfileIdentifierCollection profileIdentifierCollection = (ProfileIdentifierCollection)object;
        return !(this.mProfileTemplateIdentifierMap == null ? profileIdentifierCollection.mProfileTemplateIdentifierMap != null : !((Object)this.mProfileTemplateIdentifierMap).equals(profileIdentifierCollection.mProfileTemplateIdentifierMap));
    }
}

