/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.validation;

import com.intelerad.datamodels.validation.Validator;
import java.util.ArrayList;
import java.util.List;

public class ValueInRangeValidator
implements Validator {
    private final Integer mFirst;
    private final Integer mLast;
    private final boolean mConvertStrings;

    public ValueInRangeValidator(Integer n2, Integer n3, boolean bl2) {
        this.mFirst = n2;
        this.mLast = n3;
        this.mConvertStrings = bl2;
    }

    public boolean isValid(Object object) {
        if (this.mConvertStrings) {
            object = this.tryStringConversion(object);
        }
        return object instanceof Integer && this.lessOrEqualThan(this.mFirst, (Integer)object) && this.greaterOrEqualThan(this.mLast, (Integer)object);
    }

    public List getValidValues() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = this.mFirst.intValue(); i2 <= this.mLast; ++i2) {
            arrayList.add(new Integer(i2));
        }
        return arrayList;
    }

    public Integer getFirst() {
        return this.mFirst;
    }

    public Integer getLast() {
        return this.mLast;
    }

    public boolean acceptsStrings() {
        return this.mConvertStrings;
    }

    private Object tryStringConversion(Object object) {
        if (!(object instanceof String)) {
            return object;
        }
        try {
            return Integer.valueOf((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            return object;
        }
    }

    private boolean lessOrEqualThan(Integer n2, Integer n3) {
        return n2.compareTo(n3) <= 0;
    }

    private boolean greaterOrEqualThan(Integer n2, Integer n3) {
        return n2.compareTo(n3) >= 0;
    }

    public String toString() {
        return this.mFirst + ".." + this.mLast;
    }

    public int hashCode() {
        return this.mFirst.hashCode() ^ this.mLast.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueInRangeValidator)) {
            return false;
        }
        ValueInRangeValidator valueInRangeValidator = (ValueInRangeValidator)object;
        return valueInRangeValidator.mFirst.equals(this.mFirst) && valueInRangeValidator.mLast.equals(this.mLast) && valueInRangeValidator.mConvertStrings == this.mConvertStrings;
    }
}

