/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.burlap.io;

import com.caucho.hessian.io.Deserializer;
import com.intelerad.lib.burlap.io.BurlapOutput;
import com.intelerad.lib.burlap.io.SerializerFactory;
import com.intelerad.lib.serialization.protocol.Protocol;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;

public class BurlapInput
extends com.caucho.burlap.io.BurlapInput {
    private final Protocol mProtocol;
    private final InputStream mInputStream;

    public BurlapInput(InputStream inputStream, Protocol protocol) {
        super(inputStream);
        this.mInputStream = inputStream;
        this.mProtocol = protocol;
    }

    public void init(InputStream inputStream) {
        super.init(inputStream);
        this._serializerFactory = new SerializerFactory();
    }

    public void completeCall() throws IOException {
        super.completeCall();
        this.mInputStream.close();
    }

    public void completeReply() throws IOException {
        super.completeReply();
        this.mInputStream.close();
    }

    public Object readObject() throws IOException {
        Object object = super.readObject();
        BurlapOutput.validateObject(this._serializerFactory, this.mProtocol, object);
        return object;
    }

    public Object readObject(Class clazz) throws IOException {
        Object object = super.readObject(clazz);
        BurlapOutput.validateObject(this._serializerFactory, this.mProtocol, object);
        return object;
    }

    public String readType() throws IOException {
        return this.mProtocol == null ? super.readType() : this.mProtocol.resolveClassName(super.readType());
    }

    protected boolean acceptObjectDeserializer(Class clazz, Deserializer deserializer) throws IOException {
        Method method;
        if (BurlapOutput.isBasicType(this._serializerFactory, clazz)) {
            return super.acceptObjectDeserializer(clazz, deserializer);
        }
        Class clazz2 = deserializer.getType();
        try {
            method = clazz2.getMethod("readResolve", new Class[0]);
        }
        catch (Exception exception) {
            method = null;
        }
        if (method == null) {
            throw new IOException("Attempting to deserialize object of class " + clazz2 + " which is not a basic type, nor does it have a readResolve() method");
        }
        Class<?> clazz3 = method.getReturnType();
        BurlapOutput.validateClass(this._serializerFactory, this.mProtocol, clazz3);
        if (clazz.isAssignableFrom(clazz3)) {
            return true;
        }
        throw new IOException("Attempting to deserialize object of class " + clazz2 + " whose readResolve() return class is " + clazz3 + " but the expected class is " + clazz);
    }

    public static Object readObject(Protocol protocol, InputStream inputStream) throws IOException {
        BurlapInput burlapInput = new BurlapInput(inputStream, protocol);
        return burlapInput.readObject();
    }
}

