/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.burlap.io;

import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.JavaSerializer;
import com.caucho.hessian.io.SerializerFactory;
import com.intelerad.lib.serialization.exception.ServiceException;
import com.intelerad.lib.serialization.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;
import java.util.IdentityHashMap;

public class BurlapOutput
extends com.caucho.burlap.io.BurlapOutput {
    private final Protocol mProtocol;
    private final IdentityHashMap mTransferObjects = new IdentityHashMap();

    public BurlapOutput(OutputStream outputStream, Protocol protocol) {
        super(outputStream);
        this.mProtocol = protocol;
    }

    public void init(OutputStream outputStream) {
        super.init(outputStream);
        this._serializerFactory = new SerializerFactory();
    }

    public void completeCall() throws IOException {
        super.completeCall();
        this.os.close();
    }

    public void completeReply() throws IOException {
        super.completeReply();
        this.os.close();
    }

    public void writeFault(String string, String string2, Object object) throws IOException {
        if (object instanceof Throwable && !(object instanceof ServiceException)) {
            super.writeFault(string, string2, (Object)new ServiceException((Throwable)object));
        } else {
            super.writeFault(string, string2, object);
        }
    }

    public void writeMapBegin(String string) throws IOException {
        super.writeMapBegin(this.mProtocol.resolveClassName(string));
    }

    public void writeObject(Object object) throws IOException {
        Object object2 = object;
        BurlapOutput.validateObject(this._serializerFactory, this.mProtocol, object);
        if (object != null && this.mProtocol.knows(object.getClass().getName())) {
            object2 = this.getTransferObject(object);
        }
        super.writeObject(object2);
    }

    public static boolean isBasicType(SerializerFactory serializerFactory, Class clazz) throws IOException {
        boolean bl2;
        try {
            bl2 = serializerFactory.getSerializer(clazz) instanceof JavaSerializer;
        }
        catch (HessianProtocolException hessianProtocolException) {
            throw new IOException("Cannot get serializer for class " + clazz.getName());
        }
        return !bl2 || clazz.isPrimitive() || clazz.getName().startsWith("java.lang.");
    }

    protected static void validateClass(SerializerFactory serializerFactory, Protocol protocol, Class clazz) throws IOException {
        boolean bl2;
        boolean bl3 = BurlapOutput.isBasicType(serializerFactory, clazz);
        boolean bl4 = bl2 = protocol.knows(clazz.getName()) || protocol.knowsException(clazz.getName());
        if (bl3 || bl2) {
            return;
        }
        throw new IOException("Class " + clazz.getName() + " is not a basic type and is not known by protocol " + protocol.getName());
    }

    protected static void validateObject(SerializerFactory serializerFactory, Protocol protocol, Object object) throws IOException {
        if (object == null) {
            return;
        }
        BurlapOutput.validateClass(serializerFactory, protocol, object.getClass());
    }

    public static void writeObject(Protocol protocol, OutputStream outputStream, Object object) throws IOException {
        BurlapOutput burlapOutput = new BurlapOutput(outputStream, protocol);
        burlapOutput.writeObject(object);
    }

    private Object getTransferObject(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.mTransferObjects.containsKey(object)) {
            return this.mTransferObjects.get(object);
        }
        Object object2 = this.mProtocol.getTransferObject(object);
        this.mTransferObjects.put(object, object2);
        return object2;
    }
}

