/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dcmtojpeg;

import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ScaleRuler {
    private static final double DEFAULT_VIEWPORT_LENGTH_FACTOR = 0.6;
    private static final double TICK_LENGTH_VIEWPORT_FACTOR = 0.025;
    private static final double MINIMUM_TICK_LENGTH = 2.0;
    private static final int MINIMUM_PIXELS_PER_CM = 4;
    private static final ScalebarComposite SBC = new ScalebarComposite();
    private RulerStyle mRulerStyle;
    private Color mRulerColor = Color.ORANGE;
    private int mMargin = 10;
    private Axis mAxis = Axis.BOTH;
    private double mLengthFactor = 0.6;

    public ScaleRuler(RulerStyle rulerStyle, int n2) {
        this.mRulerStyle = rulerStyle;
        this.mMargin = n2;
    }

    public ScaleRuler(RulerStyle rulerStyle, Axis axis, Color color, double d2) {
        this.mRulerStyle = rulerStyle;
        this.mAxis = axis;
        this.mRulerColor = color;
        this.mLengthFactor = d2;
    }

    public ScaleRuler(Color color, int n2) {
        this.mRulerStyle = RulerStyle.SOLID_COLOR;
        this.mRulerColor = color;
        this.mMargin = n2;
    }

    public void setColor(Color color) {
        this.mRulerColor = color;
    }

    public void setMargin(int n2) {
        this.mMargin = n2;
    }

    public void drawScales(Graphics2D graphics2D, int n2, int n3, double d2, double d3) {
        double d4;
        int n4;
        int n5 = this.getNumberOfTicks(n2, d2);
        if (!this.validateRuler(d2, d3, n5, n4 = this.getNumberOfTicks(n3, d3), d4 = this.getLongTickLength(n2, n3))) {
            return;
        }
        Shape shape = ScaleRuler.createScale(n5, d2, d4);
        Shape shape2 = ScaleRuler.createScale(n4, d3, d4);
        shape = this.moveToBottomCenter(shape, d4, n2, n3);
        shape2 = this.rotate90AndMoveToLeftCenter(shape2, d4, n3);
        if (this.mRulerStyle == RulerStyle.SHADOWED) {
            graphics2D.setColor(Color.BLACK);
            if (this.drawHorizontalScale()) {
                graphics2D.draw(this.createShadow(shape));
            }
            if (this.drawVerticalScale()) {
                graphics2D.draw(this.createShadow(shape2));
            }
        }
        Composite composite = graphics2D.getComposite();
        if (this.mRulerStyle == RulerStyle.COMPOSITE) {
            graphics2D.setComposite(SBC);
        } else {
            graphics2D.setColor(this.mRulerColor);
        }
        if (this.drawHorizontalScale()) {
            graphics2D.draw(shape);
        }
        if (this.drawVerticalScale()) {
            graphics2D.draw(shape2);
        }
        if (this.mRulerStyle == RulerStyle.COMPOSITE) {
            graphics2D.setComposite(composite);
        }
    }

    public Rectangle getBoundingBox(int n2, int n3, double d2, double d3) {
        double d4;
        int n4;
        int n5 = this.getNumberOfTicks(n2, d2);
        if (!this.validateRuler(d2, d3, n5, n4 = this.getNumberOfTicks(n3, d3), d4 = this.getLongTickLength(n2, n3))) {
            return new Rectangle(0, 0, 0, 0);
        }
        Shape shape = ScaleRuler.createScale(n5, d2, d4);
        Shape shape2 = ScaleRuler.createScale(n4, d3, d4);
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (this.drawHorizontalScale()) {
            rectangle.add(shape.getBounds());
        }
        if (this.drawVerticalScale()) {
            rectangle.add(shape2.getBounds());
        }
        return rectangle;
    }

    private static Shape createScale(int n2, double d2, double d3) {
        double d4 = d3 / 2.0;
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (n2 > 2 && (i2 - n2 / 2) % 5 == 0) {
                generalPath.moveTo(i2, 0.0f);
            } else {
                generalPath.moveTo(i2, (float)d4);
            }
            generalPath.lineTo(i2, (float)d3);
        }
        generalPath.moveTo(0.0f, (float)d3);
        generalPath.lineTo(n2 - 1, (float)d3);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(ScaleRuler.pixelsPerCm(d2), 1.0);
        return affineTransform.createTransformedShape(generalPath);
    }

    private Shape createShadow(Shape shape) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(1.0, 1.0);
        return affineTransform.createTransformedShape(shape);
    }

    private Shape moveToBottomCenter(Shape shape, double d2, int n2, int n3) {
        Rectangle rectangle = shape.getBounds();
        double d3 = ((double)n2 - rectangle.getWidth()) / 2.0;
        double d4 = (double)n3 - d2 - (double)this.mMargin;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d3, d4);
        return affineTransform.createTransformedShape(shape);
    }

    private Shape rotate90AndMoveToLeftCenter(Shape shape, double d2, int n2) {
        Rectangle rectangle = shape.getBounds();
        double d3 = d2;
        double d4 = rectangle.getWidth();
        double d5 = (double)this.mMargin + d3;
        double d6 = ((double)n2 - d4) / 2.0;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d5, d6);
        affineTransform.rotate(1.5707963267948966);
        return affineTransform.createTransformedShape(shape);
    }

    private boolean validateRuler(double d2, double d3, int n2, int n3, double d4) {
        if (this.drawHorizontalScale() && (n2 < 2 || ScaleRuler.pixelsPerCm(d2) < 4.0)) {
            return false;
        }
        if (this.drawVerticalScale() && (n3 < 2 || ScaleRuler.pixelsPerCm(d3) < 4.0)) {
            return false;
        }
        return !(d4 < 2.0);
    }

    private int getNumberOfTicks(int n2, double d2) {
        int n3 = (int)Math.floor(ScaleRuler.lengthInCm((double)n2 * this.mLengthFactor, d2));
        if (n3 <= 2) {
            return n3 + 1;
        }
        return n3 % 2 == 1 ? n3 : n3 + 1;
    }

    private double getLongTickLength(int n2, int n3) {
        return (double)Math.max(n3, n2) * 0.025;
    }

    private boolean drawVerticalScale() {
        return this.mAxis == Axis.VERTICAL || this.mAxis == Axis.BOTH;
    }

    private boolean drawHorizontalScale() {
        return this.mAxis == Axis.HORIZONTAL || this.mAxis == Axis.BOTH;
    }

    private static double lengthInCm(double d2, double d3) {
        return d2 * (d3 / 10.0);
    }

    private static double pixelsPerCm(double d2) {
        return 10.0 / d2;
    }

    private static final class ThresholdCompositeContext
    implements CompositeContext {
        private static final int[] BLACK = new int[]{0, 0, 0};
        private int[] mWhite;
        private int mThreshold;

        public ThresholdCompositeContext(int n2) {
            int n3 = (int)Math.pow(2.0, n2) - 1;
            this.mWhite = new int[]{n3, n3, n3};
            this.mThreshold = n3 / 2;
        }

        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = new int[4];
            for (int i2 = 0; i2 < writableRaster.getWidth(); ++i2) {
                for (int i3 = 0; i3 < writableRaster.getHeight(); ++i3) {
                    if ((nArray = writableRaster.getPixel(i2, i3, nArray))[0] > this.mThreshold) {
                        writableRaster.setPixel(i2, i3, BLACK);
                        continue;
                    }
                    writableRaster.setPixel(i2, i3, this.mWhite);
                }
            }
        }

        public void dispose() {
        }
    }

    private static final class ScalebarComposite
    implements Composite {
        private ScalebarComposite() {
        }

        public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
            return new ThresholdCompositeContext(colorModel2.getComponentSize(0));
        }
    }

    public static class Axis {
        public static final Axis HORIZONTAL = new Axis();
        public static final Axis VERTICAL = new Axis();
        public static final Axis BOTH = new Axis();

        private Axis() {
        }
    }

    public static class RulerStyle {
        public static final RulerStyle COMPOSITE = new RulerStyle();
        public static final RulerStyle SHADOWED = new RulerStyle();
        public static final RulerStyle SOLID_COLOR = new RulerStyle();

        private RulerStyle() {
        }
    }
}

