/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import FileUtilities.FileNaming;
import StringUtilities.StringPad;
import StringUtilities.StringSplit;
import com.archimed.dicom.DDate;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Person;
import com.archimed.dicom.tools.Sequences;
import com.intelerad.lib.dicomtools.DicomDirBuilder;
import com.intelerad.lib.dicomtools.DicomDirReader;
import com.intelerad.lib.dicomtools.DicomObjectCopier;
import com.intelerad.lib.dicomtools.JdtUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DicomDir {
    private static final String NON_CS_REGEXP = ".*[^A-Z0-9_ ].*";
    private static final Map RECORD_ID_TAG = new HashMap();
    public static final String RECORD_TYPE_PATIENT = "PATIENT";
    public static final String RECORD_TYPE_STUDY = "STUDY";
    public static final String RECORD_TYPE_SERIES = "SERIES";
    public static final String RECORD_TYPE_IMAGE = "IMAGE";
    public static final String RECORD_TYPE_PRESENTATION = "PRESENTATION";
    private File mFilename;
    private DicomObject mDicomObject;
    private DirectoryRecord mRoot;

    DicomDir(File file, DicomObject dicomObject) {
        this.mFilename = file;
        this.mDicomObject = dicomObject;
        this.mRoot = new DirectoryRecord(null);
    }

    public DicomDir(File file) {
        this(file, new DicomObject());
    }

    public File getFilesetRoot() {
        return this.mFilename.getParentFile();
    }

    DicomObject getDicomObject() {
        return this.mDicomObject;
    }

    DirectoryRecord getRoot() {
        return this.mRoot;
    }

    public DirectoryRecord getChild(String string) throws DicomException {
        return this.mRoot.getChild(string);
    }

    private DirectoryRecord addRecord(DirectoryRecord directoryRecord, DirectoryRecord directoryRecord2) {
        try {
            String string = directoryRecord2.getRecordId();
            if (string == null) {
                throw new NullPointerException();
            }
            directoryRecord.addChild(directoryRecord2);
            return directoryRecord2;
        }
        catch (DicomException dicomException) {
            try {
                throw new IllegalArgumentException("Child (" + directoryRecord2.getRecordType() + ") record does not have a " + DDict.getDescription((int)directoryRecord2.getRecordIdTag()));
            }
            catch (DicomException dicomException2) {
                throw new IllegalArgumentException("Child record does not have a record ID tag.");
            }
        }
    }

    public void write(String string) throws DicomException, IOException {
        DicomDirBuilder dicomDirBuilder = new DicomDirBuilder(this.mFilename, string, this.mRoot);
        dicomDirBuilder.write();
    }

    public List getPatientRecords() {
        ArrayList<DirectoryRecord> arrayList = new ArrayList<DirectoryRecord>();
        Iterator iterator = this.mRoot.getChildren().iterator();
        while (iterator.hasNext()) {
            DirectoryRecord directoryRecord = (DirectoryRecord)iterator.next();
            if (!(directoryRecord instanceof PatientRecord)) continue;
            arrayList.add(directoryRecord);
        }
        return arrayList;
    }

    List getStudyRecords() {
        ArrayList<DirectoryRecord> arrayList = new ArrayList<DirectoryRecord>();
        Iterator iterator = this.mRoot.getChildren().iterator();
        while (iterator.hasNext()) {
            DirectoryRecord directoryRecord = (DirectoryRecord)iterator.next();
            Iterator iterator2 = directoryRecord.getChildren().iterator();
            while (iterator2.hasNext()) {
                DirectoryRecord directoryRecord2 = (DirectoryRecord)iterator2.next();
                if (!(directoryRecord2 instanceof StudyRecord)) continue;
                arrayList.add(directoryRecord2);
            }
        }
        return arrayList;
    }

    void dump() throws DicomException {
        this.mRoot.dump(System.out, 0);
    }

    private DicomObject buildBasicDicomObject(String string) throws DicomException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(45, (Object)new Long(0L));
        dicomObject.set(46, (Object)new Integer(65535));
        dicomObject.set(47, (Object)new Long(0L));
        dicomObject.set(48, (Object)string);
        return dicomObject;
    }

    public PatientRecord addPatientRecord(PatientRecord patientRecord, Person person, String string) throws DicomException {
        DicomObject dicomObject = this.buildBasicDicomObject(RECORD_TYPE_PATIENT);
        dicomObject.set(147, (Object)person);
        dicomObject.set(148, (Object)string);
        if (patientRecord == null) {
            return this.addPatientRecord(dicomObject);
        }
        return (PatientRecord)this.swapDicomObject(patientRecord, dicomObject);
    }

    PatientRecord addPatientRecord(DicomObject dicomObject) {
        PatientRecord patientRecord = new PatientRecord(dicomObject);
        this.addRecord(this.mRoot, patientRecord);
        return patientRecord;
    }

    public StudyRecord addStudyRecord(PatientRecord patientRecord, StudyRecord studyRecord, String string, DDate dDate, String string2, String string3, String string4, String string5) throws DicomException {
        DicomObject dicomObject = this.buildBasicDicomObject(RECORD_TYPE_STUDY);
        dicomObject.set(64, (Object)dDate);
        dicomObject.set(70, (Object)string2);
        dicomObject.set(95, (Object)string3);
        dicomObject.set(425, (Object)string);
        dicomObject.set(427, (Object)string4);
        dicomObject.set(77, (Object)string5);
        if (studyRecord == null) {
            return this.addStudyRecord(patientRecord, dicomObject);
        }
        return (StudyRecord)this.swapDicomObject(studyRecord, dicomObject);
    }

    StudyRecord addStudyRecord(PatientRecord patientRecord, DicomObject dicomObject) {
        StudyRecord studyRecord = new StudyRecord(dicomObject);
        this.addRecord(patientRecord, studyRecord);
        return studyRecord;
    }

    public SeriesRecord addSeriesRecord(StudyRecord studyRecord, SeriesRecord seriesRecord, String string, String string2, int n2) throws DicomException {
        DicomObject dicomObject = this.buildBasicDicomObject(RECORD_TYPE_SERIES);
        dicomObject.set(81, (Object)string);
        dicomObject.set(426, (Object)string2);
        dicomObject.set(428, (Object)new Integer(n2));
        if (seriesRecord == null) {
            return this.addSeriesRecord(studyRecord, dicomObject);
        }
        return (SeriesRecord)this.swapDicomObject(seriesRecord, dicomObject);
    }

    private DirectoryRecord swapDicomObject(DirectoryRecord directoryRecord, DicomObject dicomObject) {
        directoryRecord.setDicomObject(dicomObject);
        return directoryRecord;
    }

    SeriesRecord addSeriesRecord(StudyRecord studyRecord, DicomObject dicomObject) {
        SeriesRecord seriesRecord = new SeriesRecord(dicomObject);
        this.addRecord(studyRecord, seriesRecord);
        return seriesRecord;
    }

    public ImageRecord addImageRecord(SeriesRecord seriesRecord, ImageRecord imageRecord, String string, String string2, int n2, int n3, File file) throws DicomException {
        DicomObject dicomObject = this.buildBasicDicomObject(RECORD_TYPE_IMAGE);
        dicomObject.set(50, (Object)"");
        dicomObject.set(52, (Object)string);
        dicomObject.set(53, (Object)string2);
        dicomObject.set(54, (Object)JdtUtil.getUid(n3));
        dicomObject.set(430, (Object)new Integer(n2));
        this.setReferencedFileId(dicomObject, file);
        if (imageRecord == null) {
            return this.addImageRecord(seriesRecord, dicomObject);
        }
        return (ImageRecord)this.swapDicomObject(imageRecord, dicomObject);
    }

    public PresentationRecord addPresentationRecord(SeriesRecord seriesRecord, PresentationRecord presentationRecord, DicomObject dicomObject, int n2, File file) throws DicomException {
        DicomObject dicomObject2 = this.buildBasicDicomObject(RECORD_TYPE_PRESENTATION);
        DicomObjectCopier dicomObjectCopier = new DicomObjectCopier(dicomObject, dicomObject2);
        dicomObjectCopier.copyElement(62, 52);
        dicomObjectCopier.copyElement(63, 53);
        dicomObject2.set(54, (Object)JdtUtil.getUid(n2));
        dicomObjectCopier.copyElement(430);
        dicomObjectCopier.copyElement(1403);
        dicomObjectCopier.copyElement(1404);
        dicomObjectCopier.copyElement(1405);
        dicomObjectCopier.copyElement(1406);
        dicomObjectCopier.copyElement(1407);
        DicomDir.copyReferencedSeriesSequence(dicomObject, dicomObject2);
        this.setReferencedFileId(dicomObject2, file);
        if (presentationRecord == null) {
            return this.addPresentationRecord(seriesRecord, dicomObject2);
        }
        return (PresentationRecord)this.swapDicomObject(presentationRecord, dicomObject2);
    }

    PresentationRecord addPresentationRecord(SeriesRecord seriesRecord, DicomObject dicomObject) {
        PresentationRecord presentationRecord = new PresentationRecord(dicomObject);
        this.addRecord(seriesRecord, presentationRecord);
        return presentationRecord;
    }

    ImageRecord addImageRecord(SeriesRecord seriesRecord, DicomObject dicomObject) {
        ImageRecord imageRecord = new ImageRecord(dicomObject);
        this.addRecord(seriesRecord, imageRecord);
        return imageRecord;
    }

    private void setReferencedFileId(DicomObject dicomObject, File file) throws DicomException {
        File file2 = this.getFilesetRoot();
        File file3 = file;
        if (file2 != null && (file3 = FileNaming.getRelativePath(file2, file)) == null) {
            throw new IllegalArgumentException("File [" + file + "] is not inside file set root [" + file2 + "]");
        }
        String[] stringArray = StringSplit.split(file3.getPath(), File.separator, true, true).toArray(new String[0]);
        if (stringArray.length < 1 || stringArray.length > 8) {
            throw new IllegalArgumentException("Expecting filePath with 1-8 components; has: " + stringArray.length);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n2 = stringArray[i2].length();
            if (n2 < 1 || n2 > 8) {
                throw new IllegalArgumentException("Expecting filePath components of length 1-8, but component " + i2 + " has length: " + n2 + ": " + stringArray[i2]);
            }
            if (stringArray[i2].matches(NON_CS_REGEXP)) {
                throw new IllegalArgumentException("filePath component [" + stringArray[i2] + "] uses illegal character.");
            }
            dicomObject.set(50, (Object)stringArray[i2], i2);
        }
    }

    public static DicomDir readDicomDir(File file) throws DicomException, IOException {
        DicomDirReader dicomDirReader = new DicomDirReader(file);
        return dicomDirReader.read();
    }

    private static void copyReferencedSeriesSequence(DicomObject dicomObject, DicomObject dicomObject2) throws DicomException {
        Sequences sequences = new Sequences(dicomObject);
        Sequences sequences2 = new Sequences(dicomObject2);
        for (int i2 = 0; i2 < dicomObject.getSize(109); ++i2) {
            sequences2.set(109, i2, 426, sequences.get(109, i2, 426));
            for (int i3 = 0; i3 < sequences.getSize(109, i2, 113); ++i3) {
                Object object = sequences.get(109, i2, 113, i3, 115);
                sequences2.set(109, i2, 113, i3, 115, object);
                object = sequences.get(109, i2, 113, i3, 116);
                sequences2.set(109, i2, 113, i3, 116, object);
            }
        }
    }

    static {
        RECORD_ID_TAG.put(RECORD_TYPE_PATIENT, new Integer(148));
        RECORD_ID_TAG.put(RECORD_TYPE_STUDY, new Integer(425));
        RECORD_ID_TAG.put(RECORD_TYPE_SERIES, new Integer(426));
        RECORD_ID_TAG.put(RECORD_TYPE_IMAGE, new Integer(53));
        RECORD_ID_TAG.put(RECORD_TYPE_PRESENTATION, new Integer(53));
    }

    public class PresentationRecord
    extends DirectoryRecord {
        PresentationRecord(DicomObject dicomObject) {
            super(dicomObject);
        }
    }

    public class ImageRecord
    extends DirectoryRecord {
        ImageRecord(DicomObject dicomObject) {
            super(dicomObject);
        }
    }

    public class SeriesRecord
    extends DirectoryRecord {
        SeriesRecord(DicomObject dicomObject) {
            super(dicomObject);
        }
    }

    public class StudyRecord
    extends DirectoryRecord {
        StudyRecord(DicomObject dicomObject) {
            super(dicomObject);
        }
    }

    public class PatientRecord
    extends DirectoryRecord {
        PatientRecord(DicomObject dicomObject) {
            super(dicomObject);
        }

        public Person getPatientName() {
            return (Person)this.getDicomObject().get(147);
        }

        public String getPatientId() {
            return (String)this.getDicomObject().get(148);
        }
    }

    public class DirectoryRecord {
        private DicomObject mDicomObject;
        private List mChildren = new ArrayList();

        DirectoryRecord(DicomObject dicomObject) {
            this.mDicomObject = dicomObject;
        }

        private void addChild(DirectoryRecord directoryRecord) {
            this.mChildren.add(directoryRecord);
        }

        public DicomObject getDicomObject() {
            return this.mDicomObject;
        }

        public List getChildren() {
            return Collections.unmodifiableList(this.mChildren);
        }

        public int getNumberOfChildren() {
            return this.mChildren.size();
        }

        public DirectoryRecord getChild(int n2) {
            return (DirectoryRecord)this.mChildren.get(n2);
        }

        String getRecordType() throws DicomException {
            return this.mDicomObject.getS(48);
        }

        public File getReferencedFile() throws DicomException {
            int n2 = this.mDicomObject.getSize(50);
            if (n2 < 1) {
                return null;
            }
            File file = new File(this.mDicomObject.getS(50, 0));
            for (int i2 = 1; i2 < n2; ++i2) {
                file = new File(file, this.mDicomObject.getS(50, i2));
            }
            return file;
        }

        public DirectoryRecord getChild(String string) throws DicomException {
            Iterator iterator = this.mChildren.iterator();
            while (iterator.hasNext()) {
                DirectoryRecord directoryRecord = (DirectoryRecord)iterator.next();
                if (!directoryRecord.getRecordId().equals(string)) continue;
                return directoryRecord;
            }
            return null;
        }

        String getRecordId() throws DicomException {
            int n2 = this.getRecordIdTag();
            return n2 == -1 ? null : this.mDicomObject.getS(n2);
        }

        int getRecordIdTag() throws DicomException {
            String string = this.getRecordType();
            if (string == null) {
                return -1;
            }
            return (Integer)RECORD_ID_TAG.get(string);
        }

        void dump(PrintStream printStream, int n2) throws DicomException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(StringPad.getIndentSpaces(n2));
            if (this.mDicomObject != null) {
                stringBuffer.append(this.toString());
            }
            printStream.println(stringBuffer);
            Iterator iterator = this.getChildren().iterator();
            while (iterator.hasNext()) {
                ((DirectoryRecord)iterator.next()).dump(printStream, n2 + 1);
            }
        }

        public String toString() {
            try {
                return this.getRecordType() + ": " + this.getRecordId();
            }
            catch (DicomException dicomException) {
                return "unknown";
            }
        }

        private void setDicomObject(DicomObject dicomObject) {
            this.mDicomObject = dicomObject;
        }
    }
}

