/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import java.util.ArrayList;

public class DicomDirDirectoryType {
    private static final ArrayList ALL_TYPES = new ArrayList();
    static final DicomDirDirectoryType DICOM_ROOT = new DicomDirDirectoryType("DICOM_ROOT", "DICOM");
    static final DicomDirDirectoryType PATIENT = new DicomDirDirectoryType("PATIENT", "PA");
    static final DicomDirDirectoryType STUDY = new DicomDirDirectoryType("STUDY", "ST");
    static final DicomDirDirectoryType SERIES = new DicomDirDirectoryType("SERIES", "SE");
    private String mName;
    private String mDirectoryNamePrefix;

    private DicomDirDirectoryType(String string, String string2) {
        this.mName = string;
        this.mDirectoryNamePrefix = string2;
        ALL_TYPES.add(this);
    }

    public String getDirectoryNamePrefix() {
        return this.mDirectoryNamePrefix;
    }

    public DicomDirDirectoryType getNextType() {
        int n2 = ALL_TYPES.indexOf(this);
        if (n2 < 0) {
            throw new IllegalStateException("Unknown DicomDirDirectoryType: " + this);
        }
        int n3 = n2 + 1;
        if (n3 >= ALL_TYPES.size()) {
            return null;
        }
        return (DicomDirDirectoryType)ALL_TYPES.get(n3);
    }

    public String toString() {
        return this.mName;
    }
}

