/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import com.intelerad.lib.dicomtools.BasicFilenameProvider;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DicomDirFilenameProvider
extends BasicFilenameProvider {
    private static final String IMAGE_FILE_PREFIX = "IM";
    private static final NumberFormat IMAGE_FILE_NUMBER_FORMAT = new DecimalFormat("000000");
    private Map mFilenameMap = new LinkedHashMap();
    private int mNextIndex = 1;

    public DicomDirFilenameProvider(File file) {
        super(file);
    }

    protected String getFileBasename(String string) {
        if (this.mFilenameMap.containsKey(string)) {
            return (String)this.mFilenameMap.get(string);
        }
        String string2 = IMAGE_FILE_PREFIX + IMAGE_FILE_NUMBER_FORMAT.format(this.mNextIndex);
        this.mFilenameMap.put(string, string2);
        ++this.mNextIndex;
        return string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDirectory() + "\n");
        Iterator iterator = this.mFilenameMap.values().iterator();
        while (iterator.hasNext()) {
            Object v2 = iterator.next();
            stringBuffer.append(v2.toString() + "\n");
        }
        return stringBuffer.toString();
    }
}

