/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import RuntimeTool.DebugManager;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.intelerad.lib.dicomtools.DicomObjectProvider;
import com.intelerad.lib.dicomtools.DicomObjectUpdater;
import java.util.List;

public class DicomObjectFilter
implements DicomObjectProvider {
    private final DicomObjectProvider mInputProvider;
    private final DicomObjectUpdater[] mDicomObjectUpdaters;

    public DicomObjectFilter(DicomObjectProvider dicomObjectProvider, List list) {
        this.mInputProvider = dicomObjectProvider;
        this.mDicomObjectUpdaters = list.toArray(new DicomObjectUpdater[list.size()]);
    }

    public DicomObject getDicomObjectByUid(String string) {
        DicomObject dicomObject = this.mInputProvider.getDicomObjectByUid(string);
        if (dicomObject == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.mDicomObjectUpdaters.length; ++i2) {
            try {
                this.mDicomObjectUpdaters[i2].update(dicomObject);
                continue;
            }
            catch (DicomException dicomException) {
                DebugManager.getDefault().printException("Failed to update DicomObject using " + this.mDicomObjectUpdaters[i2], dicomException);
                return null;
            }
        }
        return dicomObject;
    }
}

