/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.imaging;

import StringUtilities.PrintfFormat;

public class WindowLevel
implements Comparable {
    private static final PrintfFormat PRINTF_FORMAT = new PrintfFormat("%.0f");
    private final double mWidth;
    private final double mCentre;

    private WindowLevel(double d2, double d3) {
        this.mWidth = d2;
        this.mCentre = d3;
    }

    public WindowLevel(WindowLevel windowLevel) {
        this.mWidth = windowLevel.mWidth;
        this.mCentre = windowLevel.mCentre;
    }

    public static WindowLevel createWindowLevelFromWidthCentre(double d2, double d3) {
        return new WindowLevel(d2, d3);
    }

    public static WindowLevel createWindowLevelFromRange(double d2, double d3) {
        double d4 = WindowLevel.convertRangeToWindowCentre(d2, d3);
        double d5 = WindowLevel.convertRangeToWindowWidth(d2, d3);
        return new WindowLevel(Math.abs(d5), d4);
    }

    public double getWidth() {
        return this.mWidth;
    }

    public double getCentre() {
        return this.mCentre;
    }

    public double getLower() {
        return this.mCentre - this.mWidth / 2.0;
    }

    public double getUpper() {
        return this.mCentre + this.mWidth / 2.0;
    }

    public String getUiString() {
        return "W: " + PRINTF_FORMAT.sprintf(this.getWidth()) + " L: " + PRINTF_FORMAT.sprintf(this.getCentre());
    }

    public String toString() {
        return "[" + this.getUiString() + "]";
    }

    public boolean equals(Object object) {
        if (!(object instanceof WindowLevel)) {
            return false;
        }
        WindowLevel windowLevel = (WindowLevel)object;
        return this.mWidth == windowLevel.getWidth() && this.mCentre == windowLevel.getCentre();
    }

    public int compareTo(Object object) {
        WindowLevel windowLevel = (WindowLevel)object;
        if (this.mCentre != windowLevel.mCentre) {
            return Double.compare(this.mCentre, windowLevel.mCentre);
        }
        return Double.compare(this.mWidth, windowLevel.mWidth);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + this.hashDouble(this.mWidth);
        n2 = 37 * n2 + this.hashDouble(this.mCentre);
        return n2;
    }

    private int hashDouble(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        return (int)(l2 ^ l2 >>> 32);
    }

    public static double convertLevelToRangeLower(double d2, double d3) {
        return d2 - d3 / 2.0;
    }

    public static double convertLevelToRangeUpper(double d2, double d3) {
        return WindowLevel.convertLevelToRangeLower(d2, d3) + d3;
    }

    public static double convertRangeToWindowWidth(double d2, double d3) {
        return d3 - d2;
    }

    public static double convertRangeToWindowCentre(double d2, double d3) {
        return (d2 + d3) / 2.0;
    }
}

