/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.roamingprofiles.inteleviewer;

import RuntimeTool.ControlFile;
import StringUtilities.StringSplit;
import com.intelerad.datamodels.userprofile.RoamingTemplate;
import com.intelerad.datamodels.userprofile.RoamingTemplateIdentifier;
import com.intelerad.roamingprofiles.inteleviewer.InteleViewerTemplateConstants;
import com.intelerad.roamingprofiles.inteleviewer.InteleViewerTemplateUtilities;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;

public class InteleViewerLayoutSiteDefaultConverter {
    private static final String CF_SERIES_LAYOUT_GRID = "Series_Layout_Grid";
    private static final String CF_IMAGE_LAYOUT_GRID = "Image_Layout_Grid";
    private static final String RP_SERIES_LAYOUT = "Series View ";
    private static final String RP_IMAGE_LAYOUT = "Image View ";
    private static final String RP_ROWS = "Rows";
    private static final String RP_COLUMNS = "Columns";
    private final ControlFile mInteleViewerSiteDefaults;
    private final String mTemplateName;
    private final int mNumberOfMonitors;

    public static RoamingTemplate createTemplate(ControlFile controlFile, String string, int n2) {
        return new InteleViewerLayoutSiteDefaultConverter(controlFile, string, n2).convertConfigToTemplate();
    }

    private InteleViewerLayoutSiteDefaultConverter(ControlFile controlFile, String string, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("numberOfMonitors must be >= 1, got " + n2);
        }
        this.mInteleViewerSiteDefaults = controlFile;
        this.mTemplateName = string;
        this.mNumberOfMonitors = n2;
    }

    private RoamingTemplate convertConfigToTemplate() {
        RoamingTemplateIdentifier roamingTemplateIdentifier = new RoamingTemplateIdentifier(this.mTemplateName, InteleViewerTemplateConstants.LAYOUT_CATEGORY, InteleViewerTemplateConstants.INTELEVIEWER_CONTEXT);
        RoamingTemplate roamingTemplate = new RoamingTemplate(roamingTemplateIdentifier);
        Iterator iterator = InteleViewerTemplateUtilities.getModalityStrings().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.addModalityPreferences(roamingTemplate, string);
        }
        this.addDefaultModalityPreference(roamingTemplate);
        return roamingTemplate;
    }

    private void addDefaultModalityPreference(RoamingTemplate roamingTemplate) {
        String string = InteleViewerTemplateUtilities.getTemplateModalityPrefix("");
        this.saveTemplateLayout(roamingTemplate, string + RP_SERIES_LAYOUT, new Dimension(this.mNumberOfMonitors, 1));
        this.saveTemplateLayout(roamingTemplate, string + RP_IMAGE_LAYOUT, new Dimension(1, 1));
    }

    private void addModalityPreferences(RoamingTemplate roamingTemplate, String string) {
        String string2 = InteleViewerTemplateUtilities.getSiteDefaultModalityPrefix(string);
        String string3 = InteleViewerTemplateUtilities.getTemplateModalityPrefix(string) + "/";
        Dimension dimension = this.getLayoutSitePref(string2 + CF_SERIES_LAYOUT_GRID);
        Dimension dimension2 = this.getLayoutSitePref(string2 + CF_IMAGE_LAYOUT_GRID);
        if (dimension == null) {
            dimension = new Dimension(1, 1);
        }
        if (dimension2 == null) {
            dimension2 = new Dimension(1, 1);
        }
        if (dimension2.width * dimension2.height > 1 && dimension.width * dimension.height == 1) {
            dimension2 = this.scaleLayout(dimension2, this.mNumberOfMonitors);
        } else {
            dimension = this.scaleLayout(dimension, this.mNumberOfMonitors);
        }
        this.saveTemplateLayout(roamingTemplate, string3 + RP_SERIES_LAYOUT, dimension);
        this.saveTemplateLayout(roamingTemplate, string3 + RP_IMAGE_LAYOUT, dimension2);
    }

    private Dimension scaleLayout(Dimension dimension, int n2) {
        int n3 = (dimension.width - 1) / n2 + 1;
        return new Dimension(n3 * n2, dimension.height);
    }

    private Dimension getLayoutSitePref(String string) {
        String string2 = this.mInteleViewerSiteDefaults.GetStringValue("CLINICAL_VIEWER_SITE_PREFERENCES", string);
        List list = StringSplit.split(string2, ",", true, true);
        if (list.size() != 2) {
            return null;
        }
        try {
            int n2 = Integer.parseInt((String)list.get(0));
            int n3 = Integer.parseInt((String)list.get(1));
            if (n2 < 1 || n3 < 1) {
                return null;
            }
            return new Dimension(n3, n2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void saveTemplateLayout(RoamingTemplate roamingTemplate, String string, Dimension dimension) {
        roamingTemplate.put(string + RP_ROWS, dimension.height + "");
        roamingTemplate.put(string + RP_COLUMNS, dimension.width + "");
    }
}

