/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.roamingprofiles.inteleviewer;

import RuntimeTool.ControlFile;
import RuntimeTool.ControlFileException;
import RuntimeTool.DebugManager;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class InteleViewerTemplateUtilities {
    private static final String INTELEVIEWER_CONTROL_FILE = "/usr/local/tools/control_files/InteleViewer.cfg";
    public static final String INTELEVIEWER_SITE_PREFERENCES_SECTION = "CLINICAL_VIEWER_SITE_PREFERENCES";
    private static final List INTELEVIEWER_MODALITIES = Collections.unmodifiableList(Arrays.asList("CR", "CT", "DX", "ES", "MG", "MR", "NM", "OT", "PT", "RF", "US", "XA"));

    public static ControlFile readInteleViewerSitePreferences() {
        try {
            ControlFile controlFile = new ControlFile(INTELEVIEWER_CONTROL_FILE);
            controlFile.Read();
            return controlFile;
        }
        catch (ControlFileException controlFileException) {
            DebugManager.getGlobalDefault().printException("Unable to read InteleViewer control file", controlFileException);
            ControlFile controlFile = new ControlFile(new StringReader(""), INTELEVIEWER_CONTROL_FILE);
            try {
                controlFile.Read();
            }
            catch (ControlFileException controlFileException2) {
                IllegalStateException illegalStateException = new IllegalStateException(controlFileException2.getMessage());
                illegalStateException.initCause(controlFileException2);
                throw illegalStateException;
            }
            return controlFile;
        }
    }

    static List getModalityStrings() {
        return INTELEVIEWER_MODALITIES;
    }

    static String getSiteDefaultModalityPrefix(String string) {
        return "Modality-" + string + "-";
    }

    static String getTemplateModalityPrefix(String string) {
        return "/Modality/" + string;
    }
}

