/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib;

import RuntimeTool.DebugManager;
import java.util.Timer;
import java.util.TimerTask;

public class RateLimitedRunnable
implements Runnable {
    private static final Timer mTimer = new Timer(true);
    private final Runnable mRunnable;
    private final long mMinimumIntervalMillis;
    private volatile boolean mIsLockedOut = false;
    private volatile boolean mOutstandingRequest = false;

    public RateLimitedRunnable(Runnable runnable, long l2) {
        this.mRunnable = runnable;
        this.mMinimumIntervalMillis = l2;
    }

    public synchronized void run() {
        try {
            if (this.mIsLockedOut) {
                this.mOutstandingRequest = true;
            } else {
                this.mRunnable.run();
                this.mIsLockedOut = true;
                mTimer.schedule(this.createDelayedTask(), this.mMinimumIntervalMillis);
            }
        }
        catch (Exception exception) {
            DebugManager.getDefault().printException("RateLimitedRunnable delayed call failed", exception);
        }
    }

    private synchronized void endLockout() {
        this.mIsLockedOut = false;
        if (this.mOutstandingRequest) {
            this.mOutstandingRequest = false;
            this.run();
        }
    }

    private TimerTask createDelayedTask() {
        return new TimerTask(){

            public void run() {
                RateLimitedRunnable.this.endLockout();
            }
        };
    }
}

