/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import com.intelerad.tools.lib.concurrent.BasicTaskController;
import com.intelerad.tools.lib.concurrent.CallAdapter;
import com.intelerad.tools.lib.concurrent.Cancellable;
import com.intelerad.tools.lib.concurrent.CancellationException;
import com.intelerad.tools.lib.concurrent.CompositeCallListener;
import com.intelerad.tools.lib.concurrent.ExecutionException;
import com.intelerad.tools.lib.concurrent.FunctionResult;
import com.intelerad.tools.lib.concurrent.FunctionResultBundle;
import com.intelerad.tools.lib.concurrent.Invoker;
import com.intelerad.tools.lib.concurrent.TaskController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class BasicCompositeTaskController
implements TaskController {
    private BasicTaskController mBasicTaskController;
    private CompositeCallListener mListener;
    private List mResults = Collections.synchronizedList(new LinkedList());
    private Invoker mInvoker;

    public BasicCompositeTaskController(Cancellable cancellable, CompositeCallListener compositeCallListener, Invoker invoker) {
        this.mListener = compositeCallListener;
        this.mInvoker = invoker;
        CallAdapter callAdapter = new CallAdapter(){

            public void handleCancel() {
                BasicCompositeTaskController.this.mListener.handleCancel();
            }

            public void handleFinally() {
                BasicCompositeTaskController.this.mListener.handleFinally();
            }
        };
        this.mBasicTaskController = new BasicTaskController(cancellable, callAdapter, invoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartialSuccess(final Object object, final Object object2) {
        List list = this.mResults;
        synchronized (list) {
            if (this.mBasicTaskController.hasTaskReturnedAResult()) {
                return;
            }
            this.mResults.add(new FunctionResultBundle(FunctionResult.createResult(object), object2));
            Runnable runnable = new Runnable(){

                public void run() {
                    if (BasicCompositeTaskController.this.mBasicTaskController.isCancelled()) {
                        return;
                    }
                    BasicCompositeTaskController.this.mListener.handlePartialSuccess(object, object2);
                }
            };
            this.dispatchRunnable(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartialException(final Exception exception, final Object object) {
        List list = this.mResults;
        synchronized (list) {
            if (this.mBasicTaskController.hasTaskReturnedAResult()) {
                return;
            }
            this.mResults.add(new FunctionResultBundle(FunctionResult.createException(exception), object));
            Runnable runnable = new Runnable(){

                public void run() {
                    if (BasicCompositeTaskController.this.mBasicTaskController.isCancelled()) {
                        return;
                    }
                    BasicCompositeTaskController.this.mListener.handlePartialException(exception, object);
                }
            };
            this.dispatchRunnable(runnable);
        }
    }

    private void dispatchRunnable(Runnable runnable) {
        this.mInvoker.invoke(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        List list = this.mResults;
        synchronized (list) {
            this.mBasicTaskController.setResult(new ArrayList(this.mResults));
        }
    }

    public void cancel() {
        this.mBasicTaskController.cancel();
    }

    public Object get() throws ExecutionException, InterruptedException, CancellationException {
        throw new UnsupportedOperationException("This method cannot be invoked for a this object.");
    }

    public boolean isCancelled() {
        return this.mBasicTaskController.isCancelled();
    }

    public boolean isDone() {
        return this.mBasicTaskController.isDone();
    }
}

