/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import com.intelerad.tools.lib.concurrent.Executor;
import java.util.LinkedList;

public class BoundedExecutor
implements Executor {
    private LinkedList mQueue = new LinkedList();
    private int mRunnableCount;
    private int mConcurrency;
    private Executor mExecutor;

    public BoundedExecutor(int n2) {
        this(n2, new Executor(){

            public void execute(Runnable runnable) {
                new Thread(runnable, "Bounded Executor Thread").start();
            }
        });
    }

    public BoundedExecutor(int n2, Executor executor) {
        this.mConcurrency = n2;
        this.mExecutor = executor;
    }

    public synchronized void execute(Runnable runnable) {
        this.mQueue.add(runnable);
        this.startNewRunnable();
    }

    public synchronized void startNewRunnable() {
        while (!this.mQueue.isEmpty() && this.mRunnableCount < this.mConcurrency) {
            final Runnable runnable = (Runnable)this.mQueue.removeFirst();
            ++this.mRunnableCount;
            Runnable runnable2 = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        runnable.run();
                    }
                    finally {
                        BoundedExecutor.this.endRunnable();
                    }
                }
            };
            this.mExecutor.execute(runnable2);
        }
    }

    public synchronized void endRunnable() {
        --this.mRunnableCount;
        this.startNewRunnable();
    }
}

