/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import com.intelerad.tools.lib.concurrent.Callable;

public final class FunctionResult
implements Callable {
    private final Object mResult;
    private final Throwable mException;

    public static FunctionResult saveFunctionResult(Callable callable) {
        try {
            return new FunctionResult(callable.call(), null);
        }
        catch (Throwable throwable) {
            return new FunctionResult(null, throwable);
        }
    }

    public static FunctionResult createResult(Object object) {
        return new FunctionResult(object, null);
    }

    public static FunctionResult createException(Throwable throwable) {
        return new FunctionResult(null, throwable);
    }

    private FunctionResult(Object object, Throwable throwable) {
        if (object != null && throwable != null) {
            throw new IllegalArgumentException("It's not possible to result a result and exception at the same time.");
        }
        if (throwable != null && !(throwable instanceof Exception) && !(throwable instanceof Error)) {
            throw new IllegalArgumentException("Exception must be an instance of Error or Exception.");
        }
        this.mException = throwable;
        this.mResult = object;
    }

    public boolean isException() {
        return this.mException != null;
    }

    public Object getResult() {
        return this.mResult;
    }

    public Throwable getException() {
        return this.mException;
    }

    public Object call() throws Exception {
        if (this.mException != null) {
            if (this.mException instanceof Error) {
                throw (Error)this.mException;
            }
            if (this.mException instanceof Exception) {
                throw (Exception)this.mException;
            }
            throw new IllegalStateException("Function result was a sub-class of Throwable that was not Exception or Error!");
        }
        return this.mResult;
    }
}

