/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import sun.awt.EmbeddedFrame;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

public class WEmbeddedFrame
extends EmbeddedFrame {
    private long handle;
    private int bandWidth = 0;
    private int bandHeight = 0;
    private int imgWid = 0;
    private int imgHgt = 0;
    private static final int MAX_BAND_SIZE = 30720;
    private static Field peerField;

    public WEmbeddedFrame() {
        this(0L);
    }

    @Deprecated
    public WEmbeddedFrame(int n) {
        this((long)n);
    }

    public WEmbeddedFrame(long l) {
        this.handle = l;
        if (l != 0L) {
            this.addNotify();
            this.show();
        }
    }

    public void addNotify() {
        if (this.getPeer() == null) {
            WToolkit wToolkit = (WToolkit)Toolkit.getDefaultToolkit();
            this.setPeer(wToolkit.createEmbeddedFrame(this));
        }
        super.addNotify();
    }

    void print(int n) {
        BufferedImage bufferedImage = null;
        int n2 = 1;
        int n3 = 1;
        if (this.isPrinterDC(n)) {
            n2 = 4;
            n3 = 4;
        }
        int n4 = this.getHeight();
        if (bufferedImage == null) {
            this.bandWidth = this.getWidth();
            if (this.bandWidth % 4 != 0) {
                this.bandWidth += 4 - this.bandWidth % 4;
            }
            if (this.bandWidth <= 0) {
                return;
            }
            this.bandHeight = Math.min(30720 / this.bandWidth, n4);
            this.imgWid = this.bandWidth * n2;
            this.imgHgt = this.bandHeight * n3;
            bufferedImage = new BufferedImage(this.imgWid, this.imgHgt, 5);
        }
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.translate(0, this.imgHgt);
        graphics2D.scale(n2, -n3);
        ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage.getRaster();
        byte[] byArray = byteInterleavedRaster.getDataStorage();
        for (int i = 0; i < n4; i += this.bandHeight) {
            graphics.fillRect(0, 0, this.bandWidth, this.bandHeight);
            this.printComponents(graphics2D);
            int n5 = 0;
            int n6 = this.bandHeight;
            int n7 = this.imgHgt;
            if (i + this.bandHeight > n4) {
                n6 = n4 - i;
                n7 = n6 * n3;
                n5 = this.imgWid * (this.imgHgt - n7) * 3;
            }
            this.printBand(n, byArray, n5, 0, 0, this.imgWid, n7, 0, i, this.bandWidth, n6);
            graphics2D.translate(0, -this.bandHeight);
        }
    }

    protected native boolean isPrinterDC(long var1);

    protected native void printBand(long var1, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private static native void initIDs();

    public void activateEmbeddingTopLevel() {
    }

    public void synthesizeWindowActivation(boolean bl) {
        ((WEmbeddedFramePeer)this.getPeer()).synthesizeWmActivate(bl);
    }

    public void registerAccelerator(AWTKeyStroke aWTKeyStroke) {
    }

    public void unregisterAccelerator(AWTKeyStroke aWTKeyStroke) {
    }

    public void notifyModalBlocked(Dialog dialog, boolean bl) {
        try {
            this.notifyModalBlockedImpl((WEmbeddedFramePeer)peerField.get(this), (WWindowPeer)peerField.get(dialog), bl);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    native void notifyModalBlockedImpl(WEmbeddedFramePeer var1, WWindowPeer var2, boolean var3);

    static {
        WEmbeddedFrame.initIDs();
        peerField = WToolkit.getField(Component.class, "peer");
    }
}

