/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.config.Config;
import java.io.File;
import java.io.IOException;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CachedJarFile
extends JarFile {
    private CodeSigner[] signers;
    private HashMap signerMap = null;
    private Manifest manifest = null;

    public Object clone() throws CloneNotSupportedException {
        try {
            return new CachedJarFile(new File(this.getName()), this.signers, (HashMap)this.signerMap.clone(), this.getManifest());
        }
        catch (IOException iOException) {
            throw new CloneNotSupportedException(iOException.getMessage());
        }
    }

    protected CachedJarFile(File file, CodeSigner[] codeSignerArray, HashMap hashMap, Manifest manifest) throws IOException {
        super(file, false);
        this.signers = codeSignerArray;
        this.signerMap = hashMap;
        this.manifest = manifest;
        if (!Config.isJavaVersionAtLeast16()) {
            super.getManifest();
        }
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration<JarEntry> enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                return new JarFileEntry(zipEntry);
            }
        };
    }

    public Manifest getManifest() throws IOException {
        Manifest manifest = null;
        if (this.manifest != null) {
            manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putAll((Map<?, ?>)((Map)this.manifest.getMainAttributes().clone()));
            Map<String, Attributes> map = this.manifest.getEntries();
            if (map != null) {
                Map<String, Attributes> map2 = manifest.getEntries();
                Iterator<String> iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    Attributes attributes2 = map.get(string);
                    map2.put(string, (Attributes)attributes2.clone());
                }
            }
        }
        return manifest;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Attributes attributes;
            if (CachedJarFile.this.manifest != null && (attributes = CachedJarFile.this.manifest.getAttributes(this.getName())) != null) {
                return (Attributes)attributes.clone();
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray = null;
            int[] nArray = this.getSignerIndices();
            if (nArray != null) {
                ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.addAll(CachedJarFile.this.signers[nArray[i]].getSignerCertPath().getCertificates());
                }
                return arrayList.toArray(new Certificate[arrayList.size()]);
            }
            return certificateArray;
        }

        public CodeSigner[] getCodeSigners() {
            CodeSigner[] codeSignerArray = null;
            int[] nArray = this.getSignerIndices();
            if (CachedJarFile.this.signers != null && nArray != null) {
                codeSignerArray = new CodeSigner[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    if (CachedJarFile.this.signers == null) continue;
                    codeSignerArray[i] = CachedJarFile.this.signers[nArray[i]];
                }
            }
            return codeSignerArray;
        }

        private int[] getSignerIndices() {
            if (CachedJarFile.this.signerMap != null && !CachedJarFile.this.signerMap.isEmpty()) {
                return (int[])CachedJarFile.this.signerMap.get(this.getName());
            }
            return null;
        }
    }
}

