/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.panel.JavawsTableModel;
import com.sun.deploy.panel.JreFindDialog;
import com.sun.deploy.panel.PathEditor;
import com.sun.deploy.panel.PathRenderer;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JavawsJreDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener {
    private final JButton _findBtn = this.makeButton("jnlp.jre.find.button");
    private final JButton _addBtn = this.makeButton("jnlp.jre.add.button");
    private final JButton _removeBtn = this.makeButton("jnlp.jre.remove.button");
    private final JButton _okBtn = new JButton(ResourceManager.getMessage("jnlp.jre.ok.button"));
    private final JButton _cancelBtn;
    private final JavawsTableModel _sysTableModel;
    private final JavawsTableModel _userTableModel;
    private final JTabbedPane _tabbedPane;
    private final JTable _userTable;
    private final JTable _sysTable;
    private final JScrollPane _userTab;
    private final JScrollPane _systemTab;

    public JavawsJreDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this._okBtn.addActionListener(this);
        this._cancelBtn = new JButton(ResourceManager.getMessage("jnlp.jre.cancel.button"));
        this._cancelBtn.addActionListener(this);
        this._tabbedPane = new JTabbedPane();
        this._userTableModel = new JavawsTableModel(false);
        this._userTable = new JTable(this._userTableModel);
        this._sysTableModel = new JavawsTableModel(true);
        this._sysTable = new JTable(this._sysTableModel);
        this._userTab = new JScrollPane(this._userTable);
        this._systemTab = new JScrollPane(this._sysTable);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(ResourceManager.getMessage("jnlp.jre.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JavawsJreDialog.this.closeDialog();
            }
        });
        this._findBtn.setToolTipText(ResourceManager.getMessage("jnlp.jre.find_btn.tooltip"));
        this._addBtn.setToolTipText(ResourceManager.getMessage("jnlp.jre.add_btn.tooltip"));
        this._removeBtn.setToolTipText(ResourceManager.getMessage("jnlp.jre.remove_btn.tooltip"));
        JButton[] jButtonArray = new JButton[]{this._findBtn, this._addBtn, this._removeBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(ResourceManager.getMessage("jnlp.jre.versions")));
        Dimension dimension = new Dimension(500, 150);
        LineBorder lineBorder = new LineBorder(this._userTable.getForeground());
        this._userTable.setBorder(lineBorder);
        this._userTable.setPreferredScrollableViewportSize(dimension);
        this._sysTable.setBorder(lineBorder);
        this._sysTable.setPreferredScrollableViewportSize(dimension);
        this._tabbedPane.addTab(ResourceManager.getMessage("cert.dialog.user.level"), this._userTab);
        this._tabbedPane.addTab(ResourceManager.getMessage("cert.dialog.system.level"), this._systemTab);
        this._tabbedPane.setSelectedIndex(0);
        this._tabbedPane.addChangeListener(this);
        jPanel.add((Component)this._tabbedPane, "North");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this._findBtn);
        box.add(Box.createHorizontalStrut(5));
        box.add(this._addBtn);
        box.add(Box.createHorizontalStrut(5));
        box.add(this._removeBtn);
        jPanel.add((Component)box, "South");
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 10, 5));
        JButton[] jButtonArray2 = new JButton[]{this._okBtn, this._cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray2);
        jPanel2.add(this._okBtn);
        jPanel2.add(this._cancelBtn);
        this.getContentPane().add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(this._okBtn);
        this.enableButtons();
        this.pack();
        this._userTable.getSelectionModel().addListSelectionListener(this);
        this._userTable.getColumnModel().getColumn(3).setCellRenderer(new PathRenderer());
        this._userTable.getColumnModel().getColumn(3).setCellEditor(new PathEditor());
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavawsJreDialog.this.closeDialog();
            }
        });
        this._userTable.getTableHeader().setFocusable(false);
        this._sysTable.getTableHeader().setFocusable(false);
    }

    public JButton makeButton(String string) {
        JButton jButton = new JButton(ResourceManager.getMessage(string));
        jButton.setMnemonic(ResourceManager.getVKCode(string + ".mnemonic"));
        jButton.addActionListener(this);
        return jButton;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.enableButtons();
    }

    public void enableButtons() {
        Component component = this._tabbedPane.getSelectedComponent();
        if (component != null) {
            if (component.equals(this._userTab)) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                for (int i = 0; i < this._userTableModel.getRowCount(); ++i) {
                    if (this._userTable.isRowSelected(i)) {
                        bl2 = true;
                        if (!this._userTableModel.getJRE(i).isRegistered()) continue;
                        bl3 = true;
                        continue;
                    }
                    if (!this._userTableModel.isPathValid(i)) continue;
                    bl = true;
                }
                this._removeBtn.setEnabled(bl2 && !bl3 && bl);
                this._findBtn.setEnabled(true);
                this._addBtn.setEnabled(true);
            } else {
                this._removeBtn.setEnabled(false);
                this._findBtn.setEnabled(false);
                this._addBtn.setEnabled(false);
            }
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        JTable jTable = this.getSelectedTable();
        JavawsTableModel javawsTableModel = (JavawsTableModel)jTable.getModel();
        if (jButton == this._findBtn) {
            this.findJREs();
        } else if (jButton == this._addBtn) {
            javawsTableModel.add(new JREInfo(null, null, null, null, Config.getOSName(), Config.getOSArch(), true, false), false, true);
            int n = javawsTableModel.getRowCount() - 1;
            jTable.requestFocus();
            jTable.setRowSelectionInterval(n, n);
        } else if (jButton == this._removeBtn) {
            javawsTableModel.remove(this._userTable.getSelectedRows());
        } else if (jButton == this._okBtn) {
            this.apply();
            ControlPanel.propertyHasChanged();
            this.closeDialog();
        } else if (jButton == this._cancelBtn) {
            this.closeDialog();
        }
    }

    private JTable getSelectedTable() {
        return this._tabbedPane.getSelectedComponent() == this._userTab ? this._userTable : this._sysTable;
    }

    public void apply() {
        int n;
        JavawsTableModel javawsTableModel;
        JTable jTable = this._userTable;
        if (jTable.isEditing()) {
            jTable.getCellEditor().stopCellEditing();
        }
        if ((javawsTableModel = (JavawsTableModel)jTable.getModel()).getRowCount() > 0) {
            JREInfo.clear();
            for (n = 0; n < javawsTableModel.getRowCount(); ++n) {
                JREInfo.addJRE(javawsTableModel.getJRE(n));
            }
        }
        if ((jTable = this._sysTable).isEditing()) {
            jTable.getCellEditor().stopCellEditing();
        }
        if ((javawsTableModel = (JavawsTableModel)jTable.getModel()).getRowCount() > 0) {
            for (n = 0; n < javawsTableModel.getRowCount(); ++n) {
                JREInfo.addJRE(javawsTableModel.getJRE(n));
            }
        }
        Iterator iterator = javawsTableModel.getHiddenJREs().iterator();
        while (iterator.hasNext()) {
            JREInfo.addJRE((JREInfo)iterator.next());
        }
    }

    private void findJREs() {
        JTable jTable = this.getSelectedTable();
        JavawsTableModel javawsTableModel = (JavawsTableModel)jTable.getModel();
        try {
            JREInfo[] jREInfoArray = JreFindDialog.search(this);
            if (jREInfoArray != null) {
                for (int i = 0; i < jREInfoArray.length; ++i) {
                    javawsTableModel.add(jREInfoArray[i], false, true);
                }
            }
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    private File getFirstValidParent(String string) {
        if (string != null) {
            File file = new File(string);
            while (file != null && !file.exists()) {
                string = file.getParent();
                if (string != null) {
                    file = new File(string);
                    continue;
                }
                file = null;
            }
            return file;
        }
        return null;
    }
}

