/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.FdfWriter;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TextField;
import com.lowagie.text.pdf.XfdfReader;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AcroFields {
    PdfReader reader;
    PdfWriter writer;
    HashMap fields;
    private int topFirst;
    private ArrayList sigNames;
    private static final int DA_FONT = 0;
    private static final int DA_SIZE = 1;
    private static final int DA_COLOR = 2;
    private boolean lastWasString;
    private boolean generateAppearances = true;

    AcroFields(PdfReader pdfReader, PdfWriter pdfWriter) {
        this.reader = pdfReader;
        this.writer = pdfWriter;
        this.fill();
    }

    void fill() {
        this.fields = new HashMap();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
            PdfDictionary pdfDictionary2 = this.reader.getPageN(i);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ANNOTS));
            if (pdfArray == null) continue;
            ArrayList arrayList = pdfArray.getArrayList();
            for (int j = 0; j < arrayList.size(); ++j) {
                Object object;
                PdfDictionary pdfDictionary3;
                PdfObject pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(j));
                if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || !PdfName.WIDGET.equals((pdfDictionary3 = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                PdfDictionary pdfDictionary4 = pdfDictionary3;
                PdfDictionary pdfDictionary5 = new PdfDictionary();
                pdfDictionary5.putAll(pdfDictionary3);
                String string = "";
                PdfDictionary pdfDictionary6 = null;
                PdfObject pdfObject2 = null;
                while (pdfDictionary3 != null) {
                    pdfDictionary5.mergeDifferent(pdfDictionary3);
                    object = (PdfString)pdfDictionary3.get(PdfName.T);
                    if (object != null) {
                        string = ((PdfString)object).toUnicodeString() + "." + string;
                    }
                    if (pdfObject2 == null && pdfDictionary3.get(PdfName.V) != null) {
                        pdfObject2 = pdfDictionary3.get(PdfName.V);
                    }
                    if (pdfDictionary6 == null && object != null) {
                        pdfDictionary6 = pdfDictionary3;
                        if (pdfDictionary3.get(PdfName.V) == null && pdfObject2 != null) {
                            pdfDictionary6.put(PdfName.V, pdfObject2);
                        }
                    }
                    pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.PARENT));
                }
                if (string.length() > 0) {
                    string = string.substring(0, string.length() - 1);
                }
                if ((object = (Item)this.fields.get(string)) == null) {
                    object = new Item();
                    this.fields.put(string, object);
                }
                if (pdfDictionary6 == null) {
                    ((Item)object).values.add(pdfDictionary4);
                } else {
                    ((Item)object).values.add(pdfDictionary6);
                }
                ((Item)object).widgets.add(pdfDictionary4);
                ((Item)object).widget_refs.add(arrayList.get(j));
                if (pdfDictionary != null) {
                    pdfDictionary5.mergeDifferent(pdfDictionary);
                }
                ((Item)object).merged.add(pdfDictionary5);
                ((Item)object).page.add(new Integer(i));
                ((Item)object).tabOrder.add(new Integer(j));
            }
        }
    }

    public String[] getAppearanceStates(String string) {
        PdfObject pdfObject;
        int n;
        ArrayList arrayList;
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        PdfDictionary pdfDictionary = (PdfDictionary)item.values.get(0);
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.OPT));
        if (pdfObject2 != null) {
            if (pdfObject2.isString()) {
                hashMap.put(((PdfString)pdfObject2).toUnicodeString(), null);
            } else if (pdfObject2.isArray()) {
                arrayList = ((PdfArray)pdfObject2).getArrayList();
                for (n = 0; n < arrayList.size(); ++n) {
                    pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                    if (pdfObject == null || !pdfObject.isString()) continue;
                    hashMap.put(((PdfString)pdfObject).toUnicodeString(), null);
                }
            }
        }
        arrayList = item.widgets;
        for (n = 0; n < arrayList.size(); ++n) {
            PdfObject pdfObject3;
            pdfObject = (PdfDictionary)arrayList.get(n);
            if ((pdfObject = (PdfDictionary)((PdfDictionary)pdfObject).get(PdfName.AP)) == null || (pdfObject3 = ((PdfDictionary)pdfObject).get(PdfName.N)) == null || !pdfObject3.isDictionary()) continue;
            pdfObject = (PdfDictionary)pdfObject3;
            Iterator iterator = ((PdfDictionary)pdfObject).getKeys().iterator();
            while (iterator.hasNext()) {
                String string2 = PdfName.decodeName(((PdfName)iterator.next()).toString());
                hashMap.put(string2, null);
            }
        }
        String[] stringArray = new String[hashMap.size()];
        return hashMap.keySet().toArray(stringArray);
    }

    public void exportAsFdf(FdfWriter fdfWriter) {
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Item item = (Item)entry.getValue();
            String string = (String)entry.getKey();
            PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
            if (pdfObject == null) continue;
            String string2 = this.getField(string);
            if (this.lastWasString) {
                fdfWriter.setFieldAsString(string, string2);
                continue;
            }
            fdfWriter.setFieldAsName(string, string2);
        }
    }

    public boolean renameField(String string, String string2) {
        int n;
        int n2 = string.lastIndexOf(46) + 1;
        if (n2 != (n = string2.lastIndexOf(46) + 1)) {
            return false;
        }
        if (!string.substring(0, n2).equals(string2.substring(0, n))) {
            return false;
        }
        if (this.fields.containsKey(string2)) {
            return false;
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        string2 = string2.substring(n);
        PdfString pdfString = new PdfString(string2, "UnicodeBig");
        for (int i = 0; i < item.merged.size(); ++i) {
            PdfDictionary pdfDictionary = (PdfDictionary)item.values.get(i);
            pdfDictionary.put(PdfName.T, pdfString);
            pdfDictionary = (PdfDictionary)item.merged.get(i);
            pdfDictionary.put(PdfName.T, pdfString);
        }
        this.fields.remove(string);
        this.fields.put(string2, item);
        return true;
    }

    private static Object[] splitDAelements(String string) {
        try {
            PRTokeniser pRTokeniser = new PRTokeniser(PdfEncodings.convertToBytes(string, null));
            ArrayList<String> arrayList = new ArrayList<String>();
            Object[] objectArray = new Object[3];
            while (pRTokeniser.nextToken()) {
                if (pRTokeniser.getTokenType() == 4) continue;
                if (pRTokeniser.getTokenType() == 10) {
                    float f;
                    float f2;
                    float f3;
                    String string2 = pRTokeniser.getStringValue();
                    if (string2.equals("Tf")) {
                        if (arrayList.size() >= 2) {
                            objectArray[0] = arrayList.get(arrayList.size() - 2);
                            objectArray[1] = new Float((String)arrayList.get(arrayList.size() - 1));
                        }
                    } else if (string2.equals("g")) {
                        if (arrayList.size() >= 1 && (f3 = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue()) != 0.0f) {
                            objectArray[2] = new GrayColor(f3);
                        }
                    } else if (string2.equals("rg")) {
                        if (arrayList.size() >= 3) {
                            f3 = new Float((String)arrayList.get(arrayList.size() - 3)).floatValue();
                            f2 = new Float((String)arrayList.get(arrayList.size() - 2)).floatValue();
                            f = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue();
                            objectArray[2] = new Color(f3, f2, f);
                        }
                    } else if (string2.equals("k") && arrayList.size() >= 4) {
                        f3 = new Float((String)arrayList.get(arrayList.size() - 4)).floatValue();
                        f2 = new Float((String)arrayList.get(arrayList.size() - 3)).floatValue();
                        f = new Float((String)arrayList.get(arrayList.size() - 2)).floatValue();
                        float f4 = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue();
                        objectArray[2] = new CMYKColor(f3, f2, f, f4);
                    }
                    arrayList.clear();
                    continue;
                }
                arrayList.add(pRTokeniser.getStringValue());
            }
            return objectArray;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    PdfAppearance getAppearance(PdfDictionary pdfDictionary, String string) throws IOException, DocumentException {
        Object object;
        Object object2;
        PdfObject pdfObject;
        PdfObject pdfObject2;
        PdfObject pdfObject3;
        PdfObject pdfObject4;
        Object object3;
        this.topFirst = 0;
        TextField textField = new TextField(this.writer, null, null);
        PdfString pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DA));
        if (pdfString != null) {
            object3 = AcroFields.splitDAelements(pdfString.toUnicodeString());
            if (object3[1] != null) {
                textField.setFontSize(((Float)object3[1]).floatValue());
            }
            if (object3[2] != null) {
                textField.setTextColor((Color)object3[2]);
            }
            if (object3[0] != null && (pdfObject4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DR))) != null && (pdfObject4 = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)pdfObject4).get(PdfName.FONT))) != null && (pdfObject3 = ((PdfDictionary)pdfObject4).get(new PdfName((String)object3[0]))) != null && pdfObject3.type() == 10) {
                textField.setFont(new DocumentFont((PRIndirectReference)pdfObject3));
            }
        }
        if ((object3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MK))) != null) {
            pdfObject4 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object3).get(PdfName.BC));
            textField.setBorderColor(this.getMKColor((PdfArray)pdfObject4));
            pdfObject4 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object3).get(PdfName.BG));
            textField.setBackgroundColor(this.getMKColor((PdfArray)pdfObject4));
            pdfObject3 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object3).get(PdfName.R));
            if (pdfObject3 != null) {
                textField.setRotation(((PdfNumber)pdfObject3).intValue());
            }
        }
        int n = 0;
        pdfObject3 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FF));
        if (pdfObject3 != null) {
            n = ((PdfNumber)pdfObject3).intValue();
        }
        textField.setOptions(((n & 0x1000) == 0 ? 0 : 4) | ((n & 0x1000000) == 0 ? 0 : 256));
        if ((n & 0x1000000) != 0) {
            pdfObject2 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MAXLEN));
            int n2 = 0;
            if (pdfObject2 != null) {
                n2 = ((PdfNumber)pdfObject2).intValue();
            }
            textField.setMaxCharacterLength(n2);
        }
        if ((pdfObject3 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.Q))) != null) {
            if (((PdfNumber)pdfObject3).intValue() == 1) {
                textField.setAlignment(1);
            } else if (((PdfNumber)pdfObject3).intValue() == 2) {
                textField.setAlignment(2);
            }
        }
        if ((pdfObject2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BS))) != null) {
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.W));
            if (pdfObject != null) {
                textField.setBorderWidth(((PdfNumber)pdfObject).floatValue());
            }
            if (PdfName.D.equals(object2 = (PdfName)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.S)))) {
                textField.setBorderStyle(1);
            } else if (PdfName.B.equals(object2)) {
                textField.setBorderStyle(2);
            } else if (PdfName.I.equals(object2)) {
                textField.setBorderStyle(3);
            } else if (PdfName.U.equals(object2)) {
                textField.setBorderStyle(4);
            }
        } else {
            pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BORDER));
            if (pdfObject != null) {
                object2 = ((PdfArray)pdfObject).getArrayList();
                if (((ArrayList)object2).size() >= 3) {
                    textField.setBorderWidth(((PdfNumber)((ArrayList)object2).get(2)).floatValue());
                }
                if (((ArrayList)object2).size() >= 4) {
                    textField.setBorderStyle(1);
                }
            }
        }
        pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT));
        object2 = PdfReader.getNormalizedRectangle((PdfArray)pdfObject);
        if (textField.getRotation() == 90 || textField.getRotation() == 270) {
            object2 = ((Rectangle)object2).rotate();
        }
        textField.setBox((Rectangle)object2);
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FT));
        if (PdfName.TX.equals(pdfName)) {
            textField.setText(string);
            return textField.getAppearance();
        }
        if (!PdfName.CH.equals(pdfName)) {
            throw new DocumentException("An appearance was requested without a variable text field.");
        }
        if ((n & 0x20000) != 0) {
            textField.setText(string);
            return textField.getAppearance();
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.OPT));
        boolean bl = false;
        if (pdfArray != null) {
            int n3;
            object = pdfArray.getArrayList();
            String[] stringArray = new String[((ArrayList)object).size()];
            String[] stringArray2 = new String[((ArrayList)object).size()];
            for (n3 = 0; n3 < ((ArrayList)object).size(); ++n3) {
                PdfObject pdfObject5 = (PdfObject)((ArrayList)object).get(n3);
                if (pdfObject5.isString()) {
                    stringArray[n3] = stringArray2[n3] = ((PdfString)pdfObject5).toUnicodeString();
                    continue;
                }
                ArrayList arrayList = ((PdfArray)pdfObject5).getArrayList();
                stringArray2[n3] = ((PdfString)arrayList.get(0)).toUnicodeString();
                stringArray[n3] = ((PdfString)arrayList.get(1)).toUnicodeString();
            }
            n3 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                n3 = i;
                break;
            }
            textField.setChoices(stringArray);
            textField.setChoiceExports(stringArray2);
            textField.setChoiceSelection(n3);
        }
        object = textField.getListAppearance();
        this.topFirst = textField.getTopFirst();
        return object;
    }

    Color getMKColor(PdfArray pdfArray) {
        if (pdfArray == null) {
            return null;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        switch (arrayList.size()) {
            case 1: {
                return new GrayColor(((PdfNumber)arrayList.get(0)).floatValue());
            }
            case 3: {
                return new Color(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue());
            }
            case 4: {
                return new CMYKColor(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue(), ((PdfNumber)arrayList.get(3)).floatValue());
            }
        }
        return null;
    }

    public String getField(String string) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        this.lastWasString = false;
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
        if (pdfObject == null) {
            return "";
        }
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.BTN.equals(pdfName)) {
            PdfObject pdfObject2;
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            int n = 0;
            if (pdfNumber != null) {
                n = pdfNumber.intValue();
            }
            if ((n & 0x10000) != 0) {
                return "";
            }
            String string2 = "";
            if (pdfObject.isName()) {
                string2 = PdfName.decodeName(pdfObject.toString());
            }
            if ((pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)item.values.get(0)).get(PdfName.OPT))) != null && pdfObject2.isArray()) {
                ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string2);
                    PdfString pdfString = (PdfString)arrayList.get(n2);
                    string2 = pdfString.toUnicodeString();
                    this.lastWasString = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string2;
        }
        if (pdfObject.isString()) {
            this.lastWasString = true;
            return ((PdfString)pdfObject).toUnicodeString();
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    public boolean setFieldProperty(String string, String string2, Object object, int[] nArray) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        InstHit instHit = new InstHit(nArray);
        if (string2.equalsIgnoreCase("textcolor")) {
            for (int i = 0; i < item.merged.size(); ++i) {
                PdfString pdfString;
                if (!instHit.isHit(i) || (pdfString = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(i)).get(PdfName.DA))) == null) continue;
                Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                PdfAppearance pdfAppearance = new PdfAppearance();
                if (objectArray[0] == null) continue;
                ByteBuffer byteBuffer = pdfAppearance.getInternalBuffer();
                byteBuffer.append(new PdfName((String)objectArray[0]).getBytes()).append(' ').append(((Float)objectArray[1]).floatValue()).append(" Tf ");
                pdfAppearance.setColorFill((Color)object);
                PdfString pdfString2 = new PdfString(pdfAppearance.toString());
                ((PdfDictionary)item.merged.get(i)).put(PdfName.DA, pdfString2);
                ((PdfDictionary)item.widgets.get(i)).put(PdfName.DA, pdfString2);
            }
        } else if (string2.equalsIgnoreCase("textsize")) {
            for (int i = 0; i < item.merged.size(); ++i) {
                PdfString pdfString;
                if (!instHit.isHit(i) || (pdfString = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(i)).get(PdfName.DA))) == null) continue;
                Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                PdfAppearance pdfAppearance = new PdfAppearance();
                if (objectArray[0] == null) continue;
                ByteBuffer byteBuffer = pdfAppearance.getInternalBuffer();
                byteBuffer.append(new PdfName((String)objectArray[0]).getBytes()).append(' ').append(((Float)object).floatValue()).append(" Tf ");
                if (objectArray[2] != null) {
                    pdfAppearance.setColorFill((Color)objectArray[2]);
                }
                PdfString pdfString3 = new PdfString(pdfAppearance.toString());
                ((PdfDictionary)item.merged.get(i)).put(PdfName.DA, pdfString3);
                ((PdfDictionary)item.widgets.get(i)).put(PdfName.DA, pdfString3);
            }
        } else if (string2.equalsIgnoreCase("bgcolor") || string2.equalsIgnoreCase("bordercolor")) {
            PdfName pdfName = string2.equalsIgnoreCase("bgcolor") ? PdfName.BG : PdfName.BC;
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(i)).get(PdfName.MK));
                if (pdfDictionary == null) {
                    if (object == null) {
                        return true;
                    }
                    pdfDictionary = new PdfDictionary();
                    ((PdfDictionary)item.merged.get(i)).put(PdfName.MK, pdfDictionary);
                    ((PdfDictionary)item.widgets.get(i)).put(PdfName.MK, pdfDictionary);
                }
                if (object == null) {
                    pdfDictionary.remove(pdfName);
                    continue;
                }
                pdfDictionary.put(pdfName, PdfFormField.getMKColor((Color)object));
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean setFieldProperty(String string, String string2, int n, int[] nArray) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        InstHit instHit = new InstHit(nArray);
        if (string2.equalsIgnoreCase("flags")) {
            PdfNumber pdfNumber = new PdfNumber(n);
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                ((PdfDictionary)item.merged.get(i)).put(PdfName.F, pdfNumber);
                ((PdfDictionary)item.widgets.get(i)).put(PdfName.F, pdfNumber);
            }
        } else if (string2.equalsIgnoreCase("setflags")) {
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.widgets.get(i)).get(PdfName.F));
                int n2 = 0;
                if (pdfNumber != null) {
                    n2 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n2 | n);
                ((PdfDictionary)item.merged.get(i)).put(PdfName.F, pdfNumber);
                ((PdfDictionary)item.widgets.get(i)).put(PdfName.F, pdfNumber);
            }
        } else if (string2.equalsIgnoreCase("clrflags")) {
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.widgets.get(i)).get(PdfName.F));
                int n3 = 0;
                if (pdfNumber != null) {
                    n3 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n3 & ~n);
                ((PdfDictionary)item.merged.get(i)).put(PdfName.F, pdfNumber);
                ((PdfDictionary)item.widgets.get(i)).put(PdfName.F, pdfNumber);
            }
        } else if (string2.equalsIgnoreCase("fflags")) {
            PdfNumber pdfNumber = new PdfNumber(n);
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                ((PdfDictionary)item.merged.get(i)).put(PdfName.FF, pdfNumber);
                ((PdfDictionary)item.values.get(i)).put(PdfName.FF, pdfNumber);
            }
        } else if (string2.equalsIgnoreCase("setfflags")) {
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.values.get(i)).get(PdfName.FF));
                int n4 = 0;
                if (pdfNumber != null) {
                    n4 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n4 | n);
                ((PdfDictionary)item.merged.get(i)).put(PdfName.FF, pdfNumber);
                ((PdfDictionary)item.values.get(i)).put(PdfName.FF, pdfNumber);
            }
        } else if (string2.equalsIgnoreCase("clrfflags")) {
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.values.get(i)).get(PdfName.FF));
                int n5 = 0;
                if (pdfNumber != null) {
                    n5 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n5 & ~n);
                ((PdfDictionary)item.merged.get(i)).put(PdfName.FF, pdfNumber);
                ((PdfDictionary)item.values.get(i)).put(PdfName.FF, pdfNumber);
            }
        } else {
            return false;
        }
        return true;
    }

    public void setFields(FdfReader fdfReader) throws IOException, DocumentException {
        HashMap hashMap = fdfReader.getFields();
        Iterator iterator = this.fields.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = fdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public void setFields(XfdfReader xfdfReader) throws IOException, DocumentException {
        HashMap hashMap = xfdfReader.getFields();
        Iterator iterator = this.fields.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = xfdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public boolean setField(String string, String string2) throws IOException, DocumentException {
        return this.setField(string, string2, string2);
    }

    public boolean setField(String string, String string2, String string3) throws IOException, DocumentException {
        int n;
        PdfObject pdfObject;
        if (this.writer == null) {
            throw new DocumentException("This AcroFields instance is read-only.");
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.TX.equals(pdfName)) {
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.MAXLEN));
            n = 0;
            if (pdfObject != null) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            if (n > 0) {
                string2 = string2.substring(0, Math.min(n, string2.length()));
            }
        }
        if (PdfName.TX.equals(pdfName) || PdfName.CH.equals(pdfName)) {
            pdfObject = new PdfString(string2, "UnicodeBig");
            for (n = 0; n < item.values.size(); ++n) {
                ((PdfDictionary)item.values.get(n)).put(PdfName.V, pdfObject);
                PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(n);
                pdfDictionary.put(PdfName.V, pdfObject);
                PdfDictionary pdfDictionary2 = (PdfDictionary)item.widgets.get(n);
                if (this.generateAppearances) {
                    PdfObject pdfObject2;
                    PdfAppearance pdfAppearance = this.getAppearance(pdfDictionary, string3);
                    if (PdfName.CH.equals(pdfName)) {
                        pdfObject2 = new PdfNumber(this.topFirst);
                        pdfDictionary2.put(PdfName.TI, pdfObject2);
                        pdfDictionary.put(PdfName.TI, pdfObject2);
                    }
                    if ((pdfObject2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.AP))) == null) {
                        pdfObject2 = new PdfDictionary();
                        pdfDictionary2.put(PdfName.AP, pdfObject2);
                        pdfDictionary.put(PdfName.AP, pdfObject2);
                    }
                    ((PdfDictionary)pdfObject2).put(PdfName.N, pdfAppearance.getIndirectReference());
                    continue;
                }
                pdfDictionary2.remove(PdfName.AP);
                pdfDictionary.remove(PdfName.AP);
            }
            return true;
        }
        if (PdfName.BTN.equals(pdfName)) {
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            n = 0;
            if (pdfObject != null) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            if ((n & 0x10000) != 0) {
                return true;
            }
            PdfName pdfName2 = new PdfName(string2);
            if ((n & 0x8000) == 0) {
                for (int i = 0; i < item.values.size(); ++i) {
                    ((PdfDictionary)item.values.get(i)).put(PdfName.V, pdfName2);
                    PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(i);
                    pdfDictionary.put(PdfName.V, pdfName2);
                    pdfDictionary.put(PdfName.AS, pdfName2);
                    PdfDictionary pdfDictionary3 = (PdfDictionary)item.widgets.get(i);
                    pdfDictionary3.put(PdfName.AS, pdfName2);
                }
            } else {
                PdfObject pdfObject3;
                ArrayList<String> arrayList = new ArrayList<String>();
                PdfObject pdfObject4 = PdfReader.getPdfObject(((PdfDictionary)item.values.get(0)).get(PdfName.OPT));
                if (pdfObject4 != null && pdfObject4.isArray()) {
                    ArrayList arrayList2 = ((PdfArray)pdfObject4).getArrayList();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        pdfObject3 = PdfReader.getPdfObject((PdfObject)arrayList2.get(i));
                        if (pdfObject3 != null && pdfObject3.isString()) {
                            arrayList.add(((PdfString)pdfObject3).toUnicodeString());
                            continue;
                        }
                        arrayList.add(null);
                    }
                }
                int n2 = arrayList.indexOf(string2);
                PdfName pdfName3 = null;
                if (n2 >= 0) {
                    pdfName3 = new PdfName(String.valueOf(n2));
                    pdfObject3 = pdfName3;
                } else {
                    pdfObject3 = pdfName2;
                }
                for (int i = 0; i < item.values.size(); ++i) {
                    PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(i);
                    PdfDictionary pdfDictionary4 = (PdfDictionary)item.widgets.get(i);
                    if (pdfName3 != null) {
                        PdfString pdfString = new PdfString(string2, "UnicodeBig");
                        ((PdfDictionary)item.values.get(i)).put(PdfName.V, pdfString);
                        pdfDictionary.put(PdfName.V, pdfString);
                    } else {
                        ((PdfDictionary)item.values.get(i)).put(PdfName.V, pdfName2);
                        pdfDictionary.put(PdfName.V, pdfName2);
                    }
                    if (this.isInAP(pdfDictionary4, (PdfName)pdfObject3)) {
                        pdfDictionary.put(PdfName.AS, pdfObject3);
                        pdfDictionary4.put(PdfName.AS, pdfObject3);
                        continue;
                    }
                    pdfDictionary.put(PdfName.AS, PdfName.OFF);
                    pdfDictionary4.put(PdfName.AS, PdfName.OFF);
                }
            }
            return true;
        }
        return false;
    }

    boolean isInAP(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
        if (pdfDictionary2 == null) {
            return false;
        }
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.N));
        return pdfDictionary3 != null && pdfDictionary3.get(pdfName) != null;
    }

    public HashMap getFields() {
        return this.fields;
    }

    public Item getFieldItem(String string) {
        return (Item)this.fields.get(string);
    }

    public float[] getFieldPositions(String string) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        float[] fArray = new float[item.page.size() * 5];
        int n = 0;
        for (int i = 0; i < item.page.size(); ++i) {
            try {
                PdfDictionary pdfDictionary = (PdfDictionary)item.widgets.get(i);
                PdfArray pdfArray = (PdfArray)pdfDictionary.get(PdfName.RECT);
                if (pdfArray == null) continue;
                Rectangle rectangle = PdfReader.getNormalizedRectangle(pdfArray);
                fArray[n] = ((Integer)item.page.get(i)).floatValue();
                int n2 = ++n;
                fArray[n2] = rectangle.left();
                int n3 = ++n;
                fArray[n3] = rectangle.bottom();
                int n4 = ++n;
                fArray[n4] = rectangle.right();
                int n5 = ++n;
                ++n;
                fArray[n5] = rectangle.top();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n < fArray.length) {
            float[] fArray2 = new float[n];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            return fArray2;
        }
        return fArray;
    }

    private int removeRefFromArray(PdfArray pdfArray, PdfObject pdfObject) {
        ArrayList arrayList = pdfArray.getArrayList();
        if (pdfObject == null || !pdfObject.isIndirect()) {
            return arrayList.size();
        }
        PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)pdfObject;
        for (int i = 0; i < arrayList.size(); ++i) {
            PdfObject pdfObject2 = (PdfObject)arrayList.get(i);
            if (!pdfObject2.isIndirect() || ((PdfIndirectReference)pdfObject2).getNumber() != pdfIndirectReference.getNumber()) continue;
            arrayList.remove(i--);
        }
        return arrayList.size();
    }

    public boolean removeFieldsFromPage(int n) {
        if (n < 1) {
            return false;
        }
        String[] stringArray = new String[this.fields.size()];
        this.fields.keySet().toArray(stringArray);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2 = this.removeField(stringArray[i], n);
            bl = bl || bl2;
        }
        return bl;
    }

    public boolean removeField(String string, int n) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (pdfDictionary == null) {
            return false;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FIELDS));
        if (pdfArray == null) {
            return false;
        }
        for (int i = 0; i < item.widget_refs.size(); ++i) {
            PdfArray pdfArray2;
            int n2 = (Integer)item.page.get(i);
            if (n != -1 && n != n2) continue;
            PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)item.widget_refs.get(i);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference);
            PdfDictionary pdfDictionary3 = this.reader.getPageN(n2);
            PdfArray pdfArray3 = (PdfArray)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.ANNOTS));
            if (pdfArray3 != null && this.removeRefFromArray(pdfArray3, pdfIndirectReference) == 0) {
                pdfDictionary3.remove(PdfName.ANNOTS);
            }
            PdfReader.killIndirect(pdfIndirectReference);
            PdfIndirectReference pdfIndirectReference2 = pdfIndirectReference;
            while ((pdfIndirectReference = (PdfIndirectReference)pdfDictionary2.get(PdfName.PARENT)) != null && this.removeRefFromArray(pdfArray2 = (PdfArray)PdfReader.getPdfObject((pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference)).get(PdfName.KIDS)), pdfIndirectReference2) == 0) {
                pdfIndirectReference2 = pdfIndirectReference;
                PdfReader.killIndirect(pdfIndirectReference);
            }
            if (pdfIndirectReference == null) {
                this.removeRefFromArray(pdfArray, pdfIndirectReference2);
            }
            if (n == -1) continue;
            item.merged.remove(i);
            item.page.remove(i);
            item.values.remove(i);
            item.widget_refs.remove(i);
            item.widgets.remove(i);
            --i;
        }
        if (n == -1 || item.merged.size() == 0) {
            this.fields.remove(string);
        }
        return true;
    }

    public boolean removeField(String string) {
        return this.removeField(string, -1);
    }

    public boolean isGenerateAppearances() {
        return this.generateAppearances;
    }

    public void setGenerateAppearances(boolean bl) {
        this.generateAppearances = bl;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (bl) {
            pdfDictionary.remove(PdfName.NEEDAPPEARANCES);
        } else {
            pdfDictionary.put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
        }
    }

    public ArrayList getSignatureNames() {
        if (this.sigNames != null) {
            return this.sigNames;
        }
        this.sigNames = new ArrayList();
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            PdfDictionary pdfDictionary;
            PdfObject pdfObject;
            PdfObject pdfObject2;
            Map.Entry entry = iterator.next();
            Item item = (Item)entry.getValue();
            PdfDictionary pdfDictionary2 = (PdfDictionary)item.merged.get(0);
            if (!PdfName.SIG.equals(pdfDictionary2.get(PdfName.FT)) || (pdfObject2 = PdfReader.getPdfObject(pdfDictionary2.get(PdfName.V))) == null || pdfObject2.type() != 6 || (pdfObject = (pdfDictionary = (PdfDictionary)pdfObject2).get(PdfName.CONTENTS)) == null || pdfObject.type() != 3) continue;
            this.sigNames.add(entry.getKey());
        }
        return this.sigNames;
    }

    public PdfDictionary getSignatureDictionary(String string) {
        this.getSignatureNames();
        if (this.sigNames.indexOf(string) < 0) {
            return null;
        }
        Item item = (Item)this.fields.get(string);
        PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.V));
        return (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.V));
    }

    public boolean signatureCoversWholeDocument(String string) {
        PdfDictionary pdfDictionary = this.getSignatureDictionary(string);
        if (pdfDictionary == null) {
            return false;
        }
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            int n = randomAccessFileOrArray.length();
            randomAccessFileOrArray.close();
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BYTERANGE));
            ArrayList arrayList = pdfArray.getArrayList();
            int n2 = arrayList.size() - 2;
            int n3 = ((PdfNumber)arrayList.get(n2)).intValue();
            int n4 = ((PdfNumber)arrayList.get(n2 + 1)).intValue();
            boolean bl = n3 + n4 == n;
            return bl;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    public PdfPKCS7 verifySignature(String string) {
        return this.verifySignature(string, null);
    }

    public PdfPKCS7 verifySignature(String string, String string2) {
        PdfDictionary pdfDictionary = this.getSignatureDictionary(string);
        if (pdfDictionary == null) {
            return null;
        }
        try {
            PdfString pdfString;
            PdfName pdfName = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.SUBFILTER));
            PdfString pdfString2 = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
            PdfPKCS7 pdfPKCS7 = null;
            if (pdfName.equals(PdfName.ADBE_X509_RSA_SHA1)) {
                pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CERT));
                pdfPKCS7 = new PdfPKCS7(pdfString2.getOriginalBytes(), pdfString.getBytes(), string2);
            } else {
                pdfPKCS7 = new PdfPKCS7(pdfString2.getOriginalBytes(), string2);
            }
            this.updateByteRange(pdfPKCS7, pdfDictionary);
            pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.M));
            if (pdfString != null) {
                pdfPKCS7.setSignDate(PdfDate.decode(pdfString.toString()));
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAME))) != null) {
                pdfPKCS7.setSignName(pdfString.toUnicodeString());
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.REASON))) != null) {
                pdfPKCS7.setReason(pdfString.toUnicodeString());
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.LOCATION))) != null) {
                pdfPKCS7.setLocation(pdfString.toUnicodeString());
            }
            return pdfPKCS7;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private void updateByteRange(PdfPKCS7 pdfPKCS7, PdfDictionary pdfDictionary) {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BYTERANGE));
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byte[] byArray = new byte[8192];
            ArrayList arrayList = pdfArray.getArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                int n;
                int n2 = ((PdfNumber)arrayList.get(i)).intValue();
                randomAccessFileOrArray.seek(n2);
                for (int j = ((PdfNumber)arrayList.get(++i)).intValue(); j > 0 && (n = randomAccessFileOrArray.read(byArray, 0, Math.min(j, byArray.length))) > 0; j -= n) {
                    pdfPKCS7.update(byArray, 0, n);
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    private static class InstHit {
        IntHashtable hits;

        public InstHit(int[] nArray) {
            if (nArray == null) {
                return;
            }
            this.hits = new IntHashtable();
            for (int i = 0; i < nArray.length; ++i) {
                this.hits.put(nArray[i], 1);
            }
        }

        public boolean isHit(int n) {
            if (this.hits == null) {
                return true;
            }
            return this.hits.containsKey(n);
        }
    }

    public static class Item {
        public ArrayList values = new ArrayList();
        public ArrayList widgets = new ArrayList();
        public ArrayList widget_refs = new ArrayList();
        public ArrayList merged = new ArrayList();
        public ArrayList page = new ArrayList();
        public ArrayList tabOrder = new ArrayList();
    }
}

