/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import java.util.ArrayList;

public class MultiColumnText
implements Element {
    public static final float AUTOMATIC = -1.0f;
    private float desiredHeight;
    private float totalHeight;
    private boolean overflow;
    private float top;
    private float pageBottom;
    private ColumnText columnText;
    private ArrayList columnDefs = new ArrayList();
    private boolean simple = true;

    public MultiColumnText() {
        this(-1.0f);
    }

    public MultiColumnText(float f) {
        this.desiredHeight = f;
        this.top = -1.0f;
        this.columnText = new ColumnText(null);
        this.totalHeight = 0.0f;
        this.overflow = false;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public void useColumnParams(ColumnText columnText) {
        this.columnText.setSimpleVars(columnText);
    }

    public void addColumn(float[] fArray, float[] fArray2) {
        ColumnDef columnDef = new ColumnDef(fArray, fArray2);
        this.simple = columnDef.isSimple();
        this.columnDefs.add(columnDef);
    }

    public void addSimpleColumn(float f, float f2) {
        ColumnDef columnDef = new ColumnDef(f, f2);
        this.columnDefs.add(columnDef);
    }

    public void addRegularColumns(float f, float f2, float f3, int n) {
        float f4 = f;
        float f5 = f2 - f;
        float f6 = (f5 - f3 * (float)(n - 1)) / (float)n;
        for (int i = 0; i < n; ++i) {
            this.addSimpleColumn(f4, f4 + f6);
            f4 += f6 + f3;
        }
    }

    public void addElement(Element element) throws DocumentException {
        if (this.simple) {
            this.columnText.addElement(element);
        } else if (element instanceof Phrase) {
            this.columnText.addText((Phrase)element);
        } else if (element instanceof Chunk) {
            this.columnText.addText((Chunk)element);
        } else {
            throw new DocumentException("Can't add " + element.getClass() + " to MultiColumnText with complex columns");
        }
    }

    public float write(PdfContentByte pdfContentByte, PdfDocument pdfDocument, float f) throws DocumentException {
        this.columnText.canvas = pdfContentByte;
        if (this.top == -1.0f) {
            this.top = f;
        }
        if (this.columnDefs.size() == 0) {
            throw new DocumentException("MultiColumnText has no columns");
        }
        this.columnText.setYLine(this.top);
        this.pageBottom = pdfDocument.bottom();
        float f2 = 0.0f;
        int n = 0;
        boolean bl = false;
        try {
            while (!bl) {
                ColumnDef columnDef = (ColumnDef)this.columnDefs.get(n);
                this.columnText.setYLine(this.top);
                float[] fArray = columnDef.resolvePositions(4);
                float[] fArray2 = columnDef.resolvePositions(8);
                f2 = Math.max(f2, this.getHeight(fArray, fArray2));
                if (columnDef.isSimple()) {
                    this.columnText.setSimpleColumn(fArray[2], fArray[3], fArray2[0], fArray2[1]);
                } else {
                    this.columnText.setColumns(fArray, fArray2);
                }
                int n2 = this.columnText.go();
                if ((n2 & 1) != 0) {
                    bl = true;
                    continue;
                }
                if (n + 1 < this.columnDefs.size()) {
                    ++n;
                    continue;
                }
                this.totalHeight += f2;
                if (this.desiredHeight != -1.0f && this.totalHeight >= this.desiredHeight) {
                    bl = true;
                    this.overflow = true;
                    continue;
                }
                pdfDocument.newPage();
                n = 0;
                this.top = pdfDocument.top();
                f2 = 0.0f;
            }
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
            throw documentException;
        }
        return f2;
    }

    private float getHeight(float[] fArray, float[] fArray2) {
        int n;
        float f = Float.MIN_VALUE;
        float f2 = Float.MAX_VALUE;
        for (n = 0; n < fArray.length; n += 2) {
            f2 = Math.min(f2, fArray[n + 1]);
            f = Math.max(f, fArray[n + 1]);
        }
        for (n = 0; n < fArray2.length; n += 2) {
            f2 = Math.min(f2, fArray2[n + 1]);
            f = Math.max(f, fArray2[n + 1]);
        }
        return f - f2;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 40;
    }

    public ArrayList getChunks() {
        return null;
    }

    private float getColumnBottom() {
        if (this.desiredHeight == -1.0f) {
            return this.pageBottom;
        }
        return Math.max(this.top - (this.desiredHeight - this.totalHeight), this.pageBottom);
    }

    private class ColumnDef {
        private float[] left;
        private float[] right;

        ColumnDef(float[] fArray, float[] fArray2) {
            this.left = fArray;
            this.right = fArray2;
        }

        ColumnDef(float f, float f2) {
            this.left = new float[4];
            this.left[0] = f;
            this.left[1] = MultiColumnText.this.top;
            this.left[2] = f;
            this.left[3] = MultiColumnText.this.desiredHeight == -1.0f || MultiColumnText.this.top == -1.0f ? -1.0f : MultiColumnText.this.top - MultiColumnText.this.desiredHeight;
            this.right = new float[4];
            this.right[0] = f2;
            this.right[1] = MultiColumnText.this.top;
            this.right[2] = f2;
            this.right[3] = MultiColumnText.this.desiredHeight == -1.0f || MultiColumnText.this.top == -1.0f ? -1.0f : MultiColumnText.this.top - MultiColumnText.this.desiredHeight;
        }

        float[] resolvePositions(int n) {
            if (n == 4) {
                return this.resolvePositions(this.left);
            }
            return this.resolvePositions(this.right);
        }

        private float[] resolvePositions(float[] fArray) {
            if (!this.isSimple()) {
                return fArray;
            }
            if (MultiColumnText.this.top == -1.0f) {
                throw new RuntimeException("resolvePositions called with top=AUTOMATIC (-1).  Top position must be set befure lines can be resolved");
            }
            fArray[1] = MultiColumnText.this.top;
            fArray[3] = MultiColumnText.this.getColumnBottom();
            return fArray;
        }

        private boolean isSimple() {
            return this.left.length == 4 && this.right.length == 4 && this.left[0] == this.left[2] && this.right[0] == this.right[2];
        }
    }
}

