/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSigGenericPKCS;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class PdfSignatureAppearance {
    public static final PdfName SELF_SIGNED = PdfName.ADOBE_PPKLITE;
    public static final PdfName VERISIGN_SIGNED = PdfName.VERISIGN_PPKVS;
    public static final PdfName WINCER_SIGNED = PdfName.ADOBE_PPKMS;
    private static final float topSection = 0.3f;
    private static final float margin = 2.0f;
    private Rectangle rect;
    private Rectangle pageRect;
    private PdfTemplate[] app = new PdfTemplate[5];
    private PdfTemplate frm;
    private PdfStamperImp writer;
    private String layer2Text;
    private String reason;
    private String location;
    private Calendar signDate;
    private String provider;
    private int page = 1;
    private String fieldName;
    private PrivateKey privKey;
    private Certificate[] certChain;
    private CRL[] crlList;
    private PdfName filter;
    private boolean newField;
    private ByteBuffer sigout;
    private OutputStream originalout;
    private File tempFile;
    private PdfDictionary cryptoDictionary;
    private PdfStamper stamper;
    private boolean preClosed = false;
    private PdfSigGenericPKCS sigStandard;
    private int[] range;
    private RandomAccessFile raf;
    private int rangePosition = 0;
    private byte[] bout;
    private int boutLen;
    private byte[] externalDigest;
    private byte[] externalRSAdata;
    private String digestEncryptionAlgorithm;
    private HashMap exclusionLocations;
    public static final String questionMark = "% DSUnknown\nq\n1 G\n1 g\n0.1 0 0 0.1 9 0 cm\n0 J 0 j 4 M []0 d\n1 i \n0 g\n313 292 m\n313 404 325 453 432 529 c\n478 561 504 597 504 645 c\n504 736 440 760 391 760 c\n286 760 271 681 265 626 c\n265 625 l\n100 625 l\n100 828 253 898 381 898 c\n451 898 679 878 679 650 c\n679 555 628 499 538 435 c\n488 399 467 376 467 292 c\n313 292 l\nh\n308 214 170 -164 re\nf\n0.44 G\n1.2 w\n1 1 0.4 rg\n287 318 m\n287 430 299 479 406 555 c\n451 587 478 623 478 671 c\n478 762 414 786 365 786 c\n260 786 245 707 239 652 c\n239 651 l\n74 651 l\n74 854 227 924 355 924 c\n425 924 653 904 653 676 c\n653 581 602 525 512 461 c\n462 425 441 402 441 318 c\n287 318 l\nh\n282 240 170 -164 re\nB\nQ\n";

    PdfSignatureAppearance(PdfStamperImp pdfStamperImp) {
        this.writer = pdfStamperImp;
        this.signDate = new GregorianCalendar();
        this.fieldName = this.getNewSigName();
    }

    public void setLayer2Text(String string) {
        this.layer2Text = string;
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public boolean isInvisible() {
        return this.rect == null || this.rect.width() == 0.0f || this.rect.height() == 0.0f;
    }

    public void setCrypto(PrivateKey privateKey, Certificate[] certificateArray, CRL[] cRLArray, PdfName pdfName) {
        this.privKey = privateKey;
        this.certChain = certificateArray;
        this.crlList = cRLArray;
        this.filter = pdfName;
    }

    public void setVisibleSignature(Rectangle rectangle, int n, String string) {
        if (string != null) {
            AcroFields acroFields = this.writer.getAcroFields();
            AcroFields.Item item = acroFields.getFieldItem(string);
            if (item != null) {
                throw new IllegalArgumentException("The field " + string + " already exists.");
            }
            this.fieldName = string;
        }
        if (n < 1 || n > this.writer.reader.getNumberOfPages()) {
            throw new IllegalArgumentException("Invalid page number: " + n);
        }
        this.pageRect = new Rectangle(rectangle);
        this.pageRect.normalize();
        this.rect = new Rectangle(this.pageRect.width(), this.pageRect.height());
        this.page = n;
        this.newField = true;
    }

    public void setVisibleSignature(String string) {
        AcroFields acroFields = this.writer.getAcroFields();
        AcroFields.Item item = acroFields.getFieldItem(string);
        if (item == null) {
            throw new IllegalArgumentException("The field " + string + " does not exist.");
        }
        PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
        if (!PdfName.SIG.equals(PdfReader.getPdfObject(pdfDictionary.get(PdfName.FT)))) {
            throw new IllegalArgumentException("The field " + string + " is not a signature field.");
        }
        this.fieldName = string;
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT));
        ArrayList arrayList = pdfArray.getArrayList();
        float f = ((PdfNumber)PdfReader.getPdfObject((PdfObject)arrayList.get(0))).floatValue();
        float f2 = ((PdfNumber)PdfReader.getPdfObject((PdfObject)arrayList.get(1))).floatValue();
        float f3 = ((PdfNumber)PdfReader.getPdfObject((PdfObject)arrayList.get(2))).floatValue();
        float f4 = ((PdfNumber)PdfReader.getPdfObject((PdfObject)arrayList.get(3))).floatValue();
        this.pageRect = new Rectangle(f, f2, f3, f4);
        this.pageRect.normalize();
        this.page = (Integer)item.page.get(0);
        int n = this.writer.reader.getPageRotation(this.page);
        Rectangle rectangle = this.writer.reader.getPageSizeWithRotation(this.page);
        switch (n) {
            case 90: {
                this.pageRect = new Rectangle(this.pageRect.bottom(), rectangle.top() - this.pageRect.left(), this.pageRect.top(), rectangle.top() - this.pageRect.right());
                break;
            }
            case 180: {
                this.pageRect = new Rectangle(rectangle.right() - this.pageRect.left(), rectangle.top() - this.pageRect.bottom(), rectangle.right() - this.pageRect.right(), rectangle.top() - this.pageRect.top());
                break;
            }
            case 270: {
                this.pageRect = new Rectangle(rectangle.right() - this.pageRect.bottom(), this.pageRect.left(), rectangle.right() - this.pageRect.top(), this.pageRect.right());
            }
        }
        if (n != 0) {
            this.pageRect.normalize();
        }
        this.rect = new Rectangle(this.pageRect.width(), this.pageRect.height());
    }

    public PdfTemplate getLayer(int n) {
        if (n < 0 || n >= this.app.length) {
            return null;
        }
        PdfTemplate pdfTemplate = this.app[n];
        if (pdfTemplate == null) {
            pdfTemplate = this.app[n] = new PdfTemplate(this.writer);
            pdfTemplate.setBoundingBox(this.rect);
            this.writer.addDirectTemplateSimple(pdfTemplate, new PdfName("n" + n));
        }
        return pdfTemplate;
    }

    public PdfTemplate getTopLayer() {
        if (this.frm == null) {
            this.frm = new PdfTemplate(this.writer);
            this.frm.setBoundingBox(this.rect);
            this.writer.addDirectTemplateSimple(this.frm, new PdfName("FRM"));
        }
        return this.frm;
    }

    public PdfTemplate getAppearance() throws DocumentException, IOException {
        float f;
        Object object;
        Object object2;
        Object object3;
        if (this.app[0] == null) {
            this.app[0] = new PdfTemplate(this.writer);
            object3 = this.app[0];
            ((PdfTemplate)object3).setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.writer.addDirectTemplateSimple((PdfTemplate)object3, new PdfName("n0"));
            ((PdfContentByte)object3).setLiteral("% DSBlank\n");
        }
        if (this.app[1] == null) {
            this.app[1] = new PdfTemplate(this.writer);
            object3 = this.app[1];
            ((PdfTemplate)object3).setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.writer.addDirectTemplateSimple((PdfTemplate)object3, new PdfName("n1"));
            ((PdfContentByte)object3).setLiteral(questionMark);
        }
        if (this.app[2] == null) {
            if (this.layer2Text == null) {
                object3 = new StringBuffer();
                ((StringBuffer)object3).append("Digitally signed by ").append(PdfPKCS7.getSubjectFields((X509Certificate)this.certChain[0]).getField("CN")).append("\n");
                object2 = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1, Locale.US);
                ((StringBuffer)object3).append("Date: ").append(((DateFormat)object2).format(this.signDate.getTime()));
                if (this.reason != null) {
                    ((StringBuffer)object3).append("\n").append("Reason: ").append(this.reason);
                }
                if (this.location != null) {
                    ((StringBuffer)object3).append("\n").append("Location: ").append(this.location);
                }
                this.layer2Text = ((StringBuffer)object3).toString();
            }
            this.app[2] = new PdfTemplate(this.writer);
            object3 = this.app[2];
            ((PdfTemplate)object3).setBoundingBox(this.rect);
            this.writer.addDirectTemplateSimple((PdfTemplate)object3, new PdfName("n2"));
            object2 = BaseFont.createFont("Helvetica", "Cp1252", false);
            object = new Rectangle(this.rect.width() - 4.0f, this.rect.height() * 0.7f - 4.0f);
            f = PdfSignatureAppearance.fitText((BaseFont)object2, this.layer2Text, (Rectangle)object, 12.0f);
            ColumnText columnText = new ColumnText((PdfContentByte)object3);
            columnText.setSimpleColumn(new Phrase(this.layer2Text, new Font((BaseFont)object2, f)), 2.0f, 0.0f, this.rect.width() - 2.0f, this.rect.height() * 0.7f - 2.0f, f, 0);
            columnText.go();
        }
        if (this.app[3] == null) {
            this.app[3] = new PdfTemplate(this.writer);
            object3 = this.app[3];
            ((PdfTemplate)object3).setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.writer.addDirectTemplateSimple((PdfTemplate)object3, new PdfName("n3"));
            ((PdfContentByte)object3).setLiteral("% DSBlank\n");
        }
        if (this.app[4] == null) {
            this.app[4] = new PdfTemplate(this.writer);
            object3 = this.app[4];
            ((PdfTemplate)object3).setBoundingBox(new Rectangle(0.0f, this.rect.height() * 0.7f, this.rect.right(), this.rect.top()));
            this.writer.addDirectTemplateSimple((PdfTemplate)object3, new PdfName("n4"));
            object2 = BaseFont.createFont("Helvetica", "Cp1252", false);
            object = "Signature Not Verified";
            Rectangle rectangle = new Rectangle(this.rect.width() - 4.0f, this.rect.height() * 0.3f - 4.0f);
            float f2 = PdfSignatureAppearance.fitText((BaseFont)object2, (String)object, rectangle, 15.0f);
            ColumnText columnText = new ColumnText((PdfContentByte)object3);
            columnText.setSimpleColumn(new Phrase((String)object, new Font((BaseFont)object2, f2)), 2.0f, 0.0f, this.rect.width() - 2.0f, this.rect.height() - 2.0f, f2, 0);
            columnText.go();
        }
        int n = this.writer.reader.getPageRotation(this.page);
        object2 = new Rectangle(this.rect);
        for (int i = n; i > 0; i -= 90) {
            object2 = ((Rectangle)object2).rotate();
        }
        if (this.frm == null) {
            this.frm = new PdfTemplate(this.writer);
            this.frm.setBoundingBox((Rectangle)object2);
            this.writer.addDirectTemplateSimple(this.frm, new PdfName("FRM"));
            f = Math.min(this.rect.width(), this.rect.height()) * 0.9f;
            float f3 = (this.rect.width() - f) / 2.0f;
            float f4 = (this.rect.height() - f) / 2.0f;
            f /= 100.0f;
            if (n == 90) {
                this.frm.concatCTM(0.0f, 1.0f, -1.0f, 0.0f, this.rect.height(), 0.0f);
            } else if (n == 180) {
                this.frm.concatCTM(-1.0f, 0.0f, 0.0f, -1.0f, this.rect.width(), this.rect.height());
            } else if (n == 270) {
                this.frm.concatCTM(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.rect.width());
            }
            this.frm.addTemplate(this.app[0], 0.0f, 0.0f);
            this.frm.addTemplate(this.app[1], f, 0.0f, 0.0f, f, f3, f4);
            this.frm.addTemplate(this.app[2], 0.0f, 0.0f);
            this.frm.addTemplate(this.app[3], f, 0.0f, 0.0f, f, f3, f4);
            this.frm.addTemplate(this.app[4], 0.0f, 0.0f);
        }
        PdfTemplate pdfTemplate = new PdfTemplate(this.writer);
        pdfTemplate.setBoundingBox((Rectangle)object2);
        this.writer.addDirectTemplateSimple(pdfTemplate, null);
        pdfTemplate.addTemplate(this.frm, 0.0f, 0.0f);
        return pdfTemplate;
    }

    public static float fitText(BaseFont baseFont, String string, Rectangle rectangle, float f) {
        try {
            ColumnText columnText = null;
            int n = 0;
            if (f <= 0.0f) {
                int n2;
                int n3 = 0;
                int n4 = 0;
                char[] cArray = string.toCharArray();
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    if (cArray[n2] == '\n') {
                        ++n4;
                        continue;
                    }
                    if (cArray[n2] != '\r') continue;
                    ++n3;
                }
                n2 = Math.max(n3, n4) + 1;
                f = Math.abs(rectangle.height()) / (float)n2 - 0.001f;
            }
            Phrase phrase = new Phrase(string, new Font(baseFont, f));
            columnText = new ColumnText(null);
            columnText.setSimpleColumn(phrase, rectangle.left(), rectangle.bottom(), rectangle.right(), rectangle.top(), f, 0);
            n = columnText.go(true);
            if ((n & 1) != 0) {
                return f;
            }
            float f2 = 0.1f;
            float f3 = 0.0f;
            float f4 = f;
            while (true) {
                float f5 = (f3 + f4) / 2.0f;
                columnText = new ColumnText(null);
                columnText.setSimpleColumn(new Phrase(string, new Font(baseFont, f5)), rectangle.left(), rectangle.bottom(), rectangle.right(), rectangle.top(), f5, 0);
                n = columnText.go(true);
                if ((n & 1) != 0) {
                    if (f4 - f3 < f5 * f2) {
                        return f5;
                    }
                    f3 = f5;
                    continue;
                }
                f4 = f5;
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void setExternalDigest(byte[] byArray, byte[] byArray2, String string) {
        this.externalDigest = byArray;
        this.externalRSAdata = byArray2;
        this.digestEncryptionAlgorithm = string;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public PrivateKey getPrivKey() {
        return this.privKey;
    }

    public Certificate[] getCertChain() {
        return this.certChain;
    }

    public CRL[] getCrlList() {
        return this.crlList;
    }

    public PdfName getFilter() {
        return this.filter;
    }

    public boolean isNewField() {
        return this.newField;
    }

    public int getPage() {
        return this.page;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Rectangle getPageRect() {
        return this.pageRect;
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Calendar calendar) {
        this.signDate = calendar;
    }

    ByteBuffer getSigout() {
        return this.sigout;
    }

    void setSigout(ByteBuffer byteBuffer) {
        this.sigout = byteBuffer;
    }

    OutputStream getOriginalout() {
        return this.originalout;
    }

    void setOriginalout(OutputStream outputStream) {
        this.originalout = outputStream;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    void setTempFile(File file) {
        this.tempFile = file;
    }

    public String getNewSigName() {
        AcroFields acroFields = this.writer.getAcroFields();
        String string = "Signature";
        int n = 0;
        boolean bl = false;
        block0: while (!bl) {
            String string2 = string + ++n;
            if (acroFields.getFieldItem(string2) != null) continue;
            string2 = string2 + ".";
            bl = true;
            Iterator iterator = acroFields.getFields().keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!string3.startsWith(string2)) continue;
                bl = false;
                continue block0;
            }
        }
        string = string + n;
        return string;
    }

    public void preClose() throws IOException, DocumentException {
        this.preClose(null);
    }

    public void preClose(HashMap hashMap) throws IOException, DocumentException {
        int n;
        Object object;
        Object object2;
        Object object3;
        PdfObject pdfObject;
        boolean bl;
        if (this.preClosed) {
            throw new DocumentException("Document already pre closed.");
        }
        this.preClosed = true;
        AcroFields acroFields = this.writer.getAcroFields();
        String string = this.getFieldName();
        boolean bl2 = bl = !this.isInvisible() && !this.isNewField();
        if (bl) {
            acroFields.removeField(string);
        }
        this.writer.setSigFlags(3);
        PdfFormField pdfFormField = PdfFormField.createSignature(this.writer);
        pdfFormField.setFieldName(string);
        PdfIndirectReference pdfIndirectReference = this.writer.getPdfIndirectReference();
        pdfFormField.put(PdfName.V, pdfIndirectReference);
        pdfFormField.setFlags(132);
        int n2 = this.getPage();
        PdfReader pdfReader = this.writer.reader;
        if (!this.isInvisible()) {
            pdfFormField.setWidget(this.getPageRect(), null);
            pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, this.getAppearance());
        } else {
            pdfFormField.setWidget(new Rectangle(0.0f, 0.0f), null);
        }
        pdfFormField.setPage(n2);
        this.writer.addAnnotation(pdfFormField, n2);
        this.exclusionLocations = new HashMap();
        if (this.cryptoDictionary == null) {
            if (PdfName.ADOBE_PPKLITE.equals(this.getFilter())) {
                this.sigStandard = new PdfSigGenericPKCS.PPKLite(this.getProvider());
            } else if (PdfName.ADOBE_PPKMS.equals(this.getFilter())) {
                this.sigStandard = new PdfSigGenericPKCS.PPKMS(this.getProvider());
            } else if (PdfName.VERISIGN_PPKVS.equals(this.getFilter())) {
                this.sigStandard = new PdfSigGenericPKCS.VeriSign(this.getProvider());
            } else {
                throw new IllegalArgumentException("Unknown filter: " + this.getFilter());
            }
            this.sigStandard.setExternalDigest(this.externalDigest, this.externalRSAdata, this.digestEncryptionAlgorithm);
            if (this.getReason() != null) {
                this.sigStandard.setReason(this.getReason());
            }
            if (this.getLocation() != null) {
                this.sigStandard.setLocation(this.getLocation());
            }
            this.sigStandard.put(PdfName.M, new PdfDate(this.getSignDate()));
            this.sigStandard.setSignInfo(this.getPrivKey(), this.getCertChain(), this.getCrlList());
            pdfObject = (PdfString)this.sigStandard.get(PdfName.CONTENTS);
            object3 = new PdfLiteral(((PdfString)pdfObject).toString().length() * 2 + 2);
            this.exclusionLocations.put(PdfName.CONTENTS, object3);
            this.sigStandard.put(PdfName.CONTENTS, (PdfObject)object3);
            object3 = new PdfLiteral(80);
            this.exclusionLocations.put(PdfName.BYTERANGE, object3);
            this.sigStandard.put(PdfName.BYTERANGE, (PdfObject)object3);
            this.writer.addToBody((PdfObject)this.sigStandard, pdfIndirectReference, false);
        } else {
            pdfObject = new PdfLiteral(80);
            this.exclusionLocations.put(PdfName.BYTERANGE, pdfObject);
            this.cryptoDictionary.put(PdfName.BYTERANGE, pdfObject);
            object3 = hashMap.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = (PdfName)object2.getKey();
                Integer n3 = (Integer)object2.getValue();
                pdfObject = new PdfLiteral(n3);
                this.exclusionLocations.put(object, pdfObject);
                this.cryptoDictionary.put((PdfName)object, pdfObject);
            }
            this.writer.addToBody((PdfObject)this.cryptoDictionary, pdfIndirectReference, false);
        }
        this.writer.close(this.stamper.getMoreInfo());
        this.range = new int[this.exclusionLocations.size() * 2];
        int n4 = ((PdfLiteral)this.exclusionLocations.get(PdfName.BYTERANGE)).getPosition();
        this.exclusionLocations.remove(PdfName.BYTERANGE);
        int n5 = 1;
        object2 = this.exclusionLocations.values().iterator();
        while (object2.hasNext()) {
            object = (PdfLiteral)object2.next();
            int n6 = ((PdfLiteral)object).getPosition();
            this.range[n5++] = n6;
            this.range[n5++] = ((PdfLiteral)object).getPosLength() + n6;
        }
        Arrays.sort(this.range, 1, this.range.length - 1);
        for (n = 3; n < this.range.length - 2; n += 2) {
            int n7 = n;
            this.range[n7] = this.range[n7] - this.range[n - 1];
        }
        if (this.tempFile == null) {
            this.bout = this.sigout.getBuffer();
            this.boutLen = this.sigout.size();
            this.range[this.range.length - 1] = this.boutLen - this.range[this.range.length - 2];
            ByteBuffer byteBuffer = new ByteBuffer();
            byteBuffer.append('[');
            for (int i = 0; i < this.range.length; ++i) {
                byteBuffer.append(this.range[i]).append(' ');
            }
            byteBuffer.append(']');
            System.arraycopy(byteBuffer.getBuffer(), 0, this.bout, n4, byteBuffer.size());
        } else {
            try {
                this.raf = new RandomAccessFile(this.tempFile, "rw");
                n = (int)this.raf.length();
                this.range[this.range.length - 1] = n - this.range[this.range.length - 2];
                object = new ByteBuffer();
                ((ByteBuffer)object).append('[');
                for (int i = 0; i < this.range.length; ++i) {
                    ((ByteBuffer)object).append(this.range[i]).append(' ');
                }
                ((ByteBuffer)object).append(']');
                this.raf.seek(n4);
                this.raf.write(((ByteBuffer)object).getBuffer(), 0, ((ByteBuffer)object).size());
            }
            catch (IOException iOException) {
                try {
                    this.raf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.tempFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(PdfDictionary pdfDictionary) throws IOException, DocumentException {
        Exception exception3;
        block27: {
            try {
                Object object;
                if (!this.preClosed) {
                    throw new DocumentException("preClose() must be called first.");
                }
                ByteBuffer byteBuffer = new ByteBuffer();
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    object = (PdfName)iterator.next();
                    PdfObject pdfObject = pdfDictionary.get((PdfName)object);
                    PdfLiteral pdfLiteral = (PdfLiteral)this.exclusionLocations.get(object);
                    if (pdfLiteral == null) {
                        throw new IllegalArgumentException("The key " + ((PdfObject)object).toString() + " didn't reserve space in preClose().");
                    }
                    byteBuffer.reset();
                    pdfObject.toPdf(null, byteBuffer);
                    if (byteBuffer.size() > pdfLiteral.getPosLength()) {
                        throw new IllegalArgumentException("The key " + ((PdfObject)object).toString() + " is too big.");
                    }
                    if (this.tempFile == null) {
                        System.arraycopy(byteBuffer.getBuffer(), 0, this.bout, pdfLiteral.getPosition(), byteBuffer.size());
                        continue;
                    }
                    this.raf.seek(pdfLiteral.getPosition());
                    this.raf.write(byteBuffer.getBuffer(), 0, byteBuffer.size());
                }
                if (pdfDictionary.size() != this.exclusionLocations.size()) {
                    throw new IllegalArgumentException("The update dictionary has less keys than required.");
                }
                if (this.tempFile == null) {
                    this.originalout.write(this.bout, 0, this.boutLen);
                } else if (this.originalout != null) {
                    int n;
                    this.raf.seek(0L);
                    object = new byte[8192];
                    for (int i = (int)this.raf.length(); i > 0; i -= n) {
                        n = this.raf.read((byte[])object, 0, Math.min(((Object)object).length, i));
                        if (n < 0) {
                            throw new EOFException("Unexpected EOF");
                        }
                        this.originalout.write((byte[])object, 0, n);
                    }
                }
                Object var8_9 = null;
                if (this.tempFile == null) break block27;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var8_10 = null;
                if (this.tempFile != null) {
                    try {
                        this.raf.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                    if (this.originalout != null) {
                        try {
                            this.tempFile.delete();
                        }
                        catch (Exception exception22) {
                            // empty catch block
                        }
                    }
                }
                if (this.originalout != null) {
                    try {
                        this.originalout.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                this.raf.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            if (this.originalout != null) {
                try {
                    this.tempFile.delete();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        }
        if (this.originalout != null) {
            try {
                this.originalout.close();
            }
            catch (Exception exception3) {}
        }
    }

    private static int indexArray(byte[] byArray, int n, String string) {
        byte[] byArray2 = PdfEncodings.convertToBytes(string, null);
        while (true) {
            int n2;
            for (n2 = 0; n2 < byArray2.length && byArray2[n2] == byArray[n + n2]; ++n2) {
            }
            if (n2 == byArray2.length) {
                return n;
            }
            ++n;
        }
    }

    private static int indexFile(RandomAccessFile randomAccessFile, int n, String string) throws IOException {
        byte[] byArray = PdfEncodings.convertToBytes(string, null);
        while (true) {
            int n2;
            randomAccessFile.seek(n);
            for (n2 = 0; n2 < byArray.length; ++n2) {
                int n3 = randomAccessFile.read();
                if (n3 < 0) {
                    throw new EOFException("Unexpected EOF");
                }
                if (byArray[n2] != (byte)n3) break;
            }
            if (n2 == byArray.length) {
                return n;
            }
            ++n;
        }
    }

    public InputStream getRangeStream() {
        return new RangeStream(this.raf, this.bout, this.range);
    }

    public PdfDictionary getCryptoDictionary() {
        return this.cryptoDictionary;
    }

    public void setCryptoDictionary(PdfDictionary pdfDictionary) {
        this.cryptoDictionary = pdfDictionary;
    }

    public PdfStamper getStamper() {
        return this.stamper;
    }

    void setStamper(PdfStamper pdfStamper) {
        this.stamper = pdfStamper;
    }

    public boolean isPreClosed() {
        return this.preClosed;
    }

    public PdfSigGenericPKCS getSigStandard() {
        return this.sigStandard;
    }

    public class RangeStream
    extends InputStream {
        private byte[] b = new byte[1];
        private RandomAccessFile raf;
        private byte[] bout;
        private int[] range;
        private int rangePosition = 0;

        private RangeStream(RandomAccessFile randomAccessFile, byte[] byArray, int[] nArray) {
            this.raf = randomAccessFile;
            this.bout = byArray;
            this.range = nArray;
        }

        public int read() throws IOException {
            int n = this.read(this.b);
            if (n != 1) {
                return -1;
            }
            return this.b[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.rangePosition >= this.range[this.range.length - 2] + this.range[this.range.length - 1]) {
                return -1;
            }
            for (int i = 0; i < this.range.length; i += 2) {
                int n3 = this.range[i];
                int n4 = n3 + this.range[i + 1];
                if (this.rangePosition < n3) {
                    this.rangePosition = n3;
                }
                if (this.rangePosition < n3 || this.rangePosition >= n4) continue;
                int n5 = Math.min(n2, n4 - this.rangePosition);
                if (this.raf == null) {
                    System.arraycopy(this.bout, this.rangePosition, byArray, n, n5);
                } else {
                    this.raf.seek(this.rangePosition);
                    this.raf.readFully(byArray, n, n5);
                }
                this.rangePosition += n5;
                return n5;
            }
            return -1;
        }
    }
}

