/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.text.pdf.StampContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class PdfStamperImp
extends PdfWriter {
    RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref = new IntHashtable();
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;
    protected int[] namePtr = new int[]{0};
    protected boolean namedAsNames;
    protected List newBookmarks;
    protected HashSet partialFlattening = new HashSet();
    protected boolean useVp = false;
    protected int vp = 0;
    protected HashMap fieldTemplates = new HashMap();
    protected boolean fieldsAdded = false;
    protected int sigFlags = 0;

    PdfStamperImp(PdfReader pdfReader, OutputStream outputStream, char c) throws DocumentException, IOException {
        super(new PdfDocument(), outputStream);
        if (pdfReader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        pdfReader.setTampered(true);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
        if (c == '\u0000') {
            super.setPdfVersion(pdfReader.getPdfVersion());
        } else {
            super.setPdfVersion(c);
        }
        super.open();
        this.pdf.addWriter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(HashMap hashMap) throws DocumentException, IOException {
        PdfObject pdfObject;
        Object object;
        Object object2;
        Object object3;
        PdfObject pdfObject2;
        if (this.closed) {
            return;
        }
        if (this.useVp) {
            this.reader.setViewerPreferences(this.vp);
        }
        if (this.flat) {
            this.flatFields();
        }
        this.addFieldResources();
        if (this.sigFlags != 0 && (pdfObject2 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM))) != null) {
            ((PdfDictionary)pdfObject2).put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
        }
        this.closed = true;
        this.addSharedObjectsToBody();
        this.setOutlines();
        this.setJavaScript();
        pdfObject2 = null;
        try {
            this.file.reOpen();
            this.alterContents();
            object3 = this.reader.xrefObj;
            boolean bl = true;
            pdfObject2 = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
            int n = -1;
            if (pdfObject2 != null) {
                n = ((PdfIndirectReference)pdfObject2).getNumber();
            }
            int n2 = ((PRIndirectReference)this.reader.trailer.get(PdfName.ROOT)).getNumber();
            for (int i = 1; i < ((PdfObject[])object3).length; ++i) {
                if (object3[i] == null || n == i) continue;
                this.body.add(object3[i], this.getNewObjectNumber(this.reader, i, 0), i != n2);
            }
        }
        finally {
            try {
                this.file.close();
            }
            catch (Exception exception) {}
        }
        object3 = null;
        PdfObject pdfObject3 = null;
        if (this.crypto != null) {
            PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)this.crypto.getEncryptionDictionary(), false);
            object3 = pdfIndirectObject.getIndirectReference();
            pdfObject3 = this.crypto.getFileID();
        }
        PRIndirectReference pRIndirectReference = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference pdfIndirectReference = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, pRIndirectReference.getNumber(), 0));
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        if (pdfDictionary != null) {
            object2 = pdfDictionary.getKeys().iterator();
            while (object2.hasNext()) {
                object = (PdfName)object2.next();
                pdfObject = PdfReader.getPdfObject(pdfDictionary.get((PdfName)object));
                pdfDictionary2.put((PdfName)object, pdfObject);
            }
        }
        if (hashMap != null) {
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                pdfObject = new PdfName((String)object);
                String string = (String)hashMap.get(object);
                if (string == null) {
                    pdfDictionary2.remove((PdfName)pdfObject);
                    continue;
                }
                pdfDictionary2.put((PdfName)pdfObject, new PdfString(string, "UnicodeBig"));
            }
        }
        if (!pdfDictionary2.getKeys().isEmpty()) {
            pdfIndirectReference2 = this.body.add((PdfObject)pdfDictionary2, false).getIndirectReference();
        }
        this.body.writeCrossReferenceTable(this.os, pdfIndirectReference, pdfIndirectReference2, (PdfIndirectReference)object3, pdfObject3);
        if (this.fullCompression) {
            this.os.write(PdfStamperImp.getISOBytes("startxref\n"));
            this.os.write(PdfStamperImp.getISOBytes(String.valueOf(this.body.offset())));
            this.os.write(PdfStamperImp.getISOBytes("\n%%EOF\n"));
        } else {
            object2 = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectReference, pdfIndirectReference2, (PdfIndirectReference)object3, pdfObject3);
            ((PdfWriter.PdfTrailer)object2).toPdf(this, this.os);
        }
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
    }

    void applyRotation(int n, ByteBuffer byteBuffer) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle rectangle = this.reader.getPageSizeWithRotation(n);
        int n2 = rectangle.getRotation();
        switch (n2) {
            case 90: {
                byteBuffer.append(PdfContents.ROTATE90);
                byteBuffer.append(rectangle.top());
                byteBuffer.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                byteBuffer.append(PdfContents.ROTATE180);
                byteBuffer.append(rectangle.right());
                byteBuffer.append(' ');
                byteBuffer.append(rectangle.top());
                byteBuffer.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                byteBuffer.append(PdfContents.ROTATE270);
                byteBuffer.append('0').append(' ');
                byteBuffer.append(rectangle.right());
                byteBuffer.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        Iterator iterator = this.pagesToContent.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            PageStamp pageStamp = (PageStamp)this.pagesToContent.get(n);
            PdfDictionary pdfDictionary = this.reader.getPageN(n);
            PdfArray pdfArray = null;
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
            if (pdfObject == null) {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else if (pdfObject.isArray()) {
                pdfArray = (PdfArray)pdfObject;
            } else if (pdfObject.isStream()) {
                pdfArray = new PdfArray();
                pdfArray.add(pdfDictionary.get(PdfName.CONTENTS));
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            }
            ByteBuffer byteBuffer = new ByteBuffer();
            if (pageStamp.under != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(n, byteBuffer);
                byteBuffer.append(pageStamp.under.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            if (pageStamp.over != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
            }
            PdfStream pdfStream = new PdfStream(byteBuffer.toByteArray());
            try {
                pdfStream.flateCompress();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            pdfArray.addFirst(this.addToBody(pdfStream).getIndirectReference());
            byteBuffer.reset();
            if (pageStamp.over != null) {
                byteBuffer.append(' ');
                byteBuffer.append(PdfContents.RESTORESTATE);
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(n, byteBuffer);
                byteBuffer.append(pageStamp.over.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
                pdfStream = new PdfStream(byteBuffer.toByteArray());
                try {
                    pdfStream.flateCompress();
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                pdfArray.add(this.addToBody(pdfStream).getIndirectReference());
            }
            this.alterResources(pageStamp);
        }
    }

    void alterResources(PageStamp pageStamp) {
        PdfDictionary pdfDictionary = this.reader.getPageN(pageStamp.pageNumber);
        pdfDictionary.put(PdfName.RESOURCES, pageStamp.pageResources.getResources());
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        if (this.currentPdfReaderInstance == null) {
            int n3 = this.myXref.get(n);
            if (n3 == 0) {
                n3 = this.getIndirectReferenceNumber();
                this.myXref.put(n, n3);
            }
            return n3;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    PageStamp getPageStamp(int n) {
        Integer n2 = new Integer(n);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(n2);
        if (pageStamp == null) {
            pageStamp = new PageStamp(this, this.reader, n);
            this.pagesToContent.put(n2, pageStamp);
        }
        return pageStamp;
    }

    PdfContentByte getUnderContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.under == null) {
            pageStamp.under = new StampContent(this, n);
        }
        return pageStamp.under;
    }

    PdfContentByte getOverContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.over == null) {
            pageStamp.over = new StampContent(this, n);
        }
        return pageStamp.over;
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean bl) {
        this.rotateContents = bl;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean bl) {
        this.flat = bl;
    }

    boolean partialFormFlattening(String string) {
        this.getAcroFields();
        if (!this.acroFields.getFields().containsKey(string)) {
            return false;
        }
        this.partialFlattening.add(string);
        return true;
    }

    void flatFields() {
        PdfObject pdfObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.getAcroFields();
        HashMap hashMap = this.acroFields.getFields();
        if (this.fieldsAdded && this.partialFlattening.isEmpty()) {
            object4 = hashMap.keySet().iterator();
            while (object4.hasNext()) {
                this.partialFlattening.add(object4.next());
            }
        }
        object4 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        ArrayList arrayList = null;
        if (object4 != null && (object3 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.FIELDS))) != null) {
            arrayList = ((PdfArray)object3).getArrayList();
        }
        object3 = hashMap.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(object2)) continue;
            object = (AcroFields.Item)hashMap.get(object2);
            for (int i = 0; i < ((AcroFields.Item)object).merged.size(); ++i) {
                Object object5;
                Object object6;
                Object object7;
                PdfObject pdfObject2;
                PdfDictionary pdfDictionary = (PdfDictionary)((AcroFields.Item)object).merged.get(i);
                pdfObject = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
                int n = 0;
                if (pdfObject != null) {
                    n = ((PdfNumber)pdfObject).intValue();
                }
                int n2 = (Integer)((AcroFields.Item)object).page.get(i);
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
                if (pdfDictionary2 != null && (n & 4) != 0 && (n & 2) == 0) {
                    Object object8;
                    pdfObject2 = pdfDictionary2.get(PdfName.N);
                    object7 = null;
                    object6 = PdfReader.getPdfObject(pdfObject2);
                    if (pdfObject2 instanceof PdfIndirectReference && !pdfObject2.isIndirect()) {
                        object7 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                    } else if (object6 instanceof PdfStream) {
                        ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                        object7 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                    } else if (((PdfObject)object6).isDictionary() && (object8 = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AS))) != null && (object5 = (PdfIndirectReference)((PdfDictionary)object6).get((PdfName)object8)) != null) {
                        object7 = new PdfAppearance((PdfIndirectReference)object5);
                        if (((PdfObject)object5).isIndirect()) {
                            object6 = PdfReader.getPdfObject((PdfObject)object5);
                            ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                        }
                    }
                    if (object7 != null) {
                        object8 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT)));
                        object5 = this.getOverContent(n2);
                        ((PdfContentByte)object5).setLiteral("Q ");
                        ((PdfContentByte)object5).addTemplate((PdfTemplate)object7, ((Rectangle)object8).left(), ((Rectangle)object8).bottom());
                        ((PdfContentByte)object5).setLiteral("q ");
                    }
                }
                if (this.partialFlattening.isEmpty() || (object7 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)(pdfObject2 = this.reader.getPageN(n2))).get(PdfName.ANNOTS))) == null) continue;
                object6 = ((PdfArray)object7).getArrayList();
                block3: for (int j = 0; j < ((ArrayList)object6).size(); ++j) {
                    PdfObject pdfObject3;
                    object5 = (PdfObject)((ArrayList)object6).get(j);
                    if (!((PdfObject)object5).isIndirect() || !(pdfObject3 = (PdfObject)((AcroFields.Item)object).widget_refs.get(i)).isIndirect() || ((PRIndirectReference)object5).getNumber() != ((PRIndirectReference)pdfObject3).getNumber()) continue;
                    ((ArrayList)object6).remove(j--);
                    PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject3;
                    while (true) {
                        PdfObject pdfObject4;
                        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
                        PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary3.get(PdfName.PARENT);
                        PdfReader.killIndirect(pRIndirectReference);
                        if (pRIndirectReference2 == null) {
                            for (int k = 0; k < arrayList.size(); ++k) {
                                pdfObject4 = (PdfObject)arrayList.get(k);
                                if (!pdfObject4.isIndirect() || ((PRIndirectReference)pdfObject4).getNumber() != pRIndirectReference.getNumber()) continue;
                                arrayList.remove(k);
                                --k;
                            }
                            continue block3;
                        }
                        PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference2);
                        pdfObject4 = (PdfArray)PdfReader.getPdfObject(pdfDictionary4.get(PdfName.KIDS));
                        ArrayList arrayList2 = ((PdfArray)pdfObject4).getArrayList();
                        for (int k = 0; k < arrayList2.size(); ++k) {
                            PdfObject pdfObject5 = (PdfObject)arrayList2.get(k);
                            if (!pdfObject5.isIndirect() || ((PRIndirectReference)pdfObject5).getNumber() != pRIndirectReference.getNumber()) continue;
                            arrayList2.remove(k);
                            --k;
                        }
                        if (!arrayList2.isEmpty()) continue block3;
                        pRIndirectReference = pRIndirectReference2;
                    }
                }
                if (((ArrayList)object6).size() != 0) continue;
                PdfReader.killIndirect(((PdfDictionary)pdfObject2).get(PdfName.ANNOTS));
                ((PdfDictionary)pdfObject2).remove(PdfName.ANNOTS);
            }
        }
        if (!this.fieldsAdded && this.partialFlattening.isEmpty()) {
            for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
                object2 = this.reader.getPageN(i);
                object = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.ANNOTS));
                if (object == null) continue;
                ArrayList arrayList3 = ((PdfArray)object).getArrayList();
                for (int j = 0; j < arrayList3.size(); ++j) {
                    PdfDictionary pdfDictionary;
                    pdfObject = PdfReader.getPdfObject((PdfObject)arrayList3.get(j));
                    if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || !PdfName.WIDGET.equals((pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                    arrayList3.remove(j);
                    --j;
                }
                if (arrayList3.size() != 0) continue;
                PdfReader.killIndirect(((PdfDictionary)object2).get(PdfName.ANNOTS));
                ((PdfDictionary)object2).remove(PdfName.ANNOTS);
            }
            this.eliminateAcroformObjects();
        }
    }

    void eliminateAcroformObjects() {
        PdfObject pdfObject = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (pdfObject == null) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
        PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIELDS);
        if (pdfObject2 != null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.KIDS, pdfObject2);
            this.sweepKids(pdfDictionary2);
        }
    }

    void sweepKids(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.killIndirect(pdfObject);
        if (!pdfObject2.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
        PdfArray pdfArray = (PdfArray)PdfReader.killIndirect(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            return;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.sweepKids((PdfObject)arrayList.get(i));
        }
    }

    public PdfIndirectReference getPageReference(int n) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n);
        }
        return pRIndirectReference;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM));
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.ACROFORM, pdfDictionary2);
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FIELDS))) == null) {
            pdfArray = new PdfArray();
            pdfDictionary2.put(PdfName.FIELDS, pdfArray);
        }
        pdfArray.add(pdfIndirectReference);
    }

    void addFieldResources() {
        PdfDictionary pdfDictionary;
        if (this.fieldTemplates.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary2 = this.reader.getCatalog();
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ACROFORM));
        if (pdfDictionary3 == null) {
            pdfDictionary3 = new PdfDictionary();
            pdfDictionary2.put(PdfName.ACROFORM, pdfDictionary3);
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.DR))) == null) {
            pdfDictionary = new PdfDictionary();
            pdfDictionary3.put(PdfName.DR, pdfDictionary);
        }
        Object object = this.fieldTemplates.keySet().iterator();
        while (object.hasNext()) {
            PdfTemplate pdfTemplate = (PdfTemplate)object.next();
            PdfFormField.mergeResources(pdfDictionary, (PdfDictionary)pdfTemplate.getResources());
        }
        object = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONT));
        if (object != null && pdfDictionary3.get(PdfName.DA) == null) {
            pdfDictionary3.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        }
    }

    void expandFields(PdfFormField pdfFormField, ArrayList arrayList) {
        arrayList.add(pdfFormField);
        ArrayList arrayList2 = pdfFormField.getKids();
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.expandFields((PdfFormField)arrayList2.get(i), arrayList);
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        try {
            ArrayList<PdfAnnotation> arrayList = new ArrayList<PdfAnnotation>();
            if (pdfAnnotation.isForm()) {
                this.fieldsAdded = true;
                this.getAcroFields();
                PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
                if (pdfFormField.getParent() != null) {
                    return;
                }
                this.expandFields(pdfFormField, arrayList);
            } else {
                arrayList.add(pdfAnnotation);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                pdfAnnotation = (PdfAnnotation)arrayList.get(i);
                int n2 = n;
                if (pdfAnnotation.getPlaceInPage() > 0) {
                    n2 = pdfAnnotation.getPlaceInPage();
                }
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.fieldTemplates.putAll(object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    PdfRectangle pdfRectangle;
                    object = this.reader.getPageN(n2);
                    PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.ANNOTS));
                    if (pdfArray == null) {
                        pdfArray = new PdfArray();
                        ((PdfDictionary)object).put(PdfName.ANNOTS, pdfArray);
                    }
                    pdfArray.add(pdfAnnotation.getIndirectReference());
                    if (!(pdfAnnotation.isUsed() || (pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT)).left() == 0.0f && pdfRectangle.right() == 0.0f && pdfRectangle.top() == 0.0f && pdfRectangle.bottom() == 0.0f)) {
                        int n3 = this.reader.getPageRotation(n2);
                        Rectangle rectangle = this.reader.getPageSizeWithRotation(n2);
                        switch (n3) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.top() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.top() - pdfRectangle.top(), pdfRectangle.right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.right() - pdfRectangle.left(), rectangle.top() - pdfRectangle.bottom(), rectangle.right() - pdfRectangle.right(), rectangle.top() - pdfRectangle.top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.right() - pdfRectangle.left(), pdfRectangle.top(), rectangle.right() - pdfRectangle.right()));
                            }
                        }
                    }
                }
                if (pdfAnnotation.isUsed()) continue;
                pdfAnnotation.setUsed();
                this.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    private void outlineTravel(PRIndirectReference pRIndirectReference) {
        while (pRIndirectReference != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary.get(PdfName.FIRST);
            if (pRIndirectReference2 != null) {
                this.outlineTravel(pRIndirectReference2);
            }
            PdfReader.killIndirect(pdfDictionary.get(PdfName.DEST));
            PdfReader.killIndirect(pdfDictionary.get(PdfName.A));
            PdfReader.killIndirect(pRIndirectReference);
            pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.NEXT);
        }
    }

    void deleteOutlines() {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.OUTLINES);
        if (pRIndirectReference == null) {
            return;
        }
        this.outlineTravel(pRIndirectReference);
        PdfReader.killIndirect(pRIndirectReference);
        pdfDictionary.remove(PdfName.OUTLINES);
    }

    void setJavaScript() throws IOException {
        ArrayList arrayList = this.pdf.getDocumentJavaScript();
        if (arrayList.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES));
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
        }
        String string = String.valueOf(arrayList.size() - 1);
        int n = string.length();
        String string2 = "000000000000000";
        HashMap hashMap = new HashMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            string = String.valueOf(i);
            string = string2.substring(0, n - string.length()) + string;
            hashMap.put(string, arrayList.get(i));
        }
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap, this);
        pdfDictionary2.put(PdfName.JAVASCRIPT, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.size() == 0) {
            return;
        }
        this.namedAsNames = this.reader.getCatalog().get(PdfName.DESTS) != null;
        PdfDictionary pdfDictionary = new PdfDictionary();
        PdfIndirectReference pdfIndirectReference = this.getPdfIndirectReference();
        Object[] objectArray = SimpleBookmark.iterateOutlines(this, pdfIndirectReference, this.newBookmarks, this.namedAsNames);
        pdfDictionary.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
        pdfDictionary.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
        pdfDictionary.put(PdfName.COUNT, new PdfNumber((Integer)objectArray[2]));
        this.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
        this.reader.getCatalog().put(PdfName.OUTLINES, pdfIndirectReference);
    }

    void setOutlines(List list) {
        this.newBookmarks = list;
    }

    public void setViewerPreferences(int n) {
        this.useVp = true;
        this.vp |= n;
    }

    public void setSigFlags(int n) {
        this.sigFlags |= n;
    }

    static class PageStamp {
        int pageNumber;
        StampContent under;
        StampContent over;
        PageResources pageResources;

        PageStamp(PdfStamperImp pdfStamperImp, PdfReader pdfReader, int n) {
            this.pageNumber = n;
            this.pageResources = new PageResources();
            PdfDictionary pdfDictionary = pdfReader.getPageN(n);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RESOURCES));
            this.pageResources.setOriginalResources(pdfDictionary2, pdfStamperImp.namePtr);
        }
    }
}

