/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfRow;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class RtfCell
extends Cell
implements RtfExtendedElement {
    private static final int MERGE_NONE = 0;
    private static final int MERGE_VERT_PARENT = 1;
    private static final int MERGE_VERT_CHILD = 2;
    private RtfRow parentRow = null;
    private ArrayList content = null;
    private int cellRight = 0;
    private int cellWidth = 0;
    private RtfBorderGroup borders = null;
    private int verticalAlignment = 5;
    private RtfColor backgroundColor = null;
    private int cellPadding = 0;
    private int mergeType = 0;
    private int colspan = 1;
    private int rowspan = 1;
    private RtfDocument document = null;
    private boolean inHeader = false;

    public RtfCell() {
        this.borders = new RtfBorderGroup();
    }

    public RtfCell(String string) {
        super(string);
        this.borders = new RtfBorderGroup();
    }

    public RtfCell(Element element) throws BadElementException {
        super(element);
        this.borders = new RtfBorderGroup();
    }

    public RtfCell(Properties properties) {
        super(properties);
        this.borders = new RtfBorderGroup();
    }

    protected RtfCell(RtfDocument rtfDocument, RtfRow rtfRow, Cell cell) {
        this.document = rtfDocument;
        this.parentRow = rtfRow;
        this.importCell(cell);
    }

    private void importCell(Cell cell) {
        this.content = new ArrayList();
        if (cell == null) {
            this.borders = new RtfBorderGroup(this.document, 2, this.parentRow.getParentTable().getBorders());
            return;
        }
        this.colspan = cell.colspan();
        this.rowspan = cell.rowspan();
        if (cell.rowspan() > 1) {
            this.mergeType = 1;
        }
        this.borders = cell instanceof RtfCell ? new RtfBorderGroup(this.document, 2, ((RtfCell)cell).getBorders()) : new RtfBorderGroup(this.document, 2, cell.border(), cell.borderWidth(), cell.borderColor());
        this.verticalAlignment = cell.verticalAlignment();
        if (cell.backgroundColor() == null && cell.grayFill() == 0.0f) {
            this.backgroundColor = new RtfColor(this.document, 255, 255, 255);
        } else if (cell.backgroundColor() != null) {
            this.backgroundColor = new RtfColor(this.document, cell.backgroundColor());
        } else {
            int n = (int)(cell.grayFill() * 255.0f);
            this.backgroundColor = new RtfColor(this.document, n, n, n);
        }
        this.cellPadding = (int)this.parentRow.getParentTable().getCellPadding();
        if (cell != null) {
            Object object;
            Iterator iterator = cell.getElements();
            Paragraph paragraph = null;
            while (iterator.hasNext()) {
                try {
                    RtfBasicElement rtfBasicElement;
                    object = (Element)iterator.next();
                    if (!(object instanceof Paragraph)) {
                        if (paragraph != null) {
                            paragraph.add(object);
                            continue;
                        }
                        paragraph = new Paragraph();
                        paragraph.setAlignment(cell.horizontalAlignment());
                        paragraph.add(object);
                        continue;
                    }
                    if (paragraph != null) {
                        rtfBasicElement = this.document.getMapper().mapElement(paragraph);
                        rtfBasicElement.setInTable(true);
                        this.content.add(rtfBasicElement);
                        paragraph = null;
                        paragraph = null;
                    }
                    if (object instanceof Paragraph && ((Paragraph)object).alignment() == -1) {
                        ((Paragraph)object).setAlignment(cell.horizontalAlignment());
                    }
                    rtfBasicElement = this.document.getMapper().mapElement((Element)object);
                    rtfBasicElement.setInTable(true);
                    this.content.add(rtfBasicElement);
                }
                catch (DocumentException documentException) {
                    documentException.printStackTrace();
                }
            }
            if (paragraph != null) {
                try {
                    object = this.document.getMapper().mapElement(paragraph);
                    object.setInTable(true);
                    this.content.add(object);
                }
                catch (DocumentException documentException) {
                    documentException.printStackTrace();
                }
            }
        }
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.mergeType == 1) {
                byteArrayOutputStream.write("\\clvmgf".getBytes());
            } else if (this.mergeType == 2) {
                byteArrayOutputStream.write("\\clvmrg".getBytes());
            }
            switch (this.verticalAlignment) {
                case 6: {
                    byteArrayOutputStream.write("\\clvertalb".getBytes());
                    break;
                }
                case 1: 
                case 5: {
                    byteArrayOutputStream.write("\\clvertalc".getBytes());
                    break;
                }
                case 4: {
                    byteArrayOutputStream.write("\\clvertalt".getBytes());
                }
            }
            byteArrayOutputStream.write(this.borders.write());
            byteArrayOutputStream.write("\\clcbpat".getBytes());
            byteArrayOutputStream.write(this.intToByteArray(this.backgroundColor.getColorNumber()));
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.write("\\clftsWidth3".getBytes());
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.write("\\clwWidth".getBytes());
            byteArrayOutputStream.write(this.intToByteArray(this.cellWidth));
            byteArrayOutputStream.write(10);
            if (this.cellPadding > 0) {
                byteArrayOutputStream.write("\\clpadl".getBytes());
                byteArrayOutputStream.write(this.intToByteArray(this.cellPadding / 2));
                byteArrayOutputStream.write("\\clpadt".getBytes());
                byteArrayOutputStream.write(this.intToByteArray(this.cellPadding / 2));
                byteArrayOutputStream.write("\\clpadr".getBytes());
                byteArrayOutputStream.write(this.intToByteArray(this.cellPadding / 2));
                byteArrayOutputStream.write("\\clpadb".getBytes());
                byteArrayOutputStream.write(this.intToByteArray(this.cellPadding / 2));
                byteArrayOutputStream.write("\\clpadfl3".getBytes());
                byteArrayOutputStream.write("\\clpadft3".getBytes());
                byteArrayOutputStream.write("\\clpadfr3".getBytes());
                byteArrayOutputStream.write("\\clpadfb3".getBytes());
            }
            byteArrayOutputStream.write("\\cellx".getBytes());
            byteArrayOutputStream.write(this.intToByteArray(this.cellRight));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.content.size() == 0) {
                byteArrayOutputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
                byteArrayOutputStream.write("\\intbl".getBytes());
            } else {
                for (int i = 0; i < this.content.size(); ++i) {
                    RtfBasicElement rtfBasicElement = (RtfBasicElement)this.content.get(i);
                    byteArrayOutputStream.write(rtfBasicElement.write());
                    if (!(rtfBasicElement instanceof RtfParagraph) || i >= this.content.size() - 1) continue;
                    byteArrayOutputStream.write(RtfParagraph.PARAGRAPH);
                }
            }
            byteArrayOutputStream.write("\\cell".getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void setCellRight(int n) {
        this.cellRight = n;
    }

    protected int getCellRight() {
        return this.cellRight;
    }

    protected void setCellWidth(int n) {
        this.cellWidth = n;
    }

    protected int getCellWidth() {
        return this.cellWidth;
    }

    protected int getColspan() {
        return this.colspan;
    }

    protected int getRowspan() {
        return this.rowspan;
    }

    protected int getCellpadding() {
        return this.cellPadding;
    }

    protected RtfBorderGroup getBorders() {
        return this.borders;
    }

    public void setBorders(RtfBorderGroup rtfBorderGroup) {
        this.borders = new RtfBorderGroup(this.document, 2, rtfBorderGroup);
    }

    protected int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    protected RtfColor getBackgroundColor() {
        return this.backgroundColor;
    }

    protected void setCellMergeChild(RtfCell rtfCell) {
        this.mergeType = 2;
        this.cellWidth = rtfCell.getCellWidth();
        this.cellRight = rtfCell.getCellRight();
        this.cellPadding = rtfCell.getCellpadding();
        this.borders = rtfCell.getBorders();
        this.verticalAlignment = rtfCell.getVerticalAlignment();
        this.backgroundColor = rtfCell.getBackgroundColor();
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
    }

    public void setInTable(boolean bl) {
    }

    public void setInHeader(boolean bl) {
        this.inHeader = bl;
        for (int i = 0; i < this.content.size(); ++i) {
            ((RtfBasicElement)this.content.get(i)).setInHeader(bl);
        }
    }

    private byte[] intToByteArray(int n) {
        return Integer.toString(n).getBytes();
    }
}

