/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfChunk
extends RtfElement {
    private RtfFont font = null;
    private String content = "";

    public RtfChunk(RtfDocument rtfDocument, Chunk chunk) {
        super(rtfDocument);
        if (chunk == null) {
            return;
        }
        float f = 0.0f;
        if (chunk.getAttributes() != null && chunk.getAttributes().get("SUBSUPSCRIPT") != null) {
            f = ((Float)chunk.getAttributes().get("SUBSUPSCRIPT")).floatValue();
        }
        this.font = new RtfFont(rtfDocument, chunk.font(), f);
        this.content = chunk.content();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.font.writeBegin());
            byteArrayOutputStream.write(RtfBasicElement.DELIMITER);
            byteArrayOutputStream.write(this.document.filterSpecialChar(this.content, false).getBytes());
            byteArrayOutputStream.write(this.font.writeEnd());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        super.setRtfDocument(rtfDocument);
        this.font.setRtfDocument(this.document);
    }
}

