/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;

public class MicroBurlapOutput {
    private OutputStream os;
    private Date date;
    private Calendar utcCalendar;
    private Calendar localCalendar;

    public void init(OutputStream outputStream) {
        this.os = outputStream;
    }

    public void call(String string, Object[] objectArray) throws IOException {
        this.startCall(string);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.writeObject(objectArray[n]);
                ++n;
            }
        }
        this.completeCall();
    }

    public void startCall(String string) throws IOException {
        this.print("<burlap:call><method>");
        this.print(string);
        this.print("</method>");
    }

    public void completeCall() throws IOException {
        this.print("</burlap:call>");
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.print("<boolean>");
        this.printInt(bl ? 1 : 0);
        this.print("</boolean>");
    }

    public void writeInt(int n) throws IOException {
        this.print("<int>");
        this.printInt(n);
        this.print("</int>");
    }

    public void writeLong(long l) throws IOException {
        this.print("<long>");
        this.printLong(l);
        this.print("</long>");
    }

    public void writeNull() throws IOException {
        this.print("<null></null>");
    }

    public void writeString(String string) throws IOException {
        if (string == null) {
            this.print("<null></null>");
        } else {
            this.print("<string>");
            this.printString(string);
            this.print("</string>");
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.print("<null></null>");
        } else {
            this.print("<base64>");
            this.printBytes(byArray, n, n2);
            this.print("</base64>");
        }
    }

    public void writeUTCDate(long l) throws IOException {
        this.print("<date>");
        if (this.utcCalendar == null) {
            this.utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            this.date = new Date();
        }
        this.date.setTime(l);
        this.utcCalendar.setTime(this.date);
        this.printDate(this.utcCalendar);
        this.print("</date>");
    }

    public void writeLocalDate(long l) throws IOException {
        this.print("<date>");
        if (this.localCalendar == null) {
            this.localCalendar = Calendar.getInstance();
            this.date = new Date();
        }
        this.date.setTime(l);
        this.localCalendar.setTime(this.date);
        this.printDate(this.localCalendar);
        this.print("</date>");
    }

    public void writeRef(int n) throws IOException {
        this.print("<ref>");
        this.printInt(n);
        this.print("</ref>");
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Date) {
            this.writeUTCDate(((Date)object).getTime());
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.writeBytes(byArray, 0, byArray.length);
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = vector.size();
            this.writeListBegin(n, null);
            int n2 = 0;
            while (n2 < n) {
                this.writeObject(vector.elementAt(n2));
                ++n2;
            }
            this.writeListEnd();
        } else if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            this.writeMapBegin(null);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable.get(k);
                this.writeObject(k);
                this.writeObject(v);
            }
            this.writeMapEnd();
        } else {
            this.writeCustomObject(object);
        }
    }

    public void writeCustomObject(Object object) throws IOException {
        throw new IOException("unexpected object: " + object);
    }

    public void writeListBegin(int n, String string) throws IOException {
        this.print("<list><type>");
        if (string != null) {
            this.print(string);
        }
        this.print("</type><length>");
        this.printInt(n);
        this.print("</length>");
    }

    public void writeListEnd() throws IOException {
        this.print("</list>");
    }

    public void writeMapBegin(String string) throws IOException {
        this.print("<map><type>");
        if (string != null) {
            this.print(string);
        }
        this.print("</type>");
    }

    public void writeMapEnd() throws IOException {
        this.print("</map>");
    }

    public void writeRemote(String string, String string2) throws IOException {
        this.print("<remote><type>");
        if (string != null) {
            this.print(string);
        }
        this.print("</type><string>");
        this.print(string2);
        this.print("</string></remote>");
    }

    public void printInt(int n) throws IOException {
        this.print(String.valueOf(n));
    }

    public void printLong(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public void printString(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    this.print("&lt;");
                    break;
                }
                case '&': {
                    this.print("&amp;");
                    break;
                }
                case '\r': {
                    this.print("&#13;");
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        this.os.write(c);
                        break;
                    }
                    if (c < '\u0800') {
                        this.os.write(192 + (c >> 6 & 0x1F));
                        this.os.write(128 + (c & 0x3F));
                        break;
                    }
                    this.os.write(224 + (c >> 12 & 0xF));
                    this.os.write(128 + (c >> 6 & 0x3F));
                    this.os.write(128 + (c & 0x3F));
                }
            }
            ++n2;
        }
    }

    public void printBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        while (n2 >= 3) {
            n3 = ((byArray[n] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
            this.os.write(MicroBurlapOutput.base64encode(n3 >> 18));
            this.os.write(MicroBurlapOutput.base64encode(n3 >> 12));
            this.os.write(MicroBurlapOutput.base64encode(n3 >> 6));
            this.os.write(MicroBurlapOutput.base64encode(n3));
            n += 3;
            n2 -= 3;
        }
        if (n2 == 2) {
            n3 = ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
            this.os.write(MicroBurlapOutput.base64encode(n3 >> 12));
            this.os.write(MicroBurlapOutput.base64encode(n3 >> 6));
            this.os.write(MicroBurlapOutput.base64encode(n3));
            this.os.write(61);
        } else if (n2 == 1) {
            n3 = byArray[n] & 0xFF;
            this.os.write(MicroBurlapOutput.base64encode(n3 >> 6));
            this.os.write(MicroBurlapOutput.base64encode(n3));
            this.os.write(61);
            this.os.write(61);
        }
    }

    public static char base64encode(int n) {
        if ((n &= 0x3F) < 26) {
            return (char)(n + 65);
        }
        if (n < 52) {
            return (char)(n + 97 - 26);
        }
        if (n < 62) {
            return (char)(n + 48 - 52);
        }
        if (n == 62) {
            return '+';
        }
        return '/';
    }

    public void printDate(Calendar calendar) throws IOException {
        int n = calendar.get(1);
        this.os.write((char)(48 + n / 1000 % 10));
        this.os.write((char)(48 + n / 100 % 10));
        this.os.write((char)(48 + n / 10 % 10));
        this.os.write((char)(48 + n % 10));
        int n2 = calendar.get(2) + 1;
        this.os.write((char)(48 + n2 / 10 % 10));
        this.os.write((char)(48 + n2 % 10));
        int n3 = calendar.get(5);
        this.os.write((char)(48 + n3 / 10 % 10));
        this.os.write((char)(48 + n3 % 10));
        this.os.write(84);
        int n4 = calendar.get(11);
        this.os.write((char)(48 + n4 / 10 % 10));
        this.os.write((char)(48 + n4 % 10));
        int n5 = calendar.get(12);
        this.os.write((char)(48 + n5 / 10 % 10));
        this.os.write((char)(48 + n5 % 10));
        int n6 = calendar.get(13);
        this.os.write((char)(48 + n6 / 10 % 10));
        this.os.write((char)(48 + n6 % 10));
        this.os.write(90);
    }

    public void print(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.os.write(c);
            ++n2;
        }
    }

    public MicroBurlapOutput(OutputStream outputStream) {
        this.init(outputStream);
    }

    public MicroBurlapOutput() {
    }
}

