/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.micro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class MicroHessianInput {
    protected InputStream is;

    public void init(InputStream inputStream) {
        this.is = inputStream;
    }

    public void startReply() throws IOException {
        int n = this.is.read();
        if (n != 114) {
            this.protocolException("expected hessian reply");
        }
        int n2 = this.is.read();
        int n3 = this.is.read();
    }

    public void completeReply() throws IOException {
        int n = this.is.read();
        if (n != 122) {
            this.protocolException("expected end of reply");
        }
    }

    public boolean readBoolean() throws IOException {
        int n = this.is.read();
        switch (n) {
            case 84: {
                return true;
            }
            case 70: {
                return false;
            }
        }
        throw this.expect("boolean", n);
    }

    public int readInt() throws IOException {
        int n = this.is.read();
        if (n != 73) {
            throw this.expect("integer", n);
        }
        int n2 = this.is.read();
        int n3 = this.is.read();
        int n4 = this.is.read();
        int n5 = this.is.read();
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    public long readLong() throws IOException {
        int n = this.is.read();
        if (n != 76) {
            throw this.protocolException("expected long");
        }
        long l = this.is.read();
        long l2 = this.is.read();
        long l3 = this.is.read();
        long l4 = this.is.read();
        long l5 = this.is.read();
        long l6 = this.is.read();
        long l7 = this.is.read();
        long l8 = this.is.read();
        return (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8;
    }

    public long readUTCDate() throws IOException {
        int n = this.is.read();
        if (n != 100) {
            throw this.protocolException("expected date");
        }
        long l = this.is.read();
        long l2 = this.is.read();
        long l3 = this.is.read();
        long l4 = this.is.read();
        long l5 = this.is.read();
        long l6 = this.is.read();
        long l7 = this.is.read();
        long l8 = this.is.read();
        return (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8;
    }

    public String readString() throws IOException {
        int n = this.is.read();
        if (n == 78) {
            return null;
        }
        if (n != 83) {
            throw this.expect("string", n);
        }
        int n2 = this.is.read();
        int n3 = this.is.read();
        int n4 = (n2 << 8) + n3;
        return this.readStringImpl(n4);
    }

    public byte[] readBytes() throws IOException {
        int n = this.is.read();
        if (n == 78) {
            return null;
        }
        if (n != 66) {
            throw this.expect("bytes", n);
        }
        int n2 = this.is.read();
        int n3 = this.is.read();
        int n4 = (n2 << 8) + n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n5 = 0;
        while (n5 < n4) {
            byteArrayOutputStream.write(this.is.read());
            ++n5;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Object readObject(Class clazz) throws IOException {
        int n = this.is.read();
        switch (n) {
            case 78: {
                return null;
            }
            case 84: {
                return new Boolean(true);
            }
            case 70: {
                return new Boolean(false);
            }
            case 73: {
                int n2 = this.is.read();
                int n3 = this.is.read();
                int n4 = this.is.read();
                int n5 = this.is.read();
                return new Integer((n2 << 24) + (n3 << 16) + (n4 << 8) + n5);
            }
            case 76: {
                long l = this.is.read();
                long l2 = this.is.read();
                long l3 = this.is.read();
                long l4 = this.is.read();
                long l5 = this.is.read();
                long l6 = this.is.read();
                long l7 = this.is.read();
                long l8 = this.is.read();
                return new Long((l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8);
            }
            case 100: {
                long l = this.is.read();
                long l9 = this.is.read();
                long l10 = this.is.read();
                long l11 = this.is.read();
                long l12 = this.is.read();
                long l13 = this.is.read();
                long l14 = this.is.read();
                long l15 = this.is.read();
                return new Date((l << 56) + (l9 << 48) + (l10 << 40) + (l11 << 32) + (l12 << 24) + (l13 << 16) + (l14 << 8) + l15);
            }
            case 83: 
            case 88: {
                int n6 = this.is.read();
                int n7 = this.is.read();
                int n8 = (n6 << 8) + n7;
                return this.readStringImpl(n8);
            }
            case 66: {
                if (n != 66) {
                    throw this.expect("bytes", n);
                }
                int n9 = this.is.read();
                int n10 = this.is.read();
                int n11 = (n9 << 8) + n10;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n12 = 0;
                while (n12 < n11) {
                    byteArrayOutputStream.write(this.is.read());
                    ++n12;
                }
                return byteArrayOutputStream.toByteArray();
            }
        }
        throw new IOException("unknown code:" + (char)n);
    }

    protected String readStringImpl(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            int n5 = this.is.read();
            if (n5 < 128) {
                stringBuffer.append((char)n5);
            } else if ((n5 & 0xE0) == 192) {
                n4 = this.is.read();
                n3 = ((n5 & 0x1F) << 6) + (n4 & 0x3F);
                stringBuffer.append((char)n3);
            } else if ((n5 & 0xF0) == 224) {
                n4 = this.is.read();
                n3 = this.is.read();
                int n6 = ((n5 & 0xF) << 12) + ((n4 & 0x3F) << 6) + (n3 & 0x3F);
                stringBuffer.append((char)n6);
            } else {
                throw new IOException("bad utf-8 encoding");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected IOException expect(String string, int n) {
        if (n < 0) {
            return this.protocolException("expected " + string + " at end of file");
        }
        return this.protocolException("expected " + string + " at " + (char)n);
    }

    protected IOException protocolException(String string) {
        return new IOException(string);
    }

    public MicroHessianInput(InputStream inputStream) {
        this.init(inputStream);
    }

    public MicroHessianInput() {
    }
}

