/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.CholeskyDecomposition;
import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import Jama.util.Maths;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public class Matrix
implements Cloneable,
Serializable {
    private double[][] A;
    private int m;
    private int n;

    public Matrix(int n, int n2) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
    }

    public Matrix(int n, int n2, double d) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.A[n3][n4] = d;
                ++n4;
            }
            ++n3;
        }
    }

    public Matrix(double[][] dArray) {
        this.m = dArray.length;
        this.n = dArray[0].length;
        int n = 0;
        while (n < this.m) {
            if (dArray[n].length != this.n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            ++n;
        }
        this.A = dArray;
    }

    public Matrix(double[][] dArray, int n, int n2) {
        this.A = dArray;
        this.m = n;
        this.n = n2;
    }

    public Matrix(double[] dArray, int n) {
        this.m = n;
        int n2 = this.n = n != 0 ? dArray.length / n : 0;
        if (n * this.n != dArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new double[n][this.n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < this.n) {
                this.A[n3][n4] = dArray[n3 + n4 * n];
                ++n4;
            }
            ++n3;
        }
    }

    public static Matrix constructWithCopy(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray2 = matrix.getArray();
        int n3 = 0;
        while (n3 < n) {
            if (dArray[n3].length != n2) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            int n4 = 0;
            while (n4 < n2) {
                dArray2[n3][n4] = dArray[n3][n4];
                ++n4;
            }
            ++n3;
        }
        return matrix;
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public double[] getColumnPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n + n2 * this.m] = this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public double[] getRowPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n * this.n + n2] = this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int n, int n2) {
        return this.A[n][n2];
    }

    public Matrix getMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = matrix.getArray();
        try {
            int n5 = n;
            while (n5 <= n2) {
                int n6 = n3;
                while (n6 <= n4) {
                    dArray[n5 - n][n6 - n3] = this.A[n5][n6];
                    ++n6;
                }
                ++n5;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int[] nArray2) {
        Matrix matrix = new Matrix(nArray.length, nArray2.length);
        double[][] dArray = matrix.getArray();
        try {
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray2.length) {
                    dArray[n][n2] = this.A[nArray[n]][nArray2[n2]];
                    ++n2;
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int n, int n2, int[] nArray) {
        Matrix matrix = new Matrix(n2 - n + 1, nArray.length);
        double[][] dArray = matrix.getArray();
        try {
            int n3 = n;
            while (n3 <= n2) {
                int n4 = 0;
                while (n4 < nArray.length) {
                    dArray[n3 - n][n4] = this.A[n3][nArray[n4]];
                    ++n4;
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int n, int n2) {
        Matrix matrix = new Matrix(nArray.length, n2 - n + 1);
        double[][] dArray = matrix.getArray();
        try {
            int n3 = 0;
            while (n3 < nArray.length) {
                int n4 = n;
                while (n4 <= n2) {
                    dArray[n3][n4 - n] = this.A[nArray[n3]][n4];
                    ++n4;
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public void set(int n, int n2, double d) {
        this.A[n][n2] = d;
    }

    public void setMatrix(int n, int n2, int n3, int n4, Matrix matrix) {
        try {
            int n5 = n;
            while (n5 <= n2) {
                int n6 = n3;
                while (n6 <= n4) {
                    this.A[n5][n6] = matrix.get(n5 - n, n6 - n3);
                    ++n6;
                }
                ++n5;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int[] nArray2, Matrix matrix) {
        try {
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray2.length) {
                    this.A[nArray[n]][nArray2[n2]] = matrix.get(n, n2);
                    ++n2;
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int n, int n2, Matrix matrix) {
        try {
            int n3 = 0;
            while (n3 < nArray.length) {
                int n4 = n;
                while (n4 <= n2) {
                    this.A[nArray[n3]][n4] = matrix.get(n3, n4 - n);
                    ++n4;
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int n, int n2, int[] nArray, Matrix matrix) {
        try {
            int n3 = n;
            while (n3 <= n2) {
                int n4 = 0;
                while (n4 < nArray.length) {
                    this.A[n3][nArray[n4]] = matrix.get(n3 - n, n4);
                    ++n4;
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.n, this.m);
        double[][] dArray = matrix.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n2][n] = this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public double norm1() {
        double d = 0.0;
        int n = 0;
        while (n < this.n) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.m) {
                d2 += Math.abs(this.A[n2][n]);
                ++n2;
            }
            d = Math.max(d, d2);
            ++n;
        }
        return d;
    }

    public double norm2() {
        return new SingularValueDecomposition(this).norm2();
    }

    public double normInf() {
        double d = 0.0;
        int n = 0;
        while (n < this.m) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.n) {
                d2 += Math.abs(this.A[n][n2]);
                ++n2;
            }
            d = Math.max(d, d2);
            ++n;
        }
        return d;
    }

    public double normF() {
        double d = 0.0;
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                d = Maths.hypot(d, this.A[n][n2]);
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public Matrix uminus() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = -this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public Matrix plus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = this.A[n][n2] + matrix.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix2;
    }

    public Matrix plusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                this.A[n][n2] = this.A[n][n2] + matrix.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public Matrix minus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = this.A[n][n2] - matrix.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix2;
    }

    public Matrix minusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                this.A[n][n2] = this.A[n][n2] - matrix.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public Matrix arrayTimes(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = this.A[n][n2] * matrix.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix2;
    }

    public Matrix arrayTimesEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                this.A[n][n2] = this.A[n][n2] * matrix.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public Matrix arrayRightDivide(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = this.A[n][n2] / matrix.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix2;
    }

    public Matrix arrayRightDivideEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                this.A[n][n2] = this.A[n][n2] / matrix.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public Matrix arrayLeftDivide(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = matrix.A[n][n2] / this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix2;
    }

    public Matrix arrayLeftDivideEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                this.A[n][n2] = matrix.A[n][n2] / this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public Matrix times(double d) {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = d * this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public Matrix timesEquals(double d) {
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                this.A[n][n2] = d * this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public Matrix times(Matrix matrix) {
        if (matrix.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix matrix2 = new Matrix(this.m, matrix.n);
        double[][] dArray = matrix2.getArray();
        double[] dArray2 = new double[this.n];
        int n = 0;
        while (n < matrix.n) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray2[n2] = matrix.A[n2][n];
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.m) {
                double[] dArray3 = this.A[n3];
                double d = 0.0;
                int n4 = 0;
                while (n4 < this.n) {
                    d += dArray3[n4] * dArray2[n4];
                    ++n4;
                }
                dArray[n3][n] = d;
                ++n3;
            }
            ++n;
        }
        return matrix2;
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public CholeskyDecomposition chol() {
        return new CholeskyDecomposition(this);
    }

    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    public Matrix solve(Matrix matrix) {
        return this.m == this.n ? new LUDecomposition(this).solve(matrix) : new QRDecomposition(this).solve(matrix);
    }

    public Matrix solveTranspose(Matrix matrix) {
        return this.transpose().solve(matrix.transpose());
    }

    public Matrix inverse() {
        return this.solve(Matrix.identity(this.m, this.m));
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    public int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    public double cond() {
        return new SingularValueDecomposition(this).cond();
    }

    public double trace() {
        double d = 0.0;
        int n = 0;
        while (n < Math.min(this.m, this.n)) {
            d += this.A[n][n];
            ++n;
        }
        return d;
    }

    public static Matrix random(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArray();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3][n4] = Math.random();
                ++n4;
            }
            ++n3;
        }
        return matrix;
    }

    public static Matrix identity(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArray();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3][n4] = n3 == n4 ? 1.0 : 0.0;
                ++n4;
            }
            ++n3;
        }
        return matrix;
    }

    public void print(int n, int n2) {
        this.print(new PrintWriter(System.out, true), n, n2);
    }

    public void print(PrintWriter printWriter, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setGroupingUsed(false);
        this.print(printWriter, decimalFormat, n + 2);
    }

    public void print(NumberFormat numberFormat, int n) {
        this.print(new PrintWriter(System.out, true), numberFormat, n);
    }

    public void print(PrintWriter printWriter, NumberFormat numberFormat, int n) {
        printWriter.println();
        int n2 = 0;
        while (n2 < this.m) {
            int n3 = 0;
            while (n3 < this.n) {
                String string = numberFormat.format(this.A[n2][n3]);
                int n4 = Math.max(1, n - string.length());
                int n5 = 0;
                while (n5 < n4) {
                    printWriter.print(' ');
                    ++n5;
                }
                printWriter.print(string);
                ++n3;
            }
            printWriter.println();
            ++n2;
        }
        printWriter.println();
    }

    public static Matrix read(BufferedReader bufferedReader) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        Vector<Object> vector = new Vector<Object>();
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            vector.addElement(Double.valueOf(streamTokenizer.sval));
        } while (streamTokenizer.nextToken() == -3);
        int n2 = vector.size();
        double[] dArray = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = (Double)vector.elementAt(n3);
            ++n3;
        }
        vector.removeAllElements();
        vector.addElement(dArray);
        while (streamTokenizer.nextToken() == -3) {
            dArray = new double[n2];
            vector.addElement(dArray);
            n = 0;
            do {
                if (n >= n2) {
                    throw new IOException("Row " + vector.size() + " is too long.");
                }
                dArray[n++] = Double.valueOf(streamTokenizer.sval);
            } while (streamTokenizer.nextToken() == -3);
            if (n >= n2) continue;
            throw new IOException("Row " + vector.size() + " is too short.");
        }
        n = vector.size();
        double[][] dArrayArray = new double[n][];
        vector.copyInto((Object[])dArrayArray);
        return new Matrix(dArrayArray);
    }

    private void checkMatrixDimensions(Matrix matrix) {
        if (matrix.m != this.m || matrix.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }
}

