/*
 * Decompiled with CFR 0.152.
 */
package DateUtilities;

import DateUtilities.DateExtractor;
import StringUtilities.StringTrim;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtilities {
    private static final DateFormat DICOM_DA_FORMAT;
    private static final DateFormat DICOM_TM_FORMAT;
    private static final DateFormat DICOM_DT_FORMAT;
    private static final DateFormat ISO_DATE_FORMAT;
    private static final DateFormat ISO_DATETIME_FORMAT;
    private static final DateFormat HL7_DATETIME_FORMAT_LONG;
    private static final DateFormat HL7_DATETIME_DISPLAY_FORMAT_LONG;
    private static final DateFormat HL7_DATETIME_DISPLAY_FORMAT_SHORT;
    private static final DateFormat DISPLAY_DATETIME_FORMAT;
    private static final Pattern HL7_DATETIME_RE;
    private static final int[] HL7_DATETIME_FIELDS;
    private static final String[] HL7_DATETIME_FIELD_NAMES;
    private static final /* synthetic */ boolean $noassert;

    public static String getDicomDateString(Date date) {
        return DateUtilities.formatDate(DICOM_DA_FORMAT, date);
    }

    public static String getDicomTimeString(Date date) {
        return DateUtilities.formatDate(DICOM_TM_FORMAT, date);
    }

    public static Date parseDicomTime(String string) throws ParseException {
        String string2 = string;
        switch (string.length()) {
            case 2: {
                string2 = string2 + "0000.000";
                break;
            }
            case 4: {
                string2 = string2 + "00.000";
                break;
            }
            case 6: {
                string2 = string2 + ".000";
                break;
            }
            default: {
                String string3;
                int n = string2.indexOf(46);
                if (n != -1 && n + 1 < string2.length() && (string3 = string2.substring(n + 1)).length() <= 6) {
                    string3 = string3 + "00";
                    string2 = string2.substring(0, n + 1) + string3.substring(0, 3);
                    break;
                }
                throw new ParseException("Ill-formed Dicom Time '" + string + "', expecting HH[MM[SS[.ZZZZZZ]]]", 0);
            }
        }
        return DICOM_TM_FORMAT.parse(string2);
    }

    public static String getDicomDateTimeString(Date date) {
        return DateUtilities.formatDate(DICOM_DT_FORMAT, date);
    }

    public static Date getDate(String string) {
        return DateUtilities.getDate(string, "00:00:00");
    }

    public static String formatIsoDate(Date date) {
        return DateUtilities.formatDate(ISO_DATE_FORMAT, date);
    }

    public static String formatIsoDateTime(Date date) {
        return DateUtilities.formatDate(ISO_DATETIME_FORMAT, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String formatDate(DateFormat dateFormat, Date date) {
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            return dateFormat.format(date);
        }
    }

    public static Date parseIsoDate(String string) throws ParseException {
        return DateUtilities.parseDate(ISO_DATE_FORMAT, string);
    }

    public static Date parseIsoDateTime(String string) throws ParseException {
        return DateUtilities.parseDate(ISO_DATETIME_FORMAT, string);
    }

    public static Date parseDicomDate(String string) throws ParseException {
        return DICOM_DA_FORMAT.parse(string);
    }

    public static Date parseHl7DateTime(String string) throws ParseException {
        Matcher matcher = HL7_DATETIME_RE.matcher(string);
        if (!matcher.matches()) {
            throw new ParseException("Invalid HL7 datetime: '" + string + '\'', 0);
        }
        if (!$noassert && matcher.groupCount() != 8) {
            throw new AssertionError((Object)("expected 8 groups in match, but got " + matcher.groupCount()));
        }
        int n = HL7_DATETIME_FIELDS.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = matcher.group(n2 + 1);
            ++n2;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < nArray.length) {
            if (stringArray[n3] == null) break;
            nArray[n3] = Integer.parseInt(stringArray[n3]);
            ++n3;
        }
        if (stringArray[1] != null) {
            nArray[1] = nArray[1] - 1;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1, 0, 1, 0, 0, 0);
        gregorianCalendar.setLenient(false);
        gregorianCalendar.set(14, 0);
        int n4 = 0;
        while (n4 < n) {
            gregorianCalendar.set(HL7_DATETIME_FIELDS[n4], nArray[n4]);
            try {
                gregorianCalendar.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException("Invalid date '" + string + "': " + HL7_DATETIME_FIELD_NAMES[n4] + " (" + stringArray[n4] + ") is out of range", 0);
            }
            ++n4;
        }
        String string2 = matcher.group(7);
        if (string2 != null) {
            double d = Double.parseDouble(string2);
            if (!($noassert || d >= 0.0 && d <= 1.0)) {
                throw new AssertionError();
            }
            gregorianCalendar.set(14, (int)Math.round(d * 1000.0));
        }
        return gregorianCalendar.getTime();
    }

    public static String getHl7DateTime(Date date) {
        return DateUtilities.formatDate(HL7_DATETIME_FORMAT_LONG, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Date parseDate(DateFormat dateFormat, String string) throws ParseException {
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            dateFormat.setLenient(false);
            Date date = dateFormat.parse(string);
            if (date == null) {
                throw new ParseException("Invalid datetime format. Input has " + string.length() + " chars and it's not parseable (" + string + ')', 0);
            }
            return date;
        }
    }

    public static Date getDate(Date date, String string) {
        return DateUtilities.getDate(date == null ? null : DateUtilities.getDicomDateString(date), string);
    }

    public static Date getDate(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        string = string.trim();
        string2 = string2.trim();
        Pattern pattern = Pattern.compile("(\\d{4})[\\.\\/]?(\\d{2})[\\.\\/]?(\\d{2})");
        string2 = StringTrim.trimTrailingChar(string2, ".", false);
        Pattern pattern2 = Pattern.compile("(\\d{2}):?(\\d{2})(?::?(\\d{2})(\\.\\d+)?)?");
        Matcher matcher = pattern.matcher(string);
        Matcher matcher2 = pattern2.matcher(string2);
        if (matcher.matches() && matcher2.matches()) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher2.group(1)), Integer.parseInt(matcher2.group(2)));
            String string3 = matcher2.group(3);
            int n = string3 != null ? Integer.parseInt(string3) : 0;
            String string4 = matcher2.group(4);
            int n2 = string4 != null ? Math.round(Float.parseFloat(string4) * 1000.0f) : 0;
            calendar.set(13, n);
            calendar.set(14, n2);
            return calendar.getTime();
        }
        return null;
    }

    private static final Calendar dateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar changeToCurrentTimeZone(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = calendar.get(14);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3, n4, n5, n6);
        gregorianCalendar.set(14, n7);
        return gregorianCalendar;
    }

    public static String getDicomAge(String string, String string2) {
        Date date = DateUtilities.getDate(string);
        if (date == null) {
            return "ERROR: Unknown date of birth (" + string + ')';
        }
        Date date2 = DateUtilities.getDate(string2);
        if (date2 == null) {
            return "ERROR: Unknown study date (" + string2 + ')';
        }
        return DateUtilities.getDicomAge(date, date2);
    }

    public static boolean isPediatricCase(String string, String string2, int n) {
        Date date = DateUtilities.getDate(string);
        if (date == null) {
            throw new IllegalStateException("ERROR: Unknown date of birth (" + string + ')');
        }
        Date date2 = DateUtilities.getDate(string2);
        if (date2 == null) {
            throw new IllegalStateException("ERROR: Unknown study date (" + string2 + ')');
        }
        int n2 = DateUtilities.ageInYears(date, date2);
        boolean bl = false;
        if (n2 < n) {
            bl = true;
        }
        return bl;
    }

    public static String getDicomAge(Date date, Date date2) {
        if (!$noassert && date == null) {
            throw new AssertionError();
        }
        if (!$noassert && date2 == null) {
            throw new AssertionError();
        }
        int n = DateUtilities.ageInYears(date, date2);
        int n2 = DateUtilities.ageInMonths(date, date2);
        long l = DateUtilities.ageInDays(date, date2);
        String string = "00";
        string = n >= 3 ? string + n + 'Y' : (n2 >= 3 ? string + n2 + 'M' : string + l + 'D');
        return string.substring(string.length() - 4);
    }

    public static int ageInYears(String string, String string2) {
        return DateUtilities.ageInYears(DateUtilities.getDate(string), DateUtilities.getDate(string2));
    }

    public static int ageInYears(Date date, Date date2) {
        Calendar calendar = DateUtilities.dateToCalendar(date);
        Calendar calendar2 = DateUtilities.dateToCalendar(date2);
        int n = calendar2.get(1) - calendar.get(1);
        Calendar calendar3 = (Calendar)calendar.clone();
        calendar3.add(1, n);
        if (calendar2.before(calendar3) && n > 0) {
            --n;
        }
        return n;
    }

    public static int ageInMonths(String string, String string2) {
        return DateUtilities.ageInMonths(DateUtilities.getDate(string), DateUtilities.getDate(string2));
    }

    public static int ageInMonths(Date date, Date date2) {
        Calendar calendar = DateUtilities.dateToCalendar(date);
        Calendar calendar2 = DateUtilities.dateToCalendar(date2);
        int n = calendar2.get(2) - calendar.get(2) + 12 * (calendar2.get(1) - calendar.get(1));
        if (calendar2.get(5) < calendar.get(5) && n > 0) {
            --n;
        }
        return n;
    }

    public static long ageInDays(String string, String string2) {
        return DateUtilities.ageInDays(DateUtilities.getDate(string), DateUtilities.getDate(string2));
    }

    public static long ageInDays(Date date, Date date2) {
        TimeZone timeZone = DateUtilities.dateToCalendar(date).getTimeZone();
        long l = date2.getTime() - date.getTime();
        if (timeZone.inDaylightTime(date) || timeZone.inDaylightTime(date2)) {
            l += 3600000L;
        }
        return l / 86400000L;
    }

    public static String formatHl7Timestamp(String string) {
        try {
            DateFormat dateFormat = string.length() <= 8 ? HL7_DATETIME_DISPLAY_FORMAT_SHORT : HL7_DATETIME_DISPLAY_FORMAT_LONG;
            return DateUtilities.formatDate(dateFormat, DateUtilities.parseHl7DateTime(string));
        }
        catch (ParseException parseException) {
            return string;
        }
    }

    public static String getDisplayDateTimeString(Date date) {
        return DateUtilities.formatDate(DISPLAY_DATETIME_FORMAT, date);
    }

    public static Date convertTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    public static int daysElapsedSince(Date date, Date date2) {
        long l = date.getTime() - date2.getTime();
        return Math.round(l / 86400000L);
    }

    public static Date getRelativeDate(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static Date getStudyDateTime(int n, float f) {
        DateExtractor dateExtractor = new DateExtractor();
        dateExtractor.setDateToParse(n + "000000");
        dateExtractor.setSecondsSinceMidnightToParse("" + f);
        return dateExtractor.getCalendar().getTime();
    }

    static {
        $noassert = Class.forName("[LDateUtilities.DateUtilities;").getComponentType().desiredAssertionStatus() ^ true;
        DICOM_DA_FORMAT = new SimpleDateFormat("yyyyMMdd");
        DICOM_TM_FORMAT = new SimpleDateFormat("HHmmss.SSS");
        DICOM_DT_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
        ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        ISO_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        HL7_DATETIME_FORMAT_LONG = new SimpleDateFormat("yyyyMMddHHmmss");
        HL7_DATETIME_DISPLAY_FORMAT_LONG = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        HL7_DATETIME_DISPLAY_FORMAT_SHORT = new SimpleDateFormat("yyyy-MM-dd");
        DISPLAY_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        HL7_DATETIME_RE = Pattern.compile("(\\d{4})(?: (\\d{2}) (?: (\\d{2}) (?: (\\d{2}) (?: (\\d{2}) (?: (\\d{2}) (\\.\\d{1,4})?)?)?)?)?)?([\\+\\-]\\d{4})?", 4);
        HL7_DATETIME_FIELDS = new int[]{1, 2, 5, 11, 12, 13};
        HL7_DATETIME_FIELD_NAMES = new String[]{"year", "month", "day-of-month", "hour", "minute", "second"};
    }
}

