/*
 * Decompiled with CFR 0.152.
 */
package Gui;

import Gui.ArgumentParseException;
import Gui.GlobalState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ArgumentParser {
    private static final char PACS_KEY_SEPARATOR = '^';
    private static final String HELP = "-help";
    private static final String KILL = "-kill";
    private static final String HIDE = "-hide";
    private static final String XML_SERVLET_URL = "-xmlServletUrl:";
    private static final String ACCESSION_NUMBER = "-accessionNumber:";
    private static final String REQUESTED_PROCEDURE_ID = "-requestedProcedureId:";
    private static final String USER_NAME = "-username:";
    private static final String PATIENT_ID = "-patientId:";
    private static final String MAC_ADDRESS = "-macAddress:";
    private static final String CLIENT_ID = "-clientId:";
    private String mXmlDataServletUrl;
    private String mAccessionNumber;
    private String mRequestedProcedureId;
    private String mUsername;
    private String mPatientId;
    private String mMacAddress;
    private String mClientId;
    private String[] mArgs;

    private final void checkForPacsKey() {
        if (this.mRequestedProcedureId == null && this.mAccessionNumber != null && this.mAccessionNumber.indexOf(94) > 0) {
            GlobalState.trace("ArgumentParser: no requested procedure ID provided, but accession number [" + this.mAccessionNumber + "] is a PACS key since it contains a '^'. Will parse it to extract the accession number and the requested procedure ID.");
            String string = this.mAccessionNumber;
            int n = string.indexOf(94);
            this.mAccessionNumber = string.substring(0, n);
            this.mRequestedProcedureId = string.substring(n + 1);
        }
    }

    private final String[] readStream(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parse(String[] stringArray) throws ArgumentParseException {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!string.startsWith("-")) throw new ArgumentParseException("Unknown commandline argument: " + string);
            if (string.startsWith(XML_SERVLET_URL) && string.substring(XML_SERVLET_URL.length()).length() > 0) {
                this.mXmlDataServletUrl = string.substring(XML_SERVLET_URL.length());
            } else if (string.startsWith(ACCESSION_NUMBER) && string.substring(ACCESSION_NUMBER.length()).length() > 0) {
                this.mAccessionNumber = string.substring(ACCESSION_NUMBER.length());
            } else if (string.startsWith(REQUESTED_PROCEDURE_ID) && string.substring(REQUESTED_PROCEDURE_ID.length()).length() > 0) {
                this.mRequestedProcedureId = string.substring(REQUESTED_PROCEDURE_ID.length());
            } else if (string.startsWith(USER_NAME) && string.substring(USER_NAME.length()).length() > 0) {
                this.mUsername = string.substring(USER_NAME.length());
            } else if (string.startsWith(PATIENT_ID) && string.substring(PATIENT_ID.length()).length() > 0) {
                this.mPatientId = string.substring(PATIENT_ID.length());
            } else if (string.startsWith(MAC_ADDRESS) && string.substring(MAC_ADDRESS.length()).length() > 0) {
                this.mMacAddress = string.substring(MAC_ADDRESS.length());
            } else if (string.startsWith(CLIENT_ID) && string.substring(CLIENT_ID.length()).length() > 0) {
                this.mClientId = string.substring(CLIENT_ID.length());
            } else if (string.startsWith(KILL)) {
                GlobalState.setReadyToExit(true);
            } else if (string.startsWith(HIDE)) {
                GlobalState.setHideGui(true);
            } else {
                if (!string.startsWith(HELP)) throw new ArgumentParseException("Unknown commandline argument: " + string);
                ArgumentParser.printUsage();
            }
            ++n;
        }
        this.checkForPacsKey();
    }

    public String getXmlDataServletUrl() {
        return this.mXmlDataServletUrl;
    }

    public String getAccessionNumber() {
        return this.mAccessionNumber;
    }

    public String getRequestedProcedureId() {
        return this.mRequestedProcedureId;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPatientId() {
        return this.mPatientId;
    }

    public String getMacAddress() {
        return this.mMacAddress;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public static void printUsage() {
        System.out.println("Intelerad Report Viewer Command-line Usage:");
        System.out.println("     -help");
        System.out.println("     -kill");
        System.out.println("     -hide");
        System.out.println("     -xmlServletUrl:<url>");
        System.out.println("     -accessionNumber:<number>");
        System.out.println("     -requestedProcedureId:<number>");
        System.out.println("     -username:<name>");
        System.out.println("     -patientId:<id>");
        System.out.println("     -macAddress:<mac>");
        System.out.println("     -clientId:<id>");
    }

    public ArgumentParser(String[] stringArray) throws ArgumentParseException {
        this.mArgs = stringArray;
        this.parse(stringArray);
    }

    public ArgumentParser(InputStream inputStream) throws ArgumentParseException {
        try {
            this.mArgs = this.readStream(inputStream);
            this.parse(this.mArgs);
        }
        catch (IOException iOException) {
            ArgumentParseException argumentParseException = new ArgumentParseException(iOException.toString());
            argumentParseException.setStackTrace(iOException.getStackTrace());
            throw argumentParseException;
        }
    }
}

