/*
 * Decompiled with CFR 0.152.
 */
package Gui;

import DataModels.UserModels.PrivilegeSet;
import Gui.ArgumentParseException;
import Gui.ArgumentParser;
import Gui.GlobalState;
import Gui.MultipleInvocationsServer;
import GuiUtilities.Icon.IconCache;
import GuiUtilities.Util.GuiUtilities;
import Preferences.ClientPreferenceProvider;
import ReportViewerLibrary.Export.ExportConfiguration;
import ReportViewerLibrary.Export.PrintableLogoImageProvider;
import ReportViewerLibrary.Gui.ActionHandler;
import ReportViewerLibrary.Gui.ReportViewer;
import ReportViewerLibrary.RisDataClient.AuthenticationException;
import ReportViewerLibrary.RisDataClient.IncompatibleSchemaException;
import ReportViewerLibrary.RisDataClient.RisDataClient;
import ReportViewerLibrary.RisDataClient.RisDataException;
import RuntimeTool.DebugManager;
import UserXml.ErrorCode;
import UserXml.Root;
import UserXml.Status;
import UserXml.StatusCode;
import UserXml.XmlUser;
import com.intelerad.systemutilities.lib.SystemUtilities;
import com.intelerad.tools.lib.PredicateUtils;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReportViewerClient
extends JFrame {
    private static ReportViewerClient mClient = null;
    private static IconCache mIconCache = new IconCache();
    private ReportViewer mViewer;
    private JPanel mControlPanel;
    private boolean mIsInitialized;

    public static ReportViewerClient getInstance() {
        if (mClient == null) {
            mClient = new ReportViewerClient();
            mClient.getContentPane().setLayout(new BorderLayout());
            mClient.setIconImage(mIconCache.getImageIcon("/Gui/Icons/reports.png").getImage());
            mClient.addExitListener();
        }
        return mClient;
    }

    public boolean updateContent(String string, String string2, String string3) {
        try {
            Object object;
            XmlUser xmlUser;
            XmlUser xmlUser2 = null;
            if (this.mViewer != null) {
                xmlUser2 = this.getUser();
                this.getContentPane().removeAll();
                this.mViewer = null;
            }
            if ((xmlUser = this.loadUser(xmlUser2)) != null && !xmlUser.getPrivileges().getPrivilegeList().contains(PrivilegeSet.VIEW_REPORT)) {
                object = "User " + xmlUser.getUsername() + " does not have report viewing privileges.";
                JOptionPane.showMessageDialog(mClient, "ReportViewerError : " + (String)object, "Report Viewer Error", 0);
                GlobalState.error((String)object);
                System.exit(0);
            }
            if (((RisDataClient)(object = new RisDataClient(string, GlobalState.getDebug()))).getReportData().getOrderList().getNumberOfOrders() <= 0) {
                JOptionPane.showMessageDialog(mClient, "There are no reports for this patient", "Report Viewer", 1);
                GlobalState.trace("There are no reports for this patient");
                this.dispose();
                return false;
            }
            this.mViewer = new ReportViewer(this, ((RisDataClient)object).getReportData(), xmlUser, new URL(string), string2, string3, GlobalState.getPreferenceProvider(), this.createActionHandler(), this.getPrintableLogoImageProvider(), new ExportConfiguration(), null, PredicateUtils.TRUE, GlobalState.mDebug);
            this.getContentPane().add("South", this.getControlPanel());
            this.getContentPane().add("Center", this.mViewer);
            this.getContentPane().validate();
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(mClient, "Report Viewer Error : Unable to connect to server with URL provided.", "Report Viewer Error", 0);
            GlobalState.error("Unalbe to connect to server", malformedURLException);
            this.dispose();
            return false;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(mClient, "Report Viewer Error : Unable to connect to server, IO error", "Report Viewer Error", 0);
            GlobalState.error("Unable to connect to server", iOException);
            this.dispose();
            return false;
        }
        catch (IncompatibleSchemaException incompatibleSchemaException) {
            JOptionPane.showMessageDialog(mClient, incompatibleSchemaException.getMessage(), "Report Viewer Error", 0);
            GlobalState.error("Incompatible schema", incompatibleSchemaException);
            this.dispose();
            return false;
        }
        catch (AuthenticationException authenticationException) {
            JOptionPane.showMessageDialog(mClient, "Failed user authentication. Your session might be expired.\nPlease exit the application, renew your session, and try again.", "Report Viewer", 0);
            GlobalState.error("User authentication failed", authenticationException);
            this.dispose();
            return false;
        }
        catch (RisDataException risDataException) {
            JOptionPane.showMessageDialog(mClient, "Report Viewer Error : Unable to connect to server.", "Report Viewer Error", 0);
            GlobalState.error("Report Viewer Error : Unable to connect to server.", risDataException);
            this.dispose();
            return false;
        }
    }

    private final void showViewer() {
        Dimension dimension = GuiUtilities.getScreenSize();
        this.setSize((int)(GlobalState.getPreferenceProvider().getMainWindowWidth() * dimension.getWidth()), (int)(GlobalState.getPreferenceProvider().getMainWindowHeight() * dimension.getHeight()));
        this.setLocation((int)(GlobalState.getPreferenceProvider().getMainWindowX() * dimension.getWidth()), (int)(GlobalState.getPreferenceProvider().getMainWindowY() * dimension.getHeight()));
        mClient.show();
        this.mIsInitialized = true;
    }

    public void show() {
        super.show();
        if (this.mViewer != null) {
            this.mViewer.resetAlwaysOnTop();
        }
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    private final JPanel getControlPanel() {
        if (this.mControlPanel == null) {
            this.mControlPanel = new JPanel();
            this.mControlPanel.setBorder(new EmptyBorder(0, 12, 6, 12));
            JLabel jLabel = new JLabel(mIconCache.getImageIcon("/Gui/Icons/intelerad_logo.gif"));
            JPanel jPanel = this.mViewer.createButtonsPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.mControlPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.mControlPanel.add(jLabel);
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.mControlPanel.add(jPanel);
        }
        return this.mControlPanel;
    }

    private final void addExitListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ ReportViewerClient this$0;

            public final void windowClosing(WindowEvent windowEvent) {
                this.this$0.dispose();
            }
            {
                this.this$0 = reportViewerClient;
            }
        });
    }

    private final ActionHandler createActionHandler() {
        return new ActionHandler(this){
            final /* synthetic */ ReportViewerClient this$0;

            protected final ReportViewer getReportViewer() {
                return ReportViewerClient.access$0(this.this$0);
            }

            protected final void close() {
                this.this$0.dispose();
            }
            {
                this.this$0 = reportViewerClient;
            }
        };
    }

    private final PrintableLogoImageProvider getPrintableLogoImageProvider() {
        URL uRL;
        try {
            uRL = new URL(GlobalState.getArgumentParser().getXmlDataServletUrl());
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
            String string = "Could not create URL from GlobalState.getArgumentParser().getXmlDataServletUrl(): " + GlobalState.getArgumentParser().getXmlDataServletUrl();
            DebugManager.getDefault().printException(string, malformedURLException);
        }
        return new PrintableLogoImageProvider(uRL);
    }

    private final void loadUserPreferences() {
        GlobalState.setPreferenceProvider(new ClientPreferenceProvider(GlobalState.getArgumentParser().getUsername()));
    }

    private final XmlUser getUser() {
        if (this.mViewer == null) {
            return null;
        }
        return this.mViewer.getUser();
    }

    public XmlUser loadUser(XmlUser xmlUser) {
        try {
            if (xmlUser != null && xmlUser.getUsername().equals(GlobalState.getArgumentParser().getUsername()) && !GlobalState.getServerChanged()) {
                GlobalState.trace("User [" + xmlUser.getUsername() + "] already loaded from same server in a previous invocation.");
                return xmlUser;
            }
            URL uRL = GlobalState.getLoadUserUrlBase();
            GlobalState.trace("Loading user through URL [" + uRL + ']');
            URLConnection uRLConnection = uRL.openConnection();
            GlobalState.trace("Connected successfully.");
            InputStream inputStream = uRLConnection.getInputStream();
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"UserXml", (ClassLoader)this.getClass().getClassLoader());
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            GlobalState.trace("Parsing input");
            Root root = (Root)unmarshaller.unmarshal(inputStream);
            if (root == null) {
                GlobalState.error("Unmarshaller returned null when parsing input");
                return null;
            }
            Status status = root.getStatus();
            if (status == null) {
                GlobalState.error("Unable to obtain Status from XML data");
                return null;
            }
            if (status.getStatusCode() == StatusCode.ERROR) {
                ErrorCode errorCode = status.getErrorCode();
                String string = status.getDetails().getValue();
                GlobalState.error("XmlDataServlet returned ERROR Status. Error details: " + errorCode.toString() + " [" + string + ']');
                return null;
            }
            GlobalState.trace("XmlDataServlet returned OK Status. Returning user.");
            return root.getUser();
        }
        catch (Exception exception) {
            GlobalState.error("Caught Exception in UserLoader.loadUser. Returning null", exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        GlobalState.trace("Starting ReportViewerClient...");
        GlobalState.trace("Version information:\nREPORT_VIEWER_CLIENT-VER-1-9-8-P2\nREPORT_VIEWER_LIBRARY-VER-1-12-18-P2-B4\nXML_SCHEMAS-VER-1-13-2-P7-B4\nJAVA_GUI_UTILITIES-VER-1-5-52-P1-B10\nPACS-3-4-1-P107");
        SystemUtilities.logSystemInformation(GlobalState.mDebug);
        GlobalState.trace("Disabling DirectDraw");
        SystemUtilities.disableDirectDraw();
        if (stringArray.length <= 0 || stringArray[0] == null) {
            JOptionPane.showMessageDialog(mClient, "Report Viewer Error : Please provide a valid report viewer URL argument.", "Report Viewer Error", 0);
            GlobalState.error("Need to provide a valid report viewer URL argument.");
            System.exit(0);
        }
        try {
            GlobalState.setArgumentParser(new ArgumentParser(stringArray));
            GlobalState.trace("Xml Server URL = " + GlobalState.getArgumentParser().getXmlDataServletUrl());
            GlobalState.trace("Accession Number = " + GlobalState.getArgumentParser().getAccessionNumber());
            GlobalState.trace("Requested Procedure ID = " + GlobalState.getArgumentParser().getRequestedProcedureId());
            GlobalState.trace("Username = " + GlobalState.getArgumentParser().getUsername());
            GlobalState.trace("Patient ID = " + GlobalState.getArgumentParser().getPatientId());
            GlobalState.trace("Mac Address = " + GlobalState.getArgumentParser().getMacAddress());
            GlobalState.trace("Client = " + GlobalState.getArgumentParser().getClientId());
            GlobalState.trace("Hide? = " + GlobalState.getHideGui());
            GlobalState.trace("Kill? = " + GlobalState.isReadyToExit());
        }
        catch (ArgumentParseException argumentParseException) {
            GlobalState.error("Commandline argument error: ", argumentParseException);
            System.exit(0);
        }
        ReportViewerClient.getInstance();
        MultipleInvocationsServer multipleInvocationsServer = new MultipleInvocationsServer(mClient);
        if (!multipleInvocationsServer.connect(stringArray)) {
            mClient.updateContent(GlobalState.getArgumentParser().getXmlDataServletUrl(), GlobalState.getArgumentParser().getAccessionNumber(), GlobalState.getArgumentParser().getRequestedProcedureId());
            GlobalState.trace("ReportViewerClient.main(): About to show GUI");
            mClient.showViewer();
        }
    }

    static /* synthetic */ ReportViewer access$0(ReportViewerClient reportViewerClient) {
        return reportViewerClient.mViewer;
    }

    private final /* synthetic */ void this() {
        this.mIsInitialized = false;
    }

    private ReportViewerClient() {
        super("Intelerad Report Viewer");
        this.this();
        GlobalState.trace("Starting Inteleard Report Viewer Client");
        this.loadUserPreferences();
    }
}

