/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Icon;

import java.awt.Image;
import javax.swing.ImageIcon;

public class ScaledImageIcon
extends ImageIcon {
    private ImageIcon mOriginalImageIcon;

    private final void initOriginalImageIcon(ImageIcon imageIcon) {
        this.mOriginalImageIcon = imageIcon instanceof ScaledImageIcon ? ((ScaledImageIcon)imageIcon).mOriginalImageIcon : imageIcon;
    }

    private final void scaleHeight(int n) {
        int n2 = this.mOriginalImageIcon.getIconWidth() * n / this.mOriginalImageIcon.getIconHeight();
        this.setSize(n2, n);
    }

    private final void setSize(int n, int n2) {
        this.setImage(this.mOriginalImageIcon.getImage().getScaledInstance(n, n2, 4));
    }

    public ScaledImageIcon(Image image) {
        this(new ImageIcon(image));
    }

    public ScaledImageIcon(ImageIcon imageIcon) {
        this(imageIcon, imageIcon.getIconHeight());
    }

    public ScaledImageIcon(ImageIcon imageIcon, int n) {
        super(imageIcon.getImage());
        this.initOriginalImageIcon(imageIcon);
        this.scaleHeight(n);
    }

    public ScaledImageIcon(ImageIcon imageIcon, int n, int n2) {
        super(imageIcon.getImage());
        this.initOriginalImageIcon(imageIcon);
        this.setSize(n, n2);
    }
}

